/*
 * Decompiled with CFR 0.152.
 */
package util;

import execution.IDrawable;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import math.Maths;

public class Bounds
implements IDrawable {
    private Point2D.Double _center;
    private Line2D.Double _top;
    private Line2D.Double _right;
    private Line2D.Double _bottom;
    private Line2D.Double _left;
    private double _halfWidth;
    private double _halfHeight;

    public Bounds(Point2D.Double center, double width, double height) {
        this._center = center;
        this._halfHeight = height / 2.0;
        this._halfWidth = width / 2.0;
        double left = center.getX() - this._halfWidth;
        double right = center.getX() + this._halfWidth;
        double top = center.getY() + this._halfHeight;
        double bottom = center.getY() - this._halfHeight;
        this.Init(top, right, bottom, left);
    }

    public Bounds(double width, double height) {
        this._halfHeight = height / 2.0;
        this._halfWidth = width / 2.0;
        this._center = new Point2D.Double(this._halfWidth, this._halfHeight);
        this.Init(height, width, 0.0, 0.0);
    }

    public void Move(Point2D.Double center) {
        this._center = center;
        double left = this._center.getX() - this._halfWidth;
        double right = this._center.getX() + this._halfWidth;
        double top = this._center.getY() + this._halfHeight;
        double bottom = this._center.getY() - this._halfHeight;
        this._top.setLine(left, top, right, top);
        this._right.setLine(right, bottom, right, top);
        this._bottom.setLine(left, bottom, right, bottom);
        this._left.setLine(left, bottom, left, top);
    }

    private void Init(double top, double right, double bottom, double left) {
        this._top = new Line2D.Double(left, top, right, top);
        this._right = new Line2D.Double(right, bottom, right, top);
        this._bottom = new Line2D.Double(left, bottom, right, bottom);
        this._left = new Line2D.Double(left, bottom, left, top);
    }

    public boolean IntersectsCircle(Ellipse2D.Double circle) {
        double cY;
        double radius = circle.getWidth() / 2.0;
        double cX = circle.getCenterX();
        if (Maths.CircleIntersectsLine(cX, cY = circle.getCenterY(), radius, this._top)) {
            return true;
        }
        if (Maths.CircleIntersectsLine(cX, cY, radius, this._right)) {
            return true;
        }
        if (Maths.CircleIntersectsLine(cX, cY, radius, this._bottom)) {
            return true;
        }
        return Maths.CircleIntersectsLine(cX, cY, radius, this._left);
    }

    public boolean IntersectsLine(Line2D.Double line) {
        if (line.intersectsLine(this._top)) {
            return true;
        }
        if (line.intersectsLine(this._right)) {
            return true;
        }
        if (line.intersectsLine(this._bottom)) {
            return true;
        }
        return line.intersectsLine(this._left);
    }

    public Point2D.Double GetLineIntersectionSingle(Line2D.Double line) {
        Point2D.Double top = Maths.GetIntersectionPoint(line, this._top);
        if (top != null) {
            return top;
        }
        Point2D.Double right = Maths.GetIntersectionPoint(line, this._right);
        if (right != null) {
            return right;
        }
        Point2D.Double bottom = Maths.GetIntersectionPoint(line, this._bottom);
        if (bottom != null) {
            return bottom;
        }
        Point2D.Double left = Maths.GetIntersectionPoint(line, this._left);
        if (left != null) {
            return left;
        }
        return null;
    }

    public boolean ContainsPoint(Point2D.Double point) {
        return point.getX() >= this._top.getX1() && point.getX() <= this._top.getX2() && point.getY() >= this._left.getY1() && point.getY() <= this._left.getY2();
    }

    public boolean InsideCircle(Ellipse2D.Double circle) {
        double cY;
        double radius = circle.getWidth() / 2.0;
        double cX = circle.getCenterX();
        if (!Maths.CircleContainsLine(cX, cY = circle.getCenterY(), radius, this._top)) {
            return false;
        }
        if (!Maths.CircleContainsLine(cX, cY, radius, this._right)) {
            return false;
        }
        if (!Maths.CircleContainsLine(cX, cY, radius, this._bottom)) {
            return false;
        }
        return Maths.CircleContainsLine(cX, cY, radius, this._left);
    }

    public void OnPaint(Graphics2D e) {
        e.draw(this._top);
        e.draw(this._right);
        e.draw(this._bottom);
        e.draw(this._left);
    }

    @Override
    public void Draw(Graphics2D e) {
        e.draw(this._top);
        e.draw(this._right);
        e.draw(this._bottom);
        e.draw(this._left);
    }

    public static enum Side {
        TOP,
        RIGHT,
        BOTTOM,
        LEFT;

    }
}

