/*
 * Decompiled with CFR 0.152.
 */
package krillr.mega.movements;

import java.util.Random;
import krillr.mega.utils.KrillrRobot;
import krillr.mega.utils.Movement;
import krillr.mega.utils.MovementManager;
import krillr.mega.utils.Point2d;
import krillr.mega.utils.UnitInfo;
import robocode.util.Utils;

public class ChumbaMover
extends Movement {
    static final double FOUR_QUARTERS = Math.PI * 2;
    static final double ONE_QUARTER = 1.5707963267948966;
    static final double ONE_EIGHTH = 0.7853981633974483;
    static final double ONE_QUARTER_PLUS_DEGREE = 1.5882463267948965;
    static double _direction = 1.0;
    static double movementLateralAngle = 0.2;
    public Random rand = new Random();

    public ChumbaMover(KrillrRobot b, MovementManager MM) {
        this.bot = b;
        this.mm = MM;
        this.name = "ChumbaMover";
    }

    public void handleTurn(long t) {
        if (this.bot.currentTarget == null) {
            return;
        }
        this.weight += 0.01;
        UnitInfo info = this.bot.currentTarget.info();
        Point2d robotLocation = this.bot.location();
        double enemyAbsoluteBearing = info.bearing(this.bot.location());
        double enemyDistance = info.distance(this.bot.location());
        Point2d enemyLocation = info.location;
        double flattenerFactor = 0.05;
        if (Math.random() < flattenerFactor) {
            movementLateralAngle *= -1.0;
        }
        Point2d robotDestination = null;
        double tries = 0.0;
        do {
            robotDestination = ChumbaMover.vectorToLocation(enemyLocation.bearing(robotLocation) + movementLateralAngle, enemyDistance * (1.1 - tries / 100.0), enemyLocation);
        } while ((tries += 1.0) < 100.0 && !this.mm.fieldRectWithMargins.contains(robotDestination));
        double angle = Utils.normalRelativeAngle((double)(robotLocation.bearing(robotDestination) - this.bot.getHeadingRadians()));
        double turnAngle = Math.atan(Math.tan(angle));
        this.bot.setTurnRightRadians(turnAngle + Math.toRadians(this.rand.nextInt(15)) * (double)(this.rand.nextInt(1) == 1 ? 1 : -1));
        this.bot.setAhead(robotLocation.distance(robotDestination) * (double)(angle == turnAngle ? 1 : -1));
        double currentSpeed = Math.abs(this.bot.getTurnRemaining()) > 33.0 ? 2.0 : 8.0;
        this.bot.setMaxVelocity(currentSpeed);
    }

    private static Point2d vectorToLocation(double angle, double length, Point2d sourceLocation) {
        return ChumbaMover.vectorToLocation(angle, length, sourceLocation, new Point2d());
    }

    private static Point2d vectorToLocation(double angle, double length, Point2d sourceLocation, Point2d targetLocation) {
        targetLocation.setLocation(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
        return targetLocation;
    }
}

