/*
 * Decompiled with CFR 0.152.
 */
package krillr.mega.utils;

import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Iterator;
import krillr.mega.utils.KrillrRobot;
import krillr.mega.utils.Message;
import krillr.mega.utils.Module;
import krillr.mega.utils.UnitInfo;
import krillr.mega.utils.UnitTracker;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.MessageEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class BattleTracker
extends Module {
    public HashMap units = new HashMap();
    public UnitTracker parentTracker;

    public BattleTracker(KrillrRobot b) {
        this.bot = b;
        this.parentTracker = new UnitTracker(this.bot.getName(), this.bot);
    }

    public void addUnit(ScannedRobotEvent e) {
        String name = e.getName();
        if (this.units.containsKey(name)) {
            UnitTracker unit = (UnitTracker)this.units.get(name);
            unit.update(e);
            this.units.put(name, unit);
        } else {
            UnitTracker unit = new UnitTracker(name, this.bot);
            unit.update(e);
            this.units.put(name, unit);
        }
    }

    public void addUnit(Message m) {
        String name = (String)m.data.get("name");
        if (this.units.containsKey(name)) {
            UnitTracker unit = (UnitTracker)this.units.get(name);
            unit.update(m);
            this.units.put(name, unit);
        } else {
            UnitTracker unit = new UnitTracker(name, this.bot);
            unit.update(m);
            this.units.put(name, unit);
        }
    }

    public void removeUnit(String n) {
        if (this.units.containsKey(n)) {
            this.units.remove(n);
        }
    }

    public UnitTracker getUnit(String n) {
        if (this.units.containsKey(n)) {
            return (UnitTracker)this.units.get(n);
        }
        return null;
    }

    public UnitTracker getClosestUnit(boolean includeTeammates) {
        double lowestDistance = 0.0;
        UnitTracker closestUnit = null;
        for (UnitTracker unit : this.units.values()) {
            UnitInfo info = unit.info();
            if (!(info.distance(this.bot.location()) < lowestDistance | lowestDistance == 0.0)) continue;
            closestUnit = unit;
            lowestDistance = info.distance(this.bot.location());
        }
        return closestUnit;
    }

    public UnitTracker getDangerousUnit(boolean includeTeammates) {
        for (UnitTracker unitTracker : this.units.values()) {
        }
        return null;
    }

    public void handleTurn(long t) {
        this.parentTracker.update(this.bot);
        this.parentTracker.handleTurn(t);
        for (UnitTracker unit : this.units.values()) {
            unit.handleTurn(t);
        }
    }

    public void handleScan(ScannedRobotEvent e) {
        this.addUnit(e);
        this.parentTracker.handleScan(e);
        for (UnitTracker unit : this.units.values()) {
            unit.handleScan(e);
        }
    }

    public void handleBulletHit(BulletHitEvent e) {
        Iterator it = this.units.values().iterator();
        this.parentTracker.handleBulletHit(e);
        while (it.hasNext()) {
            UnitTracker unit = (UnitTracker)it.next();
            unit.handleBulletHit(e);
        }
    }

    public void handleBulletHitBullet(BulletHitBulletEvent e) {
        Iterator it = this.units.values().iterator();
        this.parentTracker.handleBulletHitBullet(e);
        while (it.hasNext()) {
            UnitTracker unit = (UnitTracker)it.next();
            unit.handleBulletHitBullet(e);
        }
    }

    public void handleBulletMissed(BulletMissedEvent e) {
        Iterator it = this.units.values().iterator();
        this.parentTracker.handleBulletMissed(e);
        while (it.hasNext()) {
            UnitTracker unit = (UnitTracker)it.next();
            unit.handleBulletMissed(e);
        }
    }

    public void handleHitByBullet(HitByBulletEvent e) {
        Iterator it = this.units.values().iterator();
        this.parentTracker.handleHitByBullet(e);
        while (it.hasNext()) {
            UnitTracker unit = (UnitTracker)it.next();
            unit.handleHitByBullet(e);
        }
    }

    public void handleHitRobot(HitRobotEvent e) {
        Iterator it = this.units.values().iterator();
        this.parentTracker.handleHitRobot(e);
        while (it.hasNext()) {
            UnitTracker unit = (UnitTracker)it.next();
            unit.handleHitRobot(e);
        }
    }

    public void handleHitWall(HitWallEvent e) {
        Iterator it = this.units.values().iterator();
        this.parentTracker.handleHitWall(e);
        while (it.hasNext()) {
            UnitTracker unit = (UnitTracker)it.next();
            unit.handleHitWall(e);
        }
    }

    public void handleRobotDeath(RobotDeathEvent e) {
        this.removeUnit(e.getName());
        Iterator it = this.units.values().iterator();
        this.parentTracker.handleRobotDeath(e);
        while (it.hasNext()) {
            UnitTracker unit = (UnitTracker)it.next();
            unit.handleRobotDeath(e);
        }
    }

    public void handleWin(WinEvent e) {
        Iterator it = this.units.values().iterator();
        this.parentTracker.handleWin(e);
        while (it.hasNext()) {
            UnitTracker unit = (UnitTracker)it.next();
            unit.handleWin(e);
        }
    }

    public void handleDeath(DeathEvent e) {
        Iterator it = this.units.values().iterator();
        this.parentTracker.handleDeath(e);
        while (it.hasNext()) {
            UnitTracker unit = (UnitTracker)it.next();
            unit.handleDeath(e);
        }
    }

    public void handleMessage(MessageEvent e) {
        this.addUnit((Message)e.getMessage());
        Iterator it = this.units.values().iterator();
        this.parentTracker.handleMessage(e);
        while (it.hasNext()) {
            UnitTracker unit = (UnitTracker)it.next();
            unit.handleMessage(e);
        }
    }

    public void handleSkippedTurn(SkippedTurnEvent e) {
        Iterator it = this.units.values().iterator();
        this.parentTracker.handleSkippedTurn(e);
        while (it.hasNext()) {
            UnitTracker unit = (UnitTracker)it.next();
            unit.handleSkippedTurn(e);
        }
    }

    public void handlePaint(Graphics2D g) {
        Iterator it = this.units.values().iterator();
        this.parentTracker.handlePaint(g);
        while (it.hasNext()) {
            UnitTracker unit = (UnitTracker)it.next();
            unit.handlePaint(g);
        }
    }

    public void handleCustomEvent(CustomEvent e) {
        Iterator it = this.units.values().iterator();
        this.parentTracker.handleCustomEvent(e);
        while (it.hasNext()) {
            UnitTracker unit = (UnitTracker)it.next();
            unit.handleCustomEvent(e);
        }
    }

    public void handleFiredBullet(Bullet b) {
        Iterator it = this.units.values().iterator();
        this.parentTracker.handleFiredBullet(b);
        while (it.hasNext()) {
            UnitTracker unit = (UnitTracker)it.next();
            unit.handleFiredBullet(b);
        }
    }
}

