/*
 * Decompiled with CFR 0.152.
 */
package krillr.mega.utils;

import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Vector;
import krillr.mega.predictors.KrillrFactor;
import krillr.mega.utils.KrillrRobot;
import krillr.mega.utils.Message;
import krillr.mega.utils.Module;
import krillr.mega.utils.Predictor;
import krillr.mega.utils.UnitInfo;
import krillr.mega.utils.VirtualBullet;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.MessageEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class UnitTracker
extends Module {
    public String name;
    public boolean isTeammate;
    public KrillrRobot bot;
    public long updateTime = 0L;
    public long previousUpdateTime = 0L;
    Vector predictors = new Vector();
    int[] predictorWeights = new int[50];
    HashMap infoHistory = new HashMap();
    int hits = 0;
    int hitme = 0;
    double danger;

    public UnitTracker(String n, KrillrRobot b) {
        this.bot = b;
        this.name = n;
        this.isTeammate = this.bot.isTeammate(this.name);
        this.predictors.add(new KrillrFactor(this.bot, this));
    }

    public void update(ScannedRobotEvent e) {
        double d;
        UnitInfo i = new UnitInfo(e, this.bot);
        this.previousUpdateTime = this.updateTime;
        this.updateTime = this.bot.getTime();
        this.infoHistory.put(this.updateTime, i);
        double ce = i.energy;
        if (d > 100.0) {
            ce = 100.0;
        }
        this.danger = i.energy == 0.0 ? 0.0 : ce / 4.0 - (double)this.hits + (double)this.hitme - i.distance(this.bot.location()) / 5.0;
        this.updatePredictors();
    }

    public void update(Message m) {
        double d;
        UnitInfo i = new UnitInfo(m, this.bot);
        this.previousUpdateTime = this.updateTime;
        this.updateTime = this.bot.getTime();
        this.infoHistory.put(this.bot.getTime(), i);
        double ce = i.energy;
        if (d > 100.0) {
            ce = 100.0;
        }
        this.danger = i.energy == 0.0 ? 0.0 : ce / 4.0 - (double)this.hits + (double)this.hitme - i.distance(this.bot.location()) / 5.0;
        this.updatePredictors();
    }

    public void update(KrillrRobot bot) {
        UnitInfo i = new UnitInfo(bot);
        this.previousUpdateTime = this.updateTime;
        this.updateTime = bot.getTime();
        this.infoHistory.put(bot.getTime(), i);
        this.updatePredictors();
    }

    public void updatePredictors() {
        for (int i = 0; i < this.predictors.size(); ++i) {
            Predictor p = (Predictor)this.predictors.get(i);
            p.update();
        }
    }

    public Predictor getPredictor() {
        int topWeight = 0;
        Predictor predictor = null;
        for (int i = 0; i < this.predictors.size(); ++i) {
            Predictor p = (Predictor)this.predictors.get(i);
            if (!(p.weight > topWeight | topWeight == 0)) continue;
            predictor = p;
            topWeight = p.weight;
        }
        this.bot.out.println(predictor);
        return predictor;
    }

    public UnitInfo getInfo(long t) {
        if (this.infoHistory.containsKey(t)) {
            return (UnitInfo)this.infoHistory.get(t);
        }
        return null;
    }

    public UnitInfo info() {
        return this.getInfo(this.updateTime);
    }

    public UnitInfo previousInfo() {
        return this.getInfo(this.previousUpdateTime);
    }

    public UnitInfo guessInfo() {
        UnitInfo i = new UnitInfo(this.getPredictor());
        return i;
    }

    public double firedBulletEnergy() {
        UnitInfo info = this.info();
        UnitInfo previousInfo = this.previousInfo();
        if (previousInfo == null) {
            return 0.0;
        }
        double delta = previousInfo.energy - info.energy;
        if (0.0 < delta & delta <= 3.0) {
            return delta;
        }
        return 0.0;
    }

    public void fireVirtualBullets() {
        for (int i = 0; i < this.predictors.size(); ++i) {
            Predictor predictor = (Predictor)this.predictors.get(i);
            predictor.fireVirtualBullet();
        }
    }

    public void checkVirtualBullets() {
        for (int i = 0; i < this.predictors.size(); ++i) {
            Predictor predictor = (Predictor)this.predictors.get(i);
            predictor.checkVirtualBullets();
        }
    }

    public void handleTurn(long t) {
        this.fireVirtualBullets();
        this.checkVirtualBullets();
        for (int i = 0; i < this.predictors.size(); ++i) {
            Predictor predictor = (Predictor)this.predictors.get(i);
            predictor.handleTurn(t);
        }
    }

    public void handleScan(ScannedRobotEvent e) {
        for (int i = 0; i < this.predictors.size(); ++i) {
            Predictor predictor = (Predictor)this.predictors.get(i);
            predictor.handleScan(e);
        }
    }

    public void handleBulletHit(BulletHitEvent e) {
        if (e.getName() == this.name) {
            ++this.hits;
        }
        for (int i = 0; i < this.predictors.size(); ++i) {
            Predictor predictor = (Predictor)this.predictors.get(i);
            predictor.handleBulletHit(e);
        }
    }

    public void handleBulletHitBullet(BulletHitBulletEvent e) {
        for (int i = 0; i < this.predictors.size(); ++i) {
            Predictor predictor = (Predictor)this.predictors.get(i);
            predictor.handleBulletHitBullet(e);
        }
    }

    public void handleBulletMissed(BulletMissedEvent e) {
        for (int i = 0; i < this.predictors.size(); ++i) {
            Predictor predictor = (Predictor)this.predictors.get(i);
            predictor.handleBulletMissed(e);
        }
    }

    public void handleHitByBullet(HitByBulletEvent e) {
        if (e.getName() == this.name) {
            ++this.hitme;
        }
        for (int i = 0; i < this.predictors.size(); ++i) {
            Predictor predictor = (Predictor)this.predictors.get(i);
            predictor.handleHitByBullet(e);
        }
    }

    public void handleHitRobot(HitRobotEvent e) {
        for (int i = 0; i < this.predictors.size(); ++i) {
            Predictor predictor = (Predictor)this.predictors.get(i);
            predictor.handleHitRobot(e);
        }
    }

    public void handleHitWall(HitWallEvent e) {
        for (int i = 0; i < this.predictors.size(); ++i) {
            Predictor predictor = (Predictor)this.predictors.get(i);
            predictor.handleHitWall(e);
        }
    }

    public void handleRobotDeath(RobotDeathEvent e) {
        for (int i = 0; i < this.predictors.size(); ++i) {
            Predictor predictor = (Predictor)this.predictors.get(i);
            predictor.handleRobotDeath(e);
        }
    }

    public void handleWin(WinEvent e) {
        for (int i = 0; i < this.predictors.size(); ++i) {
            Predictor predictor = (Predictor)this.predictors.get(i);
            predictor.handleWin(e);
        }
    }

    public void handleDeath(DeathEvent e) {
        for (int i = 0; i < this.predictors.size(); ++i) {
            Predictor predictor = (Predictor)this.predictors.get(i);
            predictor.handleDeath(e);
        }
    }

    public void handleMessage(MessageEvent e) {
        for (int i = 0; i < this.predictors.size(); ++i) {
            Predictor predictor = (Predictor)this.predictors.get(i);
            predictor.handleMessage(e);
        }
    }

    public void handleSkippedTurn(SkippedTurnEvent e) {
        for (int i = 0; i < this.predictors.size(); ++i) {
            Predictor predictor = (Predictor)this.predictors.get(i);
            predictor.handleSkippedTurn(e);
        }
    }

    public void handlePaint(Graphics2D g) {
        for (int i = 0; i < this.predictors.size(); ++i) {
            Predictor predictor = (Predictor)this.predictors.get(i);
            predictor.handlePaint(g);
        }
    }

    public void handleCustomEvent(CustomEvent e) {
        for (int i = 0; i < this.predictors.size(); ++i) {
            Predictor predictor = (Predictor)this.predictors.get(i);
            predictor.handleCustomEvent(e);
        }
    }

    public void handleFiredBullet(Bullet b) {
        for (int i = 0; i < this.predictors.size(); ++i) {
            Predictor predictor = (Predictor)this.predictors.get(i);
            predictor.handleFiredBullet(b);
        }
    }

    public void handleVirtualBulletHit(VirtualBullet b) {
        for (int i = 0; i < this.predictors.size(); ++i) {
            Predictor predictor = (Predictor)this.predictors.get(i);
            predictor.handleVirtualBulletHit(b);
        }
    }

    public void handleVirtualBulletMissed(VirtualBullet b) {
        for (int i = 0; i < this.predictors.size(); ++i) {
            Predictor predictor = (Predictor)this.predictors.get(i);
            predictor.handleVirtualBulletMiss(b);
        }
    }
}

