/*
 * Decompiled with CFR 0.152.
 */
package jwirde;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jwirde.CoordUtils;
import jwirde.Ghost;

public class Environment {
    private Map<String, Ghost> foes = new HashMap<String, Ghost>();

    public Collection<Ghost> getFoes() {
        return Collections.unmodifiableCollection(this.foes.values());
    }

    public void removeFoe(String targetName) {
        this.foes.remove(targetName);
    }

    public void updateFoe(Ghost ghost) {
        this.foes.put(ghost.name, ghost);
    }

    public Ghost foeByName(String target) {
        return this.foes.get(target);
    }

    public void onPaint(Graphics2D g) {
        for (Ghost ghost : this.getFoes()) {
            CoordUtils.drawRobotPosition(g, Color.GREEN, ghost.coord);
        }
    }
}

