/*
 * Decompiled with CFR 0.152.
 */
package wcsv.PowerHouse.Gun;

import java.awt.geom.Point2D;
import wcsv.PowerHouse.Gun.Gun;
import wcsv.PowerHouse.Utilities.SegmentationDimension;
import wcsv.PowerHouse.Utilities.Target;
import wcsv.PowerHouse.Utilities.Utilities;
import wcsv.PowerHouse.Utilities.Wave;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GFGun
implements Gun {
    public static final double[] offsets;
    SegmentationDimension bftSegs;
    SegmentationDimension bftSegsFast;
    SegmentationDimension velocitySegs;
    SegmentationDimension velocitySegsFast;
    SegmentationDimension wallSegs;
    SegmentationDimension wallSegsFast;
    SegmentationDimension wallSegsRev;
    SegmentationDimension wallSegsRevFast;
    public double[][][][][][] buffer1;
    public double[][][][][][] buffer2;
    public double[] buffer1Data;
    public double[] buffer2Data;

    public void setSegments(Target t, Wave w) {
        int bft = SegmentationDimension.getIndex(this.bftSegs, t.distance / w.velocity);
        int bftFast = SegmentationDimension.getIndex(this.bftSegsFast, t.distance / w.velocity);
        int vel = SegmentationDimension.getIndex(this.velocitySegs, Math.abs(t.lateralVelocity));
        int velFast = SegmentationDimension.getIndex(this.velocitySegsFast, Math.abs(t.lateralVelocity));
        int rVel = SegmentationDimension.getIndex(this.velocitySegs, Math.abs(t.rollingVelocity));
        int rVelFast = SegmentationDimension.getIndex(this.velocitySegsFast, Math.abs(t.rollingVelocity));
        int wall = SegmentationDimension.wallIndex(w, this.wallSegs);
        int wallFast = SegmentationDimension.wallIndex(w, this.wallSegsFast);
        int revWall = SegmentationDimension.wallIndex(w, this.wallSegsRev);
        int revWallFast = SegmentationDimension.wallIndex(w, this.wallSegsRevFast);
        this.buffer1Data = this.buffer1[bft][vel][rVel][wall][revWall];
        this.buffer2Data = this.buffer2[bftFast][velFast][rVelFast][wallFast][revWallFast];
    }

    public double[] getBuffer(Target t, Wave w) {
        this.setSegments(t, w);
        double[] sumBuffer = new double[offsets.length];
        int i = 0;
        while (i < sumBuffer.length) {
            int n = i;
            sumBuffer[n] = sumBuffer[n] + this.buffer1Data[i] / Math.max(this.buffer1Data[offsets.length], 1.0);
            int n2 = i;
            sumBuffer[n2] = sumBuffer[n2] + this.buffer2Data[i] / Math.max(this.buffer2Data[offsets.length], 1.0);
            ++i;
        }
        return sumBuffer;
    }

    public void update(Target t, Wave w) {
        this.setSegments(w.targetRobot, w);
        double bearingChange = w.computeCentralBearingChange(t.location) * (double)w.targetRobot.orbitDir;
        double maxEscapeAngle = Utilities.maxEscapeAngle_Velocity(w.velocity);
        double mid = Utilities.getSegment(bearingChange / maxEscapeAngle, offsets);
        int n = offsets.length;
        this.buffer1Data[n] = this.buffer1Data[n] + 1.0;
        int n2 = offsets.length;
        this.buffer2Data[n2] = this.buffer2Data[n2] + 1.0;
        int j = 0;
        while (j < offsets.length) {
            double val = Math.sqrt(Math.PI / (Math.abs((double)j - mid) + 1.0));
            int n3 = j;
            this.buffer1Data[n3] = this.buffer1Data[n3] + val;
            int n4 = j++;
            this.buffer2Data[n4] = this.buffer2Data[n4] + val;
        }
    }

    public double computeFiringAngle(Target target, Target source, Wave w) {
        double[] buffer = this.getBuffer(target, w);
        int mostIndex = (int)((double)offsets.length / (double)2);
        double mostHits = buffer[mostIndex];
        int i = 0;
        while (i < offsets.length) {
            double hits = buffer[i];
            if (hits > mostHits) {
                mostIndex = i;
                mostHits = hits;
            }
            ++i;
        }
        if (mostHits == 0.0) {
            return this.circularAngle(target, source, w);
        }
        return Utilities.absoluteAngle(target.absoluteBearing + Utilities.maxEscapeAngle_Velocity(w.velocity) * offsets[mostIndex] * (double)target.orbitDir);
    }

    public double circularAngle(Target t, Target src, Wave w) {
        Point2D.Double end = new Point2D.Double(t.location.getX(), t.location.getY());
        double tr = t.calculateTurnRate();
        double heading = t.heading;
        int ticks = 0;
        while ((double)(++ticks) * w.velocity < Utilities.distance(src.location, end)) {
            end = Utilities.projectPoint(end, heading, t.velocity);
            heading += tr;
            if (end.getX() < 18.0) {
                end.setLocation(18.0, end.getY());
            }
            if (end.getX() > Utilities.fWidth - 18.0) {
                end.setLocation(Utilities.fWidth - 18.0, end.getY());
            }
            if (end.getY() < 18.0) {
                end.setLocation(end.getX(), 18.0);
            }
            if (!(end.getY() > Utilities.fHeight - 18.0)) continue;
            end.setLocation(end.getX(), Utilities.fHeight - 18.0);
        }
        return Utilities.absoluteAngleToPoint(src.location, end);
    }

    private final /* synthetic */ void this() {
        this.bftSegs = new SegmentationDimension(15.0, 55.0, 3);
        this.bftSegsFast = new SegmentationDimension(20.0, 40.0, 1);
        this.velocitySegs = new SegmentationDimension(0.0, 6.4, 4);
        this.velocitySegsFast = new SegmentationDimension(2, 6.0, 1);
        this.wallSegs = new SegmentationDimension(Math.toRadians(5), Math.toRadians(45.0), 4);
        this.wallSegsFast = new SegmentationDimension(Math.toRadians(10.0), Math.toRadians(30.0), 2);
        this.wallSegsRev = new SegmentationDimension(-Math.toRadians(10.0), -Math.toRadians(30.0), 2);
        this.wallSegsRevFast = new SegmentationDimension(-Math.toRadians(15.0), -Math.toRadians(30.0), 1);
        this.buffer1 = new double[this.bftSegs.segments + 1][this.velocitySegs.segments + 1][this.velocitySegs.segments + 1][this.wallSegs.segments + 1][this.wallSegsRev.segments + 1][offsets.length + 1];
        this.buffer2 = new double[this.bftSegsFast.segments + 1][this.velocitySegsFast.segments + 1][this.velocitySegsFast.segments + 1][this.wallSegsFast.segments + 1][this.wallSegsRevFast.segments + 1][offsets.length + 1];
    }

    public GFGun() {
        this.this();
    }

    static {
        double[] dArray = new double[41];
        dArray[0] = -1.0;
        dArray[1] = -0.95;
        dArray[2] = -0.9;
        dArray[3] = -0.85;
        dArray[4] = -0.8;
        dArray[5] = -0.75;
        dArray[6] = -0.7;
        dArray[7] = -0.65;
        dArray[8] = -0.6;
        dArray[9] = -0.55;
        dArray[10] = -0.5;
        dArray[11] = -0.45;
        dArray[12] = -0.4;
        dArray[13] = -0.35;
        dArray[14] = -0.3;
        dArray[15] = -0.25;
        dArray[16] = -0.2;
        dArray[17] = -0.15;
        dArray[18] = -0.1;
        dArray[19] = -0.05;
        dArray[21] = 0.05;
        dArray[22] = 0.1;
        dArray[23] = 0.15;
        dArray[24] = 0.2;
        dArray[25] = 0.25;
        dArray[26] = 0.3;
        dArray[27] = 0.35;
        dArray[28] = 0.4;
        dArray[29] = 0.45;
        dArray[30] = 0.5;
        dArray[31] = 0.55;
        dArray[32] = 0.6;
        dArray[33] = 0.65;
        dArray[34] = 0.7;
        dArray[35] = 0.75;
        dArray[36] = 0.8;
        dArray[37] = 0.85;
        dArray[38] = 0.9;
        dArray[39] = 0.95;
        dArray[40] = 1.0;
        offsets = dArray;
    }
}

