/*
 * Decompiled with CFR 0.152.
 */
package robo;

import java.util.Random;
import robo.AdvancedEnemyBot;
import robocode.AdvancedRobot;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class PartsBot
extends AdvancedRobot {
    private AdvancedEnemyBot enemy = new AdvancedEnemyBot();
    private Random rand = new Random();
    private RobotPart[] parts = new RobotPart[3];
    private static final int RADAR = 0;
    private static final int GUN = 1;
    private static final int TANK = 2;
    private static final double HALF_PI = 1.5707963267948966;
    private static final int WALKING_STICK = 160;
    private static final int WALL_MARGIN = 27;
    private static final int S = 27;
    private static final int W = 27;
    private int N = 573;
    private int E = 773;

    public void run() {
        this.parts[0] = new WobbleRadar();
        this.parts[1] = new LinearGun();
        this.parts[2] = this.getOthers() > 3 ? new Walls() : new StraffingTank();
        int i = 0;
        while (i < this.parts.length) {
            this.parts[i].init();
            ++i;
        }
        i = 0;
        while (true) {
            this.parts[i].move();
            if (i == 0) {
                this.execute();
            }
            i = (i + 1) % this.parts.length;
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        WobbleRadar radar = (WobbleRadar)this.parts[0];
        if (radar.shouldTrack(e)) {
            this.enemy.update(e, (Robot)this);
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        WobbleRadar radar = (WobbleRadar)this.parts[0];
        if (radar.wasTracking(e)) {
            this.enemy.reset();
        }
        if (this.getOthers() <= 3) {
            this.parts[2] = new StraffingTank();
            this.parts[2].init();
        }
    }

    public void onHitWall(HitWallEvent e) {
        this.out.println("OUCH! I hit a wall anyway!");
    }

    public void onHitRobot(HitRobotEvent e) {
        this.out.println("OUCH! I hit " + e.getName());
    }

    private double normalizeBearing(double angle) {
        while (angle > 180.0) {
            angle -= 360.0;
        }
        while (angle < -180.0) {
            angle += 360.0;
        }
        return angle;
    }

    private double absoluteBearing(double x1, double y1, double x2, double y2) {
        return Math.toDegrees(Math.atan2(x2 - x1, y2 - y1));
    }

    private double smooth(double angle, int oDir) {
        angle = this.smoothWest((double)this.N - this.getY(), angle - 1.5707963267948966, oDir) + 1.5707963267948966;
        angle = this.smoothWest((double)this.E - this.getX(), angle + Math.PI, oDir) - Math.PI;
        angle = this.smoothWest(this.getY() - 27.0, angle + 1.5707963267948966, oDir) - 1.5707963267948966;
        angle = this.smoothWest(this.getX() - 27.0, angle, oDir);
        angle = this.smoothWest(this.getY() - 27.0, angle + 1.5707963267948966, oDir) - 1.5707963267948966;
        angle = this.smoothWest((double)this.E - this.getX(), angle + Math.PI, oDir) - Math.PI;
        angle = this.smoothWest((double)this.N - this.getY(), angle - 1.5707963267948966, oDir) + 1.5707963267948966;
        return angle;
    }

    private double smoothWest(double dist, double angle, int oDir) {
        if (dist < -160.0 * Math.sin(angle)) {
            return Math.acos((double)oDir * dist / 160.0) - (double)oDir * 1.5707963267948966;
        }
        return angle;
    }

    private class LinearGun
    implements RobotPart {
        private LinearGun() {
        }

        public void init() {
            PartsBot.this.setAdjustGunForRobotTurn(true);
        }

        public void move() {
            if (PartsBot.this.enemy.none()) {
                return;
            }
            double firePower = Math.min(500.0 / PartsBot.this.enemy.getDistance(), 3.0);
            double bulletSpeed = 20.0 - firePower * 3.0;
            long time = (long)(PartsBot.this.enemy.getDistance() / bulletSpeed);
            double futureX = PartsBot.this.enemy.getFutureX(time);
            double futureY = PartsBot.this.enemy.getFutureY(time);
            double absDeg = PartsBot.this.absoluteBearing(PartsBot.this.getX(), PartsBot.this.getY(), futureX, futureY);
            PartsBot.this.setTurnGunRight(PartsBot.this.normalizeBearing(absDeg - PartsBot.this.getGunHeading()));
            if (PartsBot.this.getGunHeat() == 0.0 && Math.abs(PartsBot.this.getGunTurnRemaining()) < 10.0) {
                PartsBot.this.setFire(firePower);
            }
        }
    }

    public static interface RobotPart {
        public void init();

        public void move();
    }

    private class StraffingTank
    implements RobotPart {
        private byte moveDirection;
        private int numTicks = 15;

        private StraffingTank() {
        }

        public void init() {
            this.moveDirection = 1;
            PartsBot.this.N = (int)(PartsBot.this.getBattleFieldHeight() - 27.0);
            PartsBot.this.E = (int)(PartsBot.this.getBattleFieldWidth() - 27.0);
        }

        public void move() {
            if (PartsBot.this.getTime() % (long)this.numTicks == 0L) {
                this.moveDirection = (byte)(this.moveDirection * -1);
                PartsBot.this.setAhead(150 * this.moveDirection);
            }
            double desiredDirection = PartsBot.this.normalizeBearing(PartsBot.this.enemy.getBearing() + 90.0 - (double)(15 * this.moveDirection));
            double wallSmooth = PartsBot.this.smooth(desiredDirection, this.moveDirection);
            PartsBot.this.setTurnRight(wallSmooth);
        }
    }

    private class Walls
    implements RobotPart {
        private static final int TURN_TO_WALL = 1;
        private static final int MOVE_TO_WALL = 2;
        private static final int TURN_RIGHT = 3;
        private static final int FOLLOW_WALL = 4;
        private static final int TURN_CORNER = 5;
        private int state;
        private double moveAmount;

        private Walls() {
        }

        public void init() {
            this.moveAmount = Math.max(PartsBot.this.getBattleFieldWidth(), PartsBot.this.getBattleFieldHeight());
            PartsBot.this.setTurnLeft(PartsBot.this.getHeading() % 90.0);
            this.state = 1;
        }

        public void move() {
            switch (this.state) {
                case 1: {
                    if (PartsBot.this.getTurnRemaining() != 0.0) break;
                    PartsBot.this.setAhead(this.moveAmount);
                    this.state = 2;
                    break;
                }
                case 2: {
                    if (PartsBot.this.getDistanceRemaining() != 0.0) break;
                    PartsBot.this.setTurnRight(90.0);
                    this.state = 3;
                    break;
                }
                case 3: {
                    if (PartsBot.this.getTurnRemaining() != 0.0) break;
                    PartsBot.this.setAhead(this.moveAmount);
                    this.state = 4;
                    break;
                }
                case 4: {
                    if (PartsBot.this.getDistanceRemaining() != 0.0) break;
                    PartsBot.this.setTurnRight(90.0);
                    this.state = 5;
                    break;
                }
                case 5: {
                    if (PartsBot.this.getTurnRemaining() != 0.0) break;
                    PartsBot.this.setAhead(this.moveAmount);
                    this.state = 4;
                    break;
                }
                default: {
                    PartsBot.this.out.println("illegal state");
                }
            }
        }
    }

    private class WobbleRadar
    implements RobotPart {
        private byte radarDirection;

        private WobbleRadar() {
        }

        public void init() {
            this.radarDirection = 1;
            PartsBot.this.setAdjustRadarForGunTurn(true);
            PartsBot.this.setAdjustRadarForRobotTurn(true);
        }

        public void move() {
            if (PartsBot.this.enemy.none()) {
                PartsBot.this.setTurnRadarRight(Double.POSITIVE_INFINITY);
            } else {
                double absoluteBearing = PartsBot.this.getHeadingRadians() + Math.toRadians(PartsBot.this.enemy.getBearing());
                double radarTurn = Utils.normalRelativeAngle((double)(absoluteBearing - PartsBot.this.getRadarHeadingRadians()));
                double arcToScan = Math.min(Math.atan(36.0 / PartsBot.this.enemy.getDistance()), 0.7853981633974483);
                PartsBot.this.setTurnRadarRightRadians(radarTurn += radarTurn < 0.0 ? -arcToScan : arcToScan);
            }
        }

        public boolean shouldTrack(ScannedRobotEvent e) {
            return PartsBot.this.enemy.none() || e.getDistance() < PartsBot.this.enemy.getDistance() - 70.0 || e.getName().equals(PartsBot.this.enemy.getName());
        }

        public boolean wasTracking(RobotDeathEvent e) {
            return e.getName().equals(PartsBot.this.enemy.getName());
        }
    }
}

