/*
 * Decompiled with CFR 0.152.
 */
package pedersen.systems.notifier;

import java.util.ArrayList;
import java.util.List;
import pedersen.divination.CombatWave;
import pedersen.systems.notifier.OnGameOver;
import pedersen.systems.notifier.OnHitByBullet;
import pedersen.systems.notifier.OnPaint;
import pedersen.systems.notifier.OnRound;
import pedersen.systems.notifier.OnTurn;
import pedersen.systems.notifier.OnWaveCountChange;
import pedersen.util.ExceptionHandler;

public class NotificationSubsystem {
    private static NotificationSubsystem singleton = new NotificationSubsystem();
    private final List<OnRound> listenerOnRound = new ArrayList<OnRound>();
    private final List<OnTurn> listenerOnTurn = new ArrayList<OnTurn>();
    private final List<OnHitByBullet> listenerOnHitByBullet = new ArrayList<OnHitByBullet>();
    private final List<OnWaveCountChange> listenerOnWaveCountChange = new ArrayList<OnWaveCountChange>();
    private final List<OnPaint> listenerOnPaint = new ArrayList<OnPaint>();
    private final List<OnGameOver> listenerOnGameOver = new ArrayList<OnGameOver>();

    private NotificationSubsystem() {
    }

    public static NotificationSubsystem getInstance() {
        return singleton;
    }

    public void subscribeOnRound(OnRound listener) {
        this.listenerOnRound.add(listener);
    }

    public void subscribeOnTurn(OnTurn listener) {
        this.listenerOnTurn.add(listener);
    }

    public void subscribeOnHitByBullet(OnHitByBullet listener) {
        this.listenerOnHitByBullet.add(listener);
    }

    public void subscribeOnInboundWaveCountChange(OnWaveCountChange listener) {
        this.listenerOnWaveCountChange.add(listener);
    }

    public void subscribeOnPaint(OnPaint listener) {
        this.listenerOnPaint.add(listener);
    }

    public void subscribeOnGameOver(OnGameOver listener) {
        this.listenerOnGameOver.add(listener);
    }

    public void publishRound(int round) {
        for (OnRound e : this.listenerOnRound) {
            try {
                e.onRound(round);
            }
            catch (Exception ex) {
                ExceptionHandler.handleException(ex);
            }
        }
    }

    public void publishTurn(long time) {
        for (OnTurn e : this.listenerOnTurn) {
            try {
                e.onTurn(time);
            }
            catch (Exception ex) {
                ExceptionHandler.handleException(ex);
            }
        }
    }

    public void publishHitByBullet(CombatWave wave) {
        for (OnHitByBullet e : this.listenerOnHitByBullet) {
            try {
                e.onHitByBullet(wave);
            }
            catch (Exception ex) {
                ExceptionHandler.handleException(ex);
            }
        }
    }

    public void publishWaveCountChange() {
        for (OnWaveCountChange e : this.listenerOnWaveCountChange) {
            try {
                e.onWaveCountChange();
            }
            catch (Exception ex) {
                ExceptionHandler.handleException(ex);
            }
        }
    }

    public void publishOnPaint() {
        for (OnPaint e : this.listenerOnPaint) {
            try {
                e.paint();
            }
            catch (Exception ex) {
                ExceptionHandler.handleException(ex);
            }
        }
    }

    public void publishOnGameOver() {
        for (OnGameOver e : this.listenerOnGameOver) {
            try {
                e.teardown();
            }
            catch (Exception ex) {
                ExceptionHandler.handleException(ex);
            }
        }
    }

    public void unsubscribeOnPaint(OnPaint listener) {
        this.listenerOnPaint.remove(listener);
    }

    public void unsubscribeOnGameOver(OnGameOver listener) {
        this.listenerOnGameOver.remove(listener);
    }
}

