/*
 * Decompiled with CFR 0.152.
 */
package florent;

import florent.Context;
import florent.DynamicDistancing;
import florent.FloatingTadpole;
import florent.GunManager;
import florent.SymbolicPatternMatcher;
import florent.Wave;
import florent.WaveCommandGunManager;
import florent.WaveManagerGun;
import florent.gun.MultiChoice;
import florent.jUtil;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Gun {
    protected static boolean[] activeGun = new boolean[7];
    protected static GunManager[] virtualGuns = new GunManager[7];
    protected static final double MAX_BULLET_POWER = 3.0;
    protected static final double BULLET_POWER = 1.91;
    protected static final boolean DEBUG = false;
    protected static final boolean FORCED_SELECTION = false;
    protected static final int FORCED_GUN = 3;
    protected static int shots;
    protected static int hits;
    protected static int multiShots;
    protected static int[] shotsPerGun;
    protected boolean ram = true;
    protected WaveManagerGun manager;
    protected Context target;
    protected AdvancedRobot me;
    protected boolean active = true;
    protected int defaultGun = 2;
    protected double absoluteBearing;
    protected double time;
    protected double distance;
    protected double energy;
    protected double myEnergy;
    protected double bearingDirection;
    protected static int GF0;
    protected SymbolicPatternMatcher matcher;
    protected static DynamicDistancing distancing;
    protected MultiChoice multi;

    static {
        shotsPerGun = new int[7];
        distancing = DynamicDistancing.getInstance();
    }

    public Gun(AdvancedRobot me, Context target) {
        this.target = target;
        this.me = me;
        this.manager = new WaveManagerGun(target, me);
        GF0 = WaveManagerGun.getGF0();
        this.matcher = new SymbolicPatternMatcher(target);
        this.multi = new MultiChoice();
    }

    public void init() {
        this.manager.init();
        this.multi.init(this.me, this.target);
        Gun.virtualGuns[0] = virtualGuns[0] == null ? new GunManager(this.manager, "fast adaptative") : virtualGuns[0];
        Gun.virtualGuns[1] = virtualGuns[1] == null ? new GunManager(this.manager, "normal adaptative") : virtualGuns[1];
        Gun.virtualGuns[2] = virtualGuns[2] == null ? new GunManager(this.manager, "fast") : virtualGuns[2];
        Gun.virtualGuns[3] = virtualGuns[3] == null ? new GunManager(this.manager, "normal") : virtualGuns[3];
        Gun.virtualGuns[4] = virtualGuns[4] == null ? new GunManager(this.manager, "multi gf") : virtualGuns[4];
        Gun.virtualGuns[5] = virtualGuns[5] == null ? new GunManager(this.matcher, "pm") : virtualGuns[5];
        Gun.virtualGuns[6] = virtualGuns[6] == null ? new GunManager(this.multi, "multi choice") : virtualGuns[6];
        Gun.activeGun[0] = true;
        Gun.activeGun[1] = true;
        Gun.activeGun[2] = true;
        Gun.activeGun[3] = true;
        Gun.activeGun[4] = true;
        Gun.activeGun[5] = true;
        Gun.activeGun[6] = false;
    }

    protected void synch() {
        if (this.time == this.target.getTime()) {
            return;
        }
        this.time = this.target.getTime();
        this.absoluteBearing = this.target.getAbsoluteBearing();
        this.distance = this.target.getDistance();
        this.bearingDirection = this.target.getBearingDirection();
        this.energy = this.target.getEnergy();
        this.myEnergy = this.target.getMyEnergy();
    }

    public void endRound() {
    }

    public void dump() {
        System.out.println("Hit rate " + this.gethitRate());
        int i = 0;
        while (i < virtualGuns.length) {
            System.out.println(String.valueOf(virtualGuns[i].getName()) + " shots:" + shotsPerGun[i] + " overall hit rate:" + virtualGuns[i].overallHitRate() + " hit rate:" + virtualGuns[i].getHitRate() + " error:" + virtualGuns[i].getError() + " bias:" + virtualGuns[i].getBias());
            ++i;
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.synch();
        if (activeGun[5]) {
            this.matcher.onScannedRobot(e);
        }
        if (activeGun[6]) {
            this.multi.onScannedRobot(e);
        }
    }

    public void aim() {
        if (this.energy == 0.0 && this.ram) {
            return;
        }
        this.synch();
        double power = this.getPower();
        int gunId = this.defaultGun;
        Wave wave = this.manager.giveWave(power);
        int index = wave.getGfs()[this.getBestGfGun()];
        double angle = (1.0 * (double)index - 1.0 * (double)GF0) / (1.0 * (double)GF0) * Wave.maxEscapeAngle(FloatingTadpole.bulletVelocity(power)) * this.bearingDirection;
        double matcherAngle = SymbolicPatternMatcher.NO_MACH_ANGLE;
        double multiAngle = -100000.0;
        if (this.me.getGunHeat() / this.me.getGunCoolingRate() < 3.0 && this.active && this.me.getOthers() > 0) {
            if (this.myEnergy - power < 0.5) {
                return;
            }
            if (activeGun[5]) {
                matcherAngle = this.matcher.getAngle(power);
            }
            if (activeGun[6]) {
                multiAngle = this.multi.getAngle(power);
            }
            if (this.getBestGun() == 6 && multiAngle != -100000.0) {
                angle = multiAngle;
                gunId = 6;
            } else if (this.getBestGun() == 5 && matcherAngle != SymbolicPatternMatcher.NO_MACH_ANGLE && Math.abs(matcherAngle) <= Wave.maxEscapeAngle(jUtil.bulletVelocity(power))) {
                angle = matcherAngle;
                gunId = 5;
            } else {
                gunId = this.getBestGfGun();
                index = wave.getGfs()[gunId];
                angle = (1.0 * (double)index - 1.0 * (double)GF0) / (1.0 * (double)GF0) * Wave.maxEscapeAngle(FloatingTadpole.bulletVelocity(power)) * this.bearingDirection;
            }
            if (Math.abs(angle) > Wave.maxEscapeAngle(jUtil.bulletVelocity(power))) {
                return;
            }
            angle = this.target.isRammer() && this.distance < 75.0 ? 0.0 : angle;
            this.me.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this.absoluteBearing + angle - this.me.getGunHeadingRadians())));
            this.fire(wave, power, angle, matcherAngle, multiAngle, gunId);
        } else {
            angle = this.target.isRammer() && this.distance < 75.0 ? 0.0 : angle;
            this.me.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this.absoluteBearing + angle - this.me.getGunHeadingRadians())));
        }
    }

    protected void fire(Wave wave, double power, double angle, double matcherAngle, double multiAngle, int gunId) {
        int round = this.me.getRoundNum();
        Bullet b = null;
        double gunAlignmentDelta = Utils.normalRelativeAngle((double)(this.me.getGunHeadingRadians() - angle - this.absoluteBearing));
        if (this.active && this.me.getOthers() > 0 && Math.abs(gunAlignmentDelta) < Math.atan2(45.0, this.distance)) {
            b = this.me.setFireBullet(power);
            if (wave == null) {
                System.out.println("Gun:fire:wave == null");
            }
            if (b != null && wave != null) {
                distancing.onGunFire(b.getPower());
                this.manager.addWave(wave, true);
                ++shots;
                int n = gunId;
                shotsPerGun[n] = shotsPerGun[n] + 1;
                int i = 0;
                while (i < 5) {
                    int index = wave.getGfs()[i];
                    double anglePerGun = (1.0 * (double)index - 1.0 * (double)GF0) / (1.0 * (double)GF0) * Wave.maxEscapeAngle(FloatingTadpole.bulletVelocity(power)) * this.bearingDirection;
                    virtualGuns[i].fire(anglePerGun, this.time, round, this.distance);
                    ++i;
                }
                if (matcherAngle != SymbolicPatternMatcher.NO_MACH_ANGLE) {
                    virtualGuns[5].fire(matcherAngle, this.time, round, this.distance);
                }
                if (multiAngle != -100000.0) {
                    virtualGuns[6].fire(multiAngle, this.time, round, this.distance);
                }
                int j = 0;
                while (j < 5) {
                    wave.addCommand(new WaveCommandGunManager(virtualGuns[j], round));
                    ++j;
                }
                if (matcherAngle != SymbolicPatternMatcher.NO_MACH_ANGLE) {
                    wave.addCommand(new WaveCommandGunManager(virtualGuns[5], round));
                }
                if (multiAngle != -100000.0) {
                    wave.addCommand(new WaveCommandGunManager(virtualGuns[6], round));
                }
            }
            if (b == null) {
                this.manager.addWave(wave, false);
            }
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        ++hits;
    }

    protected double gethitRate() {
        return 1.0 * (double)hits / (1.0 * (double)shots);
    }

    protected int getBestGfGun() {
        int best = this.defaultGun;
        double bestVal = 1.0;
        int i = 0;
        while (i < 5) {
            bestVal *= virtualGuns[i].getHitRate();
            ++i;
        }
        if (bestVal != 0.0) {
            bestVal = virtualGuns[best].getHitRate();
            i = 0;
            while (i < 5) {
                if (virtualGuns[i].getHitRate() > virtualGuns[best].getHitRate()) {
                    best = i;
                }
                ++i;
            }
        }
        return best;
    }

    protected int getBestGun() {
        int best = this.defaultGun;
        double bestVal = 1.0;
        int i = 0;
        while (i < virtualGuns.length) {
            bestVal *= activeGun[i] ? virtualGuns[i].getHitRate() : 1.0;
            ++i;
        }
        if (bestVal != 0.0) {
            bestVal = virtualGuns[best].getHitRate();
            i = 0;
            while (i < virtualGuns.length) {
                if (virtualGuns[i].getHitRate() > virtualGuns[best].getHitRate() && activeGun[i]) {
                    best = i;
                }
                ++i;
            }
        }
        return best;
    }

    protected double getPower() {
        double wantedBulletPower;
        double bulletPower = wantedBulletPower = Math.min(5, (int)this.distance / 140) > 0 && !this.target.isRammer() && this.gethitRate() < 0.35 ? 1.91 : 3.0;
        if (this.energy < 15.0) {
            bulletPower = Math.min(Math.min(this.energy / 4.0, this.me.getEnergy() / 7.0), wantedBulletPower);
        }
        if (this.me.getEnergy() < bulletPower) {
            bulletPower = 0.0;
        }
        return Math.max(bulletPower, 0.0);
    }
}

