/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.Movement.DangerPrediction;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import rdt.AgentSmith.AgentSmith;
import rdt.AgentSmith.Movement.DangerPrediction.CommandListGenerator;
import rdt.AgentSmith.Movement.DangerPrediction.DangerAccumulationBase;
import rdt.AgentSmith.Movement.DangerPrediction.DangerAccumulationMaxVal;
import rdt.AgentSmith.Movement.DangerPrediction.DangerCalculationBase;
import rdt.AgentSmith.Movement.DangerPrediction.DangerPredictionState;
import rdt.AgentSmith.Movement.DangerPrediction.DangerPredictionTree;
import rdt.AgentSmith.Movement.DangerPrediction.DangerPredictionTreeNode;
import rdt.AgentSmith.Movement.DangerPrediction.DangerPredictionVirtualGunTargetInterface;
import rdt.AgentSmith.Movement.DangerPrediction.MinDistanceDangerCalculation;
import rdt.AgentSmith.Movement.DangerPrediction.MovementCommand;
import rdt.AgentSmith.Movement.EnemyWaveManager;
import rdt.RobotData.RobotData;
import rdt.RobotData.RobotDataSnapshot;
import rdt.Targeting.Targeting;
import rdt.VirtualGuns.Guns.DC.Segmentation;
import rdt.VirtualGuns.Guns.DC.VirtualGunDC;
import rdt.VirtualGuns.Guns.VirtualGunCircularWithWallAvoidance;
import rdt.VirtualGuns.VirtualGuns;
import rdt.Waves.WaveData;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;
import robocode.Rules;

public class DangerPredictionMovement {
    private static float ConsiderRammingDistance = 400.0f;
    private static float IsRammerDistance = 100.0f;
    private static float IsRammerDistanceSq = IsRammerDistance * IsRammerDistance;
    private DangerPredictionState _currentBotPosition = new DangerPredictionState();
    private DangerPredictionTree _tree = null;
    private int _commandIndex;
    private DangerCalculationBase _dangerCalc;
    private DangerAccumulationBase _accumulation;
    private VirtualGuns _virtualGuns = null;
    private long _lastRecalcTick = 0L;
    private long _forceRecalcEveryXTicks = 0L;
    private MovementCommand _ourPredictor = new MovementCommand();
    private EnemyWaveManager _enemyWaveManager = null;

    public DangerPredictionMovement(EnemyWaveManager enemyWaveManager) {
        this._tree = new DangerPredictionTree(enemyWaveManager);
        this._enemyWaveManager = enemyWaveManager;
        this._dangerCalc = new MinDistanceDangerCalculation(enemyWaveManager);
        this._accumulation = new DangerAccumulationMaxVal();
        ArrayList<Segmentation.eSegmentation> segmentationList = new ArrayList<Segmentation.eSegmentation>();
        segmentationList.add(Segmentation.eSegmentation.Distance);
        segmentationList.add(Segmentation.eSegmentation.LateralVelocity);
        segmentationList.add(Segmentation.eSegmentation.AdvancingVelocity);
        segmentationList.add(Segmentation.eSegmentation.Acceleration);
        segmentationList.add(Segmentation.eSegmentation.TimeSinceDirectionChange);
        segmentationList.add(Segmentation.eSegmentation.TimeSinceDeceleration);
        segmentationList.add(Segmentation.eSegmentation.TotalTicks);
        segmentationList.add(Segmentation.eSegmentation.DistanceLast10);
        segmentationList.add(Segmentation.eSegmentation.DistanceToWallAhead);
        segmentationList.add(Segmentation.eSegmentation.DistanceToWallBehind);
        this._virtualGuns = new VirtualGuns("Enemy", 10, 15, enemyWaveManager, new DangerPredictionVirtualGunTargetInterface(), 1.0, 0.05, false);
        this._virtualGuns.AddVirtualGun(new VirtualGunCircularWithWallAvoidance());
        this._virtualGuns.AddVirtualGun(new VirtualGunDC(100, segmentationList, 1.0, 0.01, false, true));
        this._virtualGuns.AddVirtualGun(new VirtualGunDC(50, segmentationList, 0.01, 0.01, true, true));
        enemyWaveManager.SetVirtualGuns(this._virtualGuns);
        double maxGunHeat = Rules.getGunHeat((double)3.0);
        double turns = maxGunHeat / AgentSmith.Instance().getGunCoolingRate();
        this._forceRecalcEveryXTicks = (long)Math.ceil(turns);
        this._forceRecalcEveryXTicks *= 2L;
        this._lastRecalcTick = -this._forceRecalcEveryXTicks;
    }

    public void Update() {
        ArrayList<DangerPredictionTreeNode> movement;
        this.UpdateCurrentBotPosition();
        this._virtualGuns.Update();
        RobotData enemyData = Targeting.GetCurrentTarget();
        RobotDataSnapshot enemySnapshot = null;
        if (enemyData != null && enemyData.Valid) {
            enemySnapshot = enemyData.Snapshots.get(0);
        }
        if (this.ShouldRecalcPrediction(enemySnapshot)) {
            this._commandIndex = 0;
            int maxPredictionDepthRequired = this.GetMaxPredictionDepthRequired();
            this._tree.UpdatePrediction(this._currentBotPosition, enemySnapshot, maxPredictionDepthRequired);
            this._lastRecalcTick = AgentSmith.Instance().getTime();
        }
        if ((movement = this._tree.GetChosenPrediction()).size() <= 0) {
            AgentSmith.Instance().setAhead(0.0);
            return;
        }
        DangerPredictionTreeNode nextNode = movement.get(this._commandIndex);
        this.ExecuteCommand(nextNode.Command);
        ++this._commandIndex;
        if (this._commandIndex >= movement.size()) {
            this._commandIndex = 0;
        }
    }

    private boolean ShouldRecalcPrediction(RobotDataSnapshot enemySnapshot) {
        if (enemySnapshot != null && enemySnapshot.BulletFirepower > 0.0) {
            return true;
        }
        if (this._commandIndex == 0) {
            return true;
        }
        if (this._lastRecalcTick + this._forceRecalcEveryXTicks < AgentSmith.Instance().getTime()) {
            return true;
        }
        return this.IsLikelyToBeRammed();
    }

    private boolean IsLikelyToBeRammed() {
        if (Targeting.GetCurrentTarget() == null) {
            return false;
        }
        if (!Targeting.GetCurrentTarget().Valid) {
            return false;
        }
        if (Targeting.GetCurrentTarget().NumSnapshots < 2) {
            return false;
        }
        RobotDataSnapshot targetData = Targeting.GetCurrentTarget().Snapshots.get(0);
        if (targetData.DistanceToTarget > (double)ConsiderRammingDistance) {
            return false;
        }
        double closestPredictedDistanceSq = Double.MAX_VALUE;
        double ourX = AgentSmith.Instance().GetLatestSnapshot().LocationX;
        double ourY = AgentSmith.Instance().GetLatestSnapshot().LocationY;
        int index = 0;
        while (index < RobotDataSnapshot.MAX_PREDICTED_POSITIONS) {
            double x = targetData.PredictedPositionsX[index];
            double diffX = x - ourX;
            double y = targetData.PredictedPositionsY[index];
            double diffY = y - ourY;
            double distanceSq = diffX * diffX + diffY * diffY;
            if (distanceSq < closestPredictedDistanceSq) {
                closestPredictedDistanceSq = distanceSq;
            }
            ++index;
        }
        if (closestPredictedDistanceSq > (double)IsRammerDistanceSq) {
            return false;
        }
        return !(closestPredictedDistanceSq >= targetData.DistanceToTarget * targetData.DistanceToTarget);
    }

    public void OnRoundStart() {
        this._commandIndex = 0;
        this._lastRecalcTick = 0L;
        CommandListGenerator.GenerateAndAddToTree(this._tree);
    }

    public void OnBulletHitBulletEvent(BulletHitBulletEvent event) {
        this._virtualGuns.OnHitByBullet(event.getHitBullet().getX(), event.getHitBullet().getY());
    }

    public void OnHitByBulletEvent(HitByBulletEvent event) {
        this._virtualGuns.OnHitByBullet(event.getBullet().getX(), event.getBullet().getY());
    }

    private void UpdateCurrentBotPosition() {
        RobotDataSnapshot snapshot = AgentSmith.Instance().GetLatestSnapshot();
        this._currentBotPosition.X = snapshot.LocationX;
        this._currentBotPosition.Y = snapshot.LocationY;
        this._currentBotPosition.Heading = snapshot.AbsoluteHeading;
        this._currentBotPosition.Velocity = snapshot.VelocityAlongHeading;
    }

    private void ExecuteCommand(MovementCommand.eCommand command) {
        AgentSmith.Instance().SetPredictedPositionNextTick(this._ourPredictor.PredictCommand(command, this._currentBotPosition));
        switch (command) {
            case Forward: {
                AgentSmith.Instance().setAhead(1000.0);
                AgentSmith.Instance().setTurnLeft(0.0);
                break;
            }
            case Back: {
                AgentSmith.Instance().setBack(1000.0);
                AgentSmith.Instance().setTurnLeft(0.0);
                break;
            }
            case ForwardLeft: {
                AgentSmith.Instance().setAhead(1000.0);
                AgentSmith.Instance().setTurnLeft(180.0);
                break;
            }
            case BackRight: {
                AgentSmith.Instance().setBack(1000.0);
                AgentSmith.Instance().setTurnLeft(180.0);
                break;
            }
            case ForwardRight: {
                AgentSmith.Instance().setAhead(1000.0);
                AgentSmith.Instance().setTurnRight(180.0);
                break;
            }
            case BackLeft: {
                AgentSmith.Instance().setBack(1000.0);
                AgentSmith.Instance().setTurnRight(180.0);
            }
        }
    }

    private int GetMaxPredictionDepthRequired() {
        int maxDepthRequired = 40;
        long currentTick = AgentSmith.Instance().getTime();
        int waveIndex = 0;
        while (waveIndex < this._enemyWaveManager.GetNumActiveWaves()) {
            WaveData waveData = this._enemyWaveManager.GetActiveWave(waveIndex);
            long ticksLeft = waveData.AbsTickAngleSnapshotsOutsideBattlefield - currentTick;
            maxDepthRequired = (int)Math.max((long)maxDepthRequired, ticksLeft);
            ++waveIndex;
        }
        return maxDepthRequired;
    }

    public void DebugDraw(Graphics2D gfx) {
        if (Targeting.GetCurrentTarget() == null) {
            return;
        }
        if (!Targeting.GetCurrentTarget().Valid) {
            return;
        }
        if (Targeting.GetCurrentTarget().NumSnapshots <= 1) {
            return;
        }
        gfx.setColor(Color.blue);
        ArrayList<DangerPredictionTreeNode> movement = this._tree.GetChosenPrediction();
        int index = 0;
        while (index < movement.size() - 1) {
            DangerPredictionState state1 = movement.get((int)index).State;
            DangerPredictionState state2 = movement.get((int)(index + 1)).State;
            gfx.drawLine((int)state1.X, (int)state1.Y, (int)state2.X, (int)state2.Y);
            ++index;
        }
    }
}

