/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import rdt.AgentSmith.AgentSmith;
import rdt.AgentSmith.Setup;
import rdt.AgentSmith.SetupEntry;

public class SetupIO {
    public static void ReadSetup() {
        Setup.Instance = new Setup();
        File file = AgentSmith.Instance().getDataFile("SetupData.txt");
        ArrayList<SetupEntry> setupEntries = new ArrayList<SetupEntry>();
        if (!file.exists()) {
            return;
        }
        try {
            Scanner scanner = new Scanner(file);
            while (scanner.hasNextLine()) {
                SetupEntry setupEntry = SetupIO.ParseSetupLine(scanner.nextLine());
                if (setupEntry == null) continue;
                setupEntries.add(setupEntry);
            }
            scanner.close();
        }
        catch (Exception e) {
            System.out.println("Failed to open setup");
            return;
        }
        SetupIO.FillSetup(Setup.Instance, setupEntries);
    }

    private static SetupEntry ParseSetupLine(String line) {
        String lineNoWhitespace = line.replaceAll("\\s+", "");
        String[] splitStrings = lineNoWhitespace.split(":");
        if (splitStrings.length != 2) {
            System.out.println("Error in your setup file line: " + line);
            return null;
        }
        return new SetupEntry(splitStrings[0], splitStrings[1]);
    }

    private static void FillSetup(Setup instanceToFill, List<SetupEntry> entries) {
        instanceToFill.EnableGun = SetupIO.GetBooleanValue("EnableGun", entries, true);
        instanceToFill.EnableMovement = SetupIO.GetBooleanValue("EnableMovement", entries, true);
        instanceToFill.EnableGunChallengeMode = SetupIO.GetBooleanValue("EnableGunChallengeMode", entries, false);
        instanceToFill.EnableBulletShadow = SetupIO.GetBooleanValue("EnableBulletShadow", entries, false);
        instanceToFill.EnableGunDebug = SetupIO.GetBooleanValue("EnableGunDebug", entries, false);
        instanceToFill.EnableMovementDebug = SetupIO.GetBooleanValue("EnableMovementDebug", entries, false);
        instanceToFill.EnableTargetDebug = SetupIO.GetBooleanValue("EnableTargetDebug", entries, false);
        instanceToFill.EnableEnergyDebug = SetupIO.GetBooleanValue("EnableEnergyDebug", entries, false);
        instanceToFill.EnableBulletShadowDebug = SetupIO.GetBooleanValue("EnableBulletShadowDebug", entries, false);
        instanceToFill.StandardFirepower = SetupIO.GetDoubleValue("StandardFirepower", entries, 1.9);
    }

    private static boolean GetBooleanValue(String entryName, List<SetupEntry> entries, boolean defaultValue) {
        SetupEntry entry = SetupIO.GetSetupEntry(entryName, entries);
        if (entry == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(entry.Data);
    }

    private static double GetDoubleValue(String entryName, List<SetupEntry> entries, double defaultValue) {
        SetupEntry entry = SetupIO.GetSetupEntry(entryName, entries);
        if (entry == null) {
            return defaultValue;
        }
        return Double.parseDouble(entry.Data);
    }

    private static SetupEntry GetSetupEntry(String entryName, List<SetupEntry> entries) {
        int index = 0;
        while (index < entries.size()) {
            SetupEntry entry = entries.get(index);
            if (entry.Name.compareTo(entryName) == 0) {
                return entry;
            }
            ++index;
        }
        return null;
    }
}

