/*
 * Decompiled with CFR 0.152.
 */
package rdt.KDTree;

import java.util.ArrayList;
import java.util.Arrays;

public abstract class KDTree<T> {
    private static final int _bucketSize = 50;
    private final int _dimensions;
    private int _nodes;
    private final Node root;
    private final ArrayList<Node> nodeList = new ArrayList();
    private double[] mem_recycle;
    private final double[] bounds_template;
    private final ContiguousDoubleArrayList nodeMinMaxBounds;

    private KDTree(int dimensions) {
        this._dimensions = dimensions;
        this.nodeMinMaxBounds = new ContiguousDoubleArrayList(65536 + 2 * this._dimensions);
        this.mem_recycle = new double[50 * dimensions];
        this.bounds_template = new double[2 * this._dimensions];
        Arrays.fill(this.bounds_template, Double.NEGATIVE_INFINITY);
        int i = 0;
        int max = 2 * this._dimensions;
        while (i < max) {
            this.bounds_template[i] = Double.POSITIVE_INFINITY;
            i += 2;
        }
        this.root = new Node();
    }

    public int nodes() {
        return this._nodes;
    }

    public int size() {
        return this.root.entries;
    }

    public int addPoint(double[] location, T payload) {
        Node addNode = this.root;
        while (addNode.pointLocations == null) {
            addNode.expandBounds(location);
            addNode = location[addNode.splitDim] < addNode.splitVal ? this.nodeList.get(addNode.lessIndex) : this.nodeList.get(addNode.moreIndex);
        }
        addNode.expandBounds(location);
        int nodeSize = addNode.add(location, payload);
        if (nodeSize % 50 == 0) {
            addNode.split();
        }
        return this.root.entries;
    }

    public ArrayList<SearchResult<T>> nearestNeighbours(double[] searchLocation, int K) {
        IntStack stack = new IntStack();
        PrioQueue results = new PrioQueue(K, true);
        stack.push(this.root.index);
        int added = 0;
        while (stack.size() > 0) {
            int nodeIndex = stack.pop();
            if (added >= K && !(results.peekPrio() > this.pointRectDist(nodeIndex, searchLocation))) continue;
            Node node = this.nodeList.get(nodeIndex);
            if (node.pointLocations == null) {
                node.search(searchLocation, stack);
                continue;
            }
            added += node.search(searchLocation, results);
        }
        ArrayList<SearchResult<T>> returnResults = new ArrayList<SearchResult<T>>(K);
        double[] priorities = results.priorities;
        Object[] elements = results.elements;
        int i = 0;
        while (i < K) {
            SearchResult<Object> s = new SearchResult<Object>(priorities[i], elements[i]);
            returnResults.add(s);
            ++i;
        }
        return returnResults;
    }

    public ArrayList<T> ballSearch(double[] searchLocation, double radius) {
        IntStack stack = new IntStack();
        ArrayList results = new ArrayList();
        stack.push(this.root.index);
        while (stack.size() > 0) {
            int nodeIndex = stack.pop();
            if (!(radius > this.pointRectDist(nodeIndex, searchLocation))) continue;
            Node node = this.nodeList.get(nodeIndex);
            if (node.pointLocations == null) {
                stack.push(node.moreIndex).push(node.lessIndex);
                continue;
            }
            node.searchBall(searchLocation, radius, results);
        }
        return results;
    }

    public ArrayList<T> rectSearch(double[] mins, double[] maxs) {
        IntStack stack = new IntStack();
        ArrayList results = new ArrayList();
        stack.push(this.root.index);
        while (stack.size() > 0) {
            int nodeIndex = stack.pop();
            if (!this.overlaps(mins, maxs, nodeIndex)) continue;
            Node node = this.nodeList.get(nodeIndex);
            if (node.pointLocations == null) {
                stack.push(node.moreIndex).push(node.lessIndex);
                continue;
            }
            node.searchRect(mins, maxs, results);
        }
        return results;
    }

    abstract double pointRectDist(int var1, double[] var2);

    abstract double pointDist(double[] var1, double[] var2, int var3);

    boolean contains(double[] arr, double[] mins, double[] maxs, int index) {
        int offset = (index + 1) * mins.length;
        int i = mins.length;
        while (i-- > 0) {
            double d;
            if (!(mins[i] > (d = arr[--offset]) | d > maxs[i])) continue;
            return false;
        }
        return true;
    }

    boolean overlaps(double[] mins, double[] maxs, int offset) {
        offset *= 2 * maxs.length;
        double[] array = this.nodeMinMaxBounds.array;
        int i = 0;
        while (i < maxs.length) {
            double bmin;
            double bmax = array[offset + 1];
            if (mins[i] > bmax | maxs[i] < (bmin = array[offset])) {
                return false;
            }
            ++i;
            offset += 2;
        }
        return true;
    }

    static final double sqr(double d) {
        return d * d;
    }

    /* synthetic */ KDTree(int n, KDTree kDTree) {
        this(n);
    }

    private static class ContiguousDoubleArrayList {
        double[] array;
        int size;

        ContiguousDoubleArrayList() {
            this(300);
        }

        ContiguousDoubleArrayList(int size) {
            this(new double[size]);
        }

        ContiguousDoubleArrayList(double[] data) {
            this.array = data;
        }

        ContiguousDoubleArrayList add(double[] da) {
            if (this.size + da.length > this.array.length) {
                this.array = Arrays.copyOf(this.array, (this.array.length + da.length) * 2);
            }
            System.arraycopy(da, 0, this.array, this.size, da.length);
            this.size += da.length;
            return this;
        }
    }

    public static class Euclidean<T>
    extends KDTree<T> {
        public Euclidean(int dims) {
            super(dims, null);
        }

        @Override
        double pointRectDist(int offset, double[] location) {
            offset *= 2 * ((KDTree)this)._dimensions;
            double distance = 0.0;
            double[] array = ((KDTree)this).nodeMinMaxBounds.array;
            int i = 0;
            while (i < location.length) {
                double diff = 0.0;
                double bv = array[offset];
                double lv = location[i];
                if (bv > lv) {
                    diff = bv - lv;
                } else {
                    bv = array[offset + 1];
                    if (lv > bv) {
                        diff = lv - bv;
                    }
                }
                distance += Euclidean.sqr(diff);
                ++i;
                offset += 2;
            }
            return distance;
        }

        @Override
        double pointDist(double[] arr, double[] location, int index) {
            double distance = 0.0;
            int offset = (index + 1) * ((KDTree)this)._dimensions;
            int i = ((KDTree)this)._dimensions;
            while (i-- > 0) {
                distance += Euclidean.sqr(arr[--offset] - location[i]);
            }
            return distance;
        }
    }

    private static class IntStack {
        int[] array;
        int size;

        IntStack() {
            this(64);
        }

        IntStack(int size) {
            this(new int[size]);
        }

        IntStack(int[] data) {
            this.array = data;
        }

        IntStack push(int i) {
            if (this.size >= this.array.length) {
                this.array = Arrays.copyOf(this.array, (this.array.length + 1) * 2);
            }
            this.array[this.size++] = i;
            return this;
        }

        int pop() {
            return this.array[--this.size];
        }

        int size() {
            return this.size;
        }
    }

    public static class Manhattan<T>
    extends KDTree<T> {
        public Manhattan(int dims) {
            super(dims, null);
        }

        @Override
        double pointRectDist(int offset, double[] location) {
            offset *= 2 * ((KDTree)this)._dimensions;
            double distance = 0.0;
            double[] array = ((KDTree)this).nodeMinMaxBounds.array;
            int i = 0;
            while (i < location.length) {
                double diff = 0.0;
                double bv = array[offset];
                double lv = location[i];
                if (bv > lv) {
                    diff = bv - lv;
                } else {
                    bv = array[offset + 1];
                    if (lv > bv) {
                        diff = lv - bv;
                    }
                }
                distance += diff;
                ++i;
                offset += 2;
            }
            return distance;
        }

        @Override
        double pointDist(double[] arr, double[] location, int index) {
            double distance = 0.0;
            int offset = (index + 1) * ((KDTree)this)._dimensions;
            int i = ((KDTree)this)._dimensions;
            while (i-- > 0) {
                distance += Math.abs(arr[--offset] - location[i]);
            }
            return distance;
        }
    }

    private class Node {
        int index;
        int entries;
        ContiguousDoubleArrayList pointLocations;
        ArrayList<T> pointPayloads = new ArrayList(50);
        int lessIndex;
        int moreIndex;
        int splitDim;
        double splitVal;

        Node() {
            this(new double[50 * kDTree._dimensions]);
        }

        Node(double[] pointMemory) {
            this.pointLocations = new ContiguousDoubleArrayList(pointMemory);
            KDTree kDTree2 = KDTree.this;
            int n = kDTree2._nodes;
            kDTree2._nodes = n + 1;
            this.index = n;
            KDTree.this.nodeList.add(this);
            KDTree.this.nodeMinMaxBounds.add(KDTree.this.bounds_template);
        }

        void search(double[] searchLocation, IntStack stack) {
            if (searchLocation[this.splitDim] < this.splitVal) {
                stack.push(this.moreIndex).push(this.lessIndex);
            } else {
                stack.push(this.lessIndex).push(this.moreIndex);
            }
        }

        int search(double[] searchLocation, PrioQueue<T> results) {
            int updated = 0;
            int j = this.entries;
            while (j-- > 0) {
                double distance = KDTree.this.pointDist(this.pointLocations.array, searchLocation, j);
                if (!(results.peekPrio() > distance)) continue;
                ++updated;
                results.addNoGrow(this.pointPayloads.get(j), distance);
            }
            return updated;
        }

        void searchBall(double[] searchLocation, double radius, ArrayList<T> results) {
            int j = this.entries;
            while (j-- > 0) {
                double distance = KDTree.this.pointDist(this.pointLocations.array, searchLocation, j);
                if (!(radius >= distance)) continue;
                results.add(this.pointPayloads.get(j));
            }
        }

        void searchRect(double[] mins, double[] maxs, ArrayList<T> results) {
            int j = this.entries;
            while (j-- > 0) {
                if (!KDTree.this.contains(this.pointLocations.array, mins, maxs, j)) continue;
                results.add(this.pointPayloads.get(j));
            }
        }

        void expandBounds(double[] location) {
            ++this.entries;
            int mio = this.index * 2 * KDTree.this._dimensions;
            int i = 0;
            while (i < KDTree.this._dimensions) {
                ((KDTree)KDTree.this).nodeMinMaxBounds.array[mio] = Math.min(((KDTree)KDTree.this).nodeMinMaxBounds.array[mio++], location[i]);
                ((KDTree)KDTree.this).nodeMinMaxBounds.array[mio] = Math.max(((KDTree)KDTree.this).nodeMinMaxBounds.array[mio++], location[i]);
                ++i;
            }
        }

        int add(double[] location, T load) {
            this.pointLocations.add(location);
            this.pointPayloads.add(load);
            return this.entries;
        }

        void split() {
            int offset = this.index * 2 * KDTree.this._dimensions;
            double diff = 0.0;
            int i = 0;
            while (i < KDTree.this._dimensions) {
                double max = ((KDTree)KDTree.this).nodeMinMaxBounds.array[offset + 1];
                double min = ((KDTree)KDTree.this).nodeMinMaxBounds.array[offset];
                if (max - min > diff) {
                    double mean = 0.0;
                    int j = 0;
                    while (j < this.entries) {
                        mean += this.pointLocations.array[i + KDTree.this._dimensions * j];
                        ++j;
                    }
                    mean /= (double)this.entries;
                    double varianceSum = 0.0;
                    int j2 = 0;
                    while (j2 < this.entries) {
                        varianceSum += KDTree.sqr(mean - this.pointLocations.array[i + KDTree.this._dimensions * j2]);
                        ++j2;
                    }
                    if (varianceSum > diff * (double)this.entries) {
                        diff = varianceSum / (double)this.entries;
                        this.splitVal = mean;
                        this.splitDim = i;
                    }
                }
                offset += 2;
                ++i;
            }
            if (this.splitVal == Double.POSITIVE_INFINITY) {
                this.splitVal = Double.MAX_VALUE;
            } else if (this.splitVal == Double.NEGATIVE_INFINITY) {
                this.splitVal = Double.MIN_VALUE;
            } else if (this.splitVal == ((KDTree)KDTree.this).nodeMinMaxBounds.array[this.index * 2 * KDTree.this._dimensions + 2 * this.splitDim + 1]) {
                this.splitVal = ((KDTree)KDTree.this).nodeMinMaxBounds.array[this.index * 2 * KDTree.this._dimensions + 2 * this.splitDim];
            }
            Node less = new Node(KDTree.this.mem_recycle);
            Node more = new Node();
            this.lessIndex = less.index;
            this.moreIndex = more.index;
            double[] pointLocation = new double[KDTree.this._dimensions];
            int i2 = 0;
            while (i2 < this.entries) {
                System.arraycopy(this.pointLocations.array, i2 * KDTree.this._dimensions, pointLocation, 0, KDTree.this._dimensions);
                Object load = this.pointPayloads.get(i2);
                if (pointLocation[this.splitDim] < this.splitVal) {
                    less.expandBounds(pointLocation);
                    less.add(pointLocation, load);
                } else {
                    more.expandBounds(pointLocation);
                    more.add(pointLocation, load);
                }
                ++i2;
            }
            if (less.entries * more.entries == 0) {
                KDTree kDTree = KDTree.this;
                kDTree._nodes = kDTree._nodes - 2;
                KDTree.this.nodeList.remove(this.moreIndex);
                KDTree.this.nodeList.remove(this.lessIndex);
            } else {
                KDTree.this.mem_recycle = this.pointLocations.array;
                this.pointLocations = null;
                this.pointPayloads.clear();
                this.pointPayloads = null;
            }
        }
    }

    private static class PrioQueue<S> {
        Object[] elements;
        double[] priorities;
        private double minPrio;
        private int size;

        PrioQueue(int size, boolean prefill) {
            this.elements = new Object[size];
            this.priorities = new double[size];
            Arrays.fill(this.priorities, Double.POSITIVE_INFINITY);
            if (prefill) {
                this.minPrio = Double.POSITIVE_INFINITY;
                this.size = size;
            }
        }

        void addNoGrow(S value, double priority) {
            int index = this.searchFor(priority);
            int nextIndex = index + 1;
            int length = this.size - index - 1;
            System.arraycopy(this.elements, index, this.elements, nextIndex, length);
            System.arraycopy(this.priorities, index, this.priorities, nextIndex, length);
            this.elements[index] = value;
            this.priorities[index] = priority;
            this.minPrio = this.priorities[this.size - 1];
        }

        int searchFor(double priority) {
            int i = this.size - 1;
            int j = 0;
            while (i >= j) {
                int index = i + j >>> 1;
                if (this.priorities[index] < priority) {
                    j = index + 1;
                    continue;
                }
                i = index - 1;
            }
            return j;
        }

        double peekPrio() {
            return this.minPrio;
        }
    }

    public static class SearchResult<S> {
        public double distance;
        public S payload;

        SearchResult(double dist, S load) {
            this.distance = dist;
            this.payload = load;
        }
    }
}

