/*
 * Decompiled with CFR 0.152.
 */
package rdt.VirtualGuns.Guns.DC;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import rdt.KDTree.KDTree;
import rdt.Utils.MaximumEscapeAngle;
import rdt.VirtualGuns.Guns.DC.DCHit;
import rdt.VirtualGuns.Guns.DC.KernelDensityBase;

public class KernelDensityUniformOptimal
extends KernelDensityBase {
    public static Comparator<KDTree.SearchResult<DCHit>> CompareGuessFactors = new Comparator<KDTree.SearchResult<DCHit>>(){

        @Override
        public int compare(KDTree.SearchResult<DCHit> s1, KDTree.SearchResult<DCHit> s2) {
            return Double.compare(((DCHit)s1.payload).GuessFactor, ((DCHit)s2.payload).GuessFactor);
        }
    };

    @Override
    public double GetBestGuessFactor(ArrayList<KDTree.SearchResult<DCHit>> results, double distanceToTarget, MaximumEscapeAngle mea) {
        double botWidthAngle = this.GetBotWidthAngle(distanceToTarget);
        double oneOverBotWidthAngle = 1.0 / botWidthAngle;
        double bestDensity = 0.0;
        double bestGuessFactor = 0.0;
        Collections.sort(results, CompareGuessFactors);
        int numResults = results.size();
        int resultToCheck = 0;
        while (resultToCheck < numResults) {
            double diff;
            double checkGuessFactor;
            KDTree.SearchResult<DCHit> resultToAdd;
            KDTree.SearchResult<DCHit> result = results.get(resultToCheck);
            double guessFactor = ((DCHit)result.payload).GuessFactor;
            double density = ((DCHit)result.payload).HitWeight * result.distance;
            int resultToWeigh = resultToCheck - 1;
            while (resultToWeigh >= 0) {
                resultToAdd = results.get(resultToWeigh);
                checkGuessFactor = ((DCHit)resultToAdd.payload).GuessFactor;
                diff = (guessFactor - checkGuessFactor) * oneOverBotWidthAngle;
                if (diff > 1.0) break;
                density += ((DCHit)resultToAdd.payload).HitWeight * result.distance;
                --resultToWeigh;
            }
            resultToWeigh = resultToCheck + 1;
            while (resultToWeigh < numResults) {
                resultToAdd = results.get(resultToWeigh);
                checkGuessFactor = ((DCHit)resultToAdd.payload).GuessFactor;
                diff = (checkGuessFactor - guessFactor) * oneOverBotWidthAngle;
                if (diff > 1.0) break;
                density += ((DCHit)resultToAdd.payload).HitWeight * result.distance;
                ++resultToWeigh;
            }
            if (density > bestDensity) {
                bestDensity = density;
                bestGuessFactor = guessFactor;
            }
            ++resultToCheck;
        }
        return bestGuessFactor;
    }
}

