/*
 * Decompiled with CFR 0.152.
 */
package ntc;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.DeathEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Cannon
extends AdvancedRobot {
    private static final double maxVel = 10.0;
    private static final double minVel = 1.5;
    private static final double favDist = 210.0;
    static double dir = 48.0;
    static double enemyEnergy;
    static boolean flat;
    private static final int POINTS = 4000;
    private static final double BP = 3.0;
    private static final ArrayList<double[]> dcdata;
    private static double latVel;
    private static double lastEnemyVel;
    private static double lastEnemyHeading;
    private static double enemyX;
    private static double enemyY;

    static {
        dcdata = new ArrayList(4000);
    }

    public void run() {
        this.setColors(Color.WHITE, Color.RED, Color.GRAY);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double d;
        double d2 = enemyEnergy;
        enemyEnergy = e.getEnergy();
        if (d2 > d) {
            if (flat) {
                dir = Math.random() * 17.0 - 8.5;
                this.setMaxVelocity(Math.abs(dir) + 1.5);
            } else {
                this.onHitWall(null);
            }
        }
        this.setAhead(dir * Double.POSITIVE_INFINITY);
        double absBearing = e.getBearingRadians();
        double dist = e.getDistance();
        this.setTurnRightRadians(Utils.normalRelativeAngle((double)(absBearing + 1.5707963267948966 - Math.random() * Math.signum((dist - 210.0) * dir))));
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)((absBearing += this.getHeadingRadians()) - this.getRadarHeadingRadians())) * 2.0);
        Wave w = new Wave();
        new Wave().fireX = this.getX();
        enemyX = new Wave().fireX + Math.sin(absBearing) * dist;
        w.fireY = this.getY();
        enemyY = w.fireY + Math.cos(absBearing) * dist;
        w.absBearing = absBearing;
        double[] dArray = new double[5];
        dArray[0] = 0.0;
        double d3 = lastEnemyHeading;
        lastEnemyHeading = e.getHeadingRadians();
        dArray[1] = Utils.normalAbsoluteAngle((double)(d3 - lastEnemyHeading + 0.174533)) * 2.86478774787576;
        dArray[2] = Point2D.distanceSq(400.0, 300.0, enemyX, enemyY) * 4.435612646818778E-6;
        double d4 = Math.abs(lastEnemyVel);
        lastEnemyVel = e.getVelocity();
        dArray[3] = (d4 - Math.abs(lastEnemyVel) + 8.0) * 0.0875;
        dArray[4] = ((lastEnemyVel == 0.0 ? 0.0 : (latVel = Math.sin(lastEnemyHeading - absBearing) * lastEnemyVel)) + 8.0) * 0.075;
        double[] dataPoint = dArray;
        w.dataPoint = dArray;
        w.dir = Math.signum(latVel);
        double GF = 0.0;
        if (e.getEnergy() > 0.0) {
            int size;
            double bestDist = Double.POSITIVE_INFINITY;
            Object[] dcdataArray = dcdata.toArray();
            int i = size = dcdata.size();
            block0: while (--i >= 0) {
                double d5;
                double[] tmpPoint = (double[])dcdataArray[i];
                double tmpDist = 0.0;
                int a = dataPoint.length;
                while (--a > 0) {
                    double d6;
                    tmpDist += Cannon.dist(tmpPoint[a], dataPoint[a]);
                    if (d6 > bestDist) continue block0;
                }
                tmpDist *= Cannon.dist(size, i) * 2.7E-7 + 1.0;
                if (!(d5 < bestDist)) continue;
                GF = tmpPoint[0];
                bestDist = tmpDist;
            }
        }
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getGunHeadingRadians() + w.dir * GF + this.getVelocity() * Math.sin(e.getBearingRadians()) / dist)));
        if (this.setFireBullet(3.0) != null) {
            this.addCustomEvent(w);
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        enemyEnergy -= 16.0;
    }

    public void onHitWall(HitWallEvent e) {
        dir = -dir;
    }

    public void onDeath(DeathEvent e) {
        flat = flat || this.getRoundNum() < 3;
    }

    private static final double dist(double a, double b) {
        return (a -= b) * a;
    }

    class Wave
    extends Condition {
        double[] dataPoint;
        double absBearing;
        double dist;
        double dir;
        double fireX;
        double fireY;

        Wave() {
        }

        public boolean test() {
            double d;
            double d2;
            double d3;
            double eX = enemyX;
            double eY = enemyY;
            this.dist += 11.0;
            if (Point2D.distance(d3, d2, this.fireX, this.fireY) < d) {
                this.dataPoint[0] = Utils.normalRelativeAngle((double)(Math.atan2(eX - this.fireX, eY - this.fireY) - this.absBearing)) * this.dir;
                dcdata.add(this.dataPoint);
                Cannon.this.removeCustomEvent(this);
            }
            return false;
        }
    }
}

