/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import tcf.LruMap;
import tcf.PatEntry;
import tcf.Pattern;
import tcf.RemoveEldestCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PatternStore
implements RemoveEldestCallback<Pattern, ArrayList<PatEntry>> {
    private int m_maxSize;
    private LruMap<Pattern, ArrayList<PatEntry>> m_patterns;
    private Map<Integer, ArrayList<Pattern>> m_patternBins;

    PatternStore(int maxPatterns) {
        this.m_maxSize = maxPatterns;
        this.m_patterns = new LruMap();
        this.m_patternBins = new HashMap<Integer, ArrayList<Pattern>>();
        this.m_patterns.setRemoveEldestCallback(this);
    }

    public int size() {
        return this.m_patterns.size();
    }

    public ArrayList<PatEntry> get(Pattern p) {
        return (ArrayList)this.m_patterns.get(p);
    }

    public void put(Pattern p, ArrayList<PatEntry> pel) {
        this.m_patterns.put(p, pel);
        Integer bin = new Integer(p.bin());
        ArrayList<Pattern> pl = this.m_patternBins.get(bin);
        if (pl == null) {
            pl = new ArrayList();
            this.m_patternBins.put(bin, pl);
        }
        pl.add(p);
    }

    public Pattern getClosestPattern(Pattern p) {
        if (this.m_patterns.containsKey(p)) {
            return p;
        }
        Integer bin = new Integer(p.bin());
        ArrayList<Pattern> pl = this.m_patternBins.get(bin);
        if (pl == null) {
            return null;
        }
        double bestDist = Double.MAX_VALUE;
        Pattern bestPat = null;
        for (Pattern pat : pl) {
            double dist = pat.distSq(p);
            if (!(bestDist > dist)) continue;
            bestDist = dist;
            bestPat = pat;
        }
        return bestPat;
    }

    @Override
    public boolean removeEldestEntry(Map.Entry<Pattern, ArrayList<PatEntry>> eldest) {
        if (this.m_patterns.size() <= this.m_maxSize) {
            return false;
        }
        Pattern pat = eldest.getKey();
        Integer bin = new Integer(pat.bin());
        ArrayList<Pattern> pl = this.m_patternBins.get(bin);
        pl.remove(pat);
        return true;
    }

    public void report() {
        System.out.printf("  Number of patterns: %d\n", this.m_patterns.size());
        System.out.printf("      Number of bins: %d\n", this.m_patternBins.size());
        if (this.m_patternBins.size() > 0) {
            System.out.printf("Average patterns/bin: %.0f\n", (double)this.m_patterns.size() / (double)this.m_patternBins.size());
            int minBin = Integer.MAX_VALUE;
            int maxBin = 0;
            for (ArrayList<Pattern> pl : this.m_patternBins.values()) {
                if (minBin > pl.size()) {
                    minBin = pl.size();
                }
                if (maxBin >= pl.size()) continue;
                maxBin = pl.size();
            }
            System.out.printf("    Min/Max bin size: %d .. %d\n", minBin, maxBin);
        }
    }
}

