/*
 * Decompiled with CFR 0.152.
 */
package starpkg;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import robocode.RobocodeFileOutputStream;
import starpkg.EnemyType;
import starpkg.StarViewerZ;

public class EnemyLog {
    private StarViewerZ robot = null;
    private EnemyType enemyType = new EnemyType();

    public EnemyLog(StarViewerZ getRobot) {
        this.robot = getRobot;
    }

    public boolean SaveData(String cFileName, EnemyType e) {
        boolean result = true;
        try {
            PrintStream w = new PrintStream((OutputStream)new RobocodeFileOutputStream(this.robot.getDataFile(cFileName)));
            w.println(e.hitPer_1v1_Direct_o);
            w.println(e.hitPer_1v1_Linear_o);
            w.println(e.hitPer_1v1_Circular_o);
            w.println(e.hitPer_1v1_Jiggling_o);
            w.println(e.hitPer_1v1_JigglingForward_o);
            w.println(e.hitPer_1v1_RightAngle_o);
            w.println(e.best_1v1_MoveId);
            if (w.checkError()) {
                this.robot.out.println("Write File Error!");
                result = false;
            }
            w.close();
        }
        catch (IOException er) {
            this.robot.out.println("IOException trying to write: " + er);
            result = false;
        }
        return result;
    }

    public boolean ReadData(String cFileName) {
        boolean result = true;
        try {
            BufferedReader r = new BufferedReader(new FileReader(this.robot.getDataFile(cFileName)));
            this.enemyType.hitPer_1v1_Direct_o = Integer.parseInt(r.readLine());
            this.enemyType.hitPer_1v1_Linear_o = Integer.parseInt(r.readLine());
            this.enemyType.hitPer_1v1_Circular_o = Integer.parseInt(r.readLine());
            this.enemyType.hitPer_1v1_Jiggling_o = Integer.parseInt(r.readLine());
            this.enemyType.hitPer_1v1_JigglingForward_o = Integer.parseInt(r.readLine());
            this.enemyType.hitPer_1v1_RightAngle_o = Integer.parseInt(r.readLine());
            this.enemyType.best_1v1_MoveId = Integer.parseInt(r.readLine());
            r.close();
        }
        catch (IOException e) {
            result = false;
            this.robot.out.println("IOException trying to read: " + e);
        }
        catch (NumberFormatException e) {
            result = false;
            this.robot.out.println("NumberFormatException trying to read: " + e);
        }
        if (!result) {
            this.enemyType.Reset();
        }
        return result;
    }

    public EnemyType ReadEnemyTypeData(String cFileName) {
        this.ReadData(cFileName);
        return this.enemyType;
    }

    public EnemyType GetEnemyType() {
        return this.enemyType;
    }
}

