/*
 * Decompiled with CFR 0.152.
 */
package starpkg;

import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Random;
import robocode.HitByBulletEvent;
import starpkg.EnemyData;
import starpkg.MoveDataList;
import starpkg.Position;
import starpkg.StarViewerZ;

public class EnemyShootAnalyser {
    private StarViewerZ robot = null;
    private MoveDataList moveDataList = null;
    private EnemyData enemy = null;
    public int enemyShootType = 0;
    public final int MAX_USEMOVEDATA = 3;
    public RobotMoveData[] moveData = new RobotMoveData[3];
    public ArrayList enemyShootList = new ArrayList();
    public long moreHitTime = 0L;
    public long moreHitCtrl = 50L;
    public int moreHitCounter = 0;
    public boolean moreGoing = false;
    public long chMoveModeTime = 0L;
    public long chMoveModeCtrl = 50L;
    public int chHitCounter = 0;
    public int curMoveID = 0;
    public int chCirCounter = 0;
    public int setVelocity = 4;
    public double curEnemyEnergy = 10000.0;
    public int updateCounter = 0;
    public int oldCounter = 0;
    public int reDirRate = 5;
    public int reDirRate2 = 2;
    public int turnRate = 3;
    public long stopTurnTime = 0L;
    public long stopTurnCtrl = 25L;

    public EnemyShootAnalyser(StarViewerZ getRobot) {
        this.robot = getRobot;
        this.moveDataList = this.robot.moveCtrl.moveDataList;
        this.enemy = this.robot.enemy.enemyMain;
        this.SetDataArray();
    }

    public void SetDataArray() {
        int i = 0;
        while (i < 3) {
            this.moveData[i] = new RobotMoveData();
            ++i;
        }
        this.moveData[0].id = 3;
        this.moveData[1].id = 4;
        this.moveData[2].id = 5;
        this.moveData[0].totalHit = 0;
        this.moveData[1].totalHit = 0;
        this.moveData[2].totalHit = 0;
    }

    public void OnHitByBullet(HitByBulletEvent e) {
        if (this.robot.status.totalEnemy > 1) {
            this.MoreEnemy(e);
        } else {
            this.OneEnemy(e);
        }
    }

    public void MoreEnemy(HitByBulletEvent e) {
        double bear;
        String name = "";
        String tName = e.getName();
        ListIterator eList = this.enemyShootList.listIterator(0);
        boolean found = false;
        this.enemy = this.robot.enemy.enemyMain;
        if (!this.enemyShootList.isEmpty()) {
            while (eList.hasNext()) {
                name = (String)eList.next();
                if (name != tName) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            this.enemyShootList.add(tName);
        }
        if (this.moreGoing && ((bear = e.getBearing()) < 10.0 && bear > -10.0 || bear > 170.0 || bear < -170.0) && this.robot.moveCtrl.pointMoveStart) {
            this.robot.moveCtrl.PointMoveStop();
        }
        if (this.enemyShootList.size() > 1) {
            if (this.robot.status.totalEnemy > 3) {
                if (!this.moreGoing) {
                    this.MoveToNearCenter(10L);
                    this.enemyShootList.clear();
                    this.moreHitCounter = 0;
                    this.moreGoing = true;
                } else if (this.moreHitCounter > 1) {
                    this.moreGoing = false;
                }
            } else if (!this.moreGoing) {
                this.robot.moveCtrl.MoveToBestCorner();
                this.enemyShootList.clear();
                this.moreHitCounter = 0;
                this.moreGoing = true;
            } else if (this.moreHitCounter > 1) {
                this.moreGoing = false;
            }
        }
        if (e.getPower() >= 0.3) {
            ++this.moreHitCounter;
            if (e.getPower() >= 2.0 && !this.moreGoing && this.robot.status.totalEnemy > 3 && this.robot.status.totalEnemy < 8) {
                this.MoveToNearCenter(10L);
            }
            if (this.moreHitCounter > 2 && !this.moreGoing && this.robot.status.totalEnemy > 4) {
                this.MoveToNearCenter(10L);
            }
        }
        this.moreHitTime = this.robot.getTime();
    }

    public void MoveToCenter(long awayCtrl) {
        this.robot.moveCtrl.moveAwayCounter = 0;
        this.robot.moveCtrl.moveAwayCtrl = awayCtrl;
        this.moreHitCounter = 0;
        if (!this.robot.battleArea.centerPointArea.PointInside(new Position(this.robot.getX(), this.robot.getY())) && !this.robot.enemy.CheckRectEnemyInside(this.robot.battleArea.centerPointArea)) {
            this.robot.moveCtrl.PointMoveStart(this.robot.battleArea.centerPos, 7.0);
            this.robot.moveCtrl.StopMoreMoveCheckWall();
        } else if (this.robot.status.totalEnemy <= 3) {
            this.robot.moveCtrl.MoreMoveBestPoint();
            this.robot.moveCtrl.moveAwayCtrl = 10L;
        }
    }

    public void MoveToNearCenter(long awayCtrl) {
        this.robot.moveCtrl.moveAwayCounter = 0;
        this.robot.moveCtrl.moveAwayCtrl = awayCtrl;
        this.moreHitCounter = 0;
        if (!this.robot.battleArea.centerPointArea.PointInside(new Position(this.robot.getX(), this.robot.getY())) && !this.robot.enemy.CheckRectEnemyInside(this.robot.battleArea.centerPointArea)) {
            int myArea = this.robot.battleArea.CheckMyPosArea(this.robot.getX(), this.robot.getY());
            this.robot.moveCtrl.PointMoveStart(this.robot.battleArea.nearCornerPos[myArea], 8.0);
            this.robot.moveCtrl.StopMoreMoveCheckWall();
        }
    }

    public void MoreEnemyTimeCheck() {
        if (this.robot.getTime() - this.moreHitTime > this.moreHitCtrl) {
            this.moreHitTime = this.robot.getTime();
            this.enemyShootList.clear();
            this.moreHitCounter = 0;
            this.moreGoing = false;
        }
    }

    public void OneEnemy(HitByBulletEvent e) {
        this.robot.moveCtrl.moveStop = false;
        this.curEnemyEnergy += 100.0;
        if (e.getPower() > 0.1) {
            ++this.chHitCounter;
            this.chMoveModeTime = this.robot.getTime();
            if (this.chHitCounter > 2) {
                --this.enemy.type.best_1v1_MoveId;
                if (this.enemy.type.best_1v1_MoveId < 0) {
                    this.enemy.type.best_1v1_MoveId = 3;
                }
                this.chHitCounter = 0;
                ++this.chCirCounter;
                if (this.chCirCounter > 1) {
                    --this.reDirRate;
                    if (this.reDirRate <= 0) {
                        this.reDirRate = 5;
                    }
                    this.robot.out.println(this.reDirRate);
                    this.chCirCounter = 0;
                }
            }
        }
        if (this.robot.getTime() - this.chMoveModeTime > this.chMoveModeCtrl) {
            this.chHitCounter = 0;
        }
    }

    public void OneEnemyUpdate() {
        this.robot.moveCtrl.moveModeUsing = 0;
        this.enemy = this.robot.enemy.enemyMain;
        if (this.curEnemyEnergy > this.enemy.life) {
            if (this.curEnemyEnergy > this.enemy.life) {
                if (this.curEnemyEnergy - this.enemy.life > 0.2) {
                    ++this.updateCounter;
                    this.oldCounter = this.updateCounter;
                } else if (this.oldCounter == this.updateCounter) {
                    --this.oldCounter;
                } else {
                    ++this.updateCounter;
                    this.oldCounter = this.updateCounter;
                }
                this.robot.moveCtrl.moveStop = false;
                if (this.updateCounter % this.reDirRate == 0) {
                    this.robot.moveCtrl.moveDirection *= -1.0;
                    this.robot.setMaxVelocity(3.0);
                }
                if (this.updateCounter % this.turnRate == 0 && this.enemy.distance > 250.0 && this.robot.getTime() - this.stopTurnTime > this.stopTurnCtrl) {
                    this.robot.moveCtrl.TurnMoveStart(6L, new Random().nextInt() % 2, 8.0);
                }
                if (this.updateCounter % this.setVelocity == 0) {
                    if (this.updateCounter % this.setVelocity == 0) {
                        this.robot.setMaxVelocity(3.0);
                    }
                } else if (this.enemy.type.best_1v1_MoveId > 0 && this.updateCounter % this.enemy.type.best_1v1_MoveId == 0) {
                    this.robot.moveCtrl.moveDirection *= -1.0;
                }
                this.curEnemyEnergy = this.enemy.life;
            }
        } else {
            this.robot.moveCtrl.moveStop = true;
        }
    }

    public double GetDamageFromPower(double power) {
        double damage = 4.0 * power;
        if (power > 1.0) {
            damage += 2.0 * (power - 1.0);
        }
        return damage;
    }

    private class RobotMoveData {
        public int id = -1;
        public int totalHit = 0;

        private RobotMoveData() {
        }
    }
}

