/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import java.text.NumberFormat;
import shrub.Heading;

public class Location {
    private double mX = 0.0;
    private double mY = 0.0;
    NumberFormat dp2 = NumberFormat.getInstance();

    public void Initialise() {
        this.mX = 0.0;
        this.mY = 0.0;
        this.dp2.setMaximumFractionDigits(2);
        this.dp2.setMinimumFractionDigits(2);
    }

    public void Set(Location newLocn) {
        this.mX = newLocn.GetX();
        this.mY = newLocn.GetY();
    }

    public void Set(double newX, double newY) {
        this.mX = newX;
        this.mY = newY;
    }

    public void SetX(double newX) {
        this.mX = newX;
    }

    public void SetY(double newY) {
        this.mY = newY;
    }

    public void ChangeX(double deltaX) {
        this.mX += deltaX;
    }

    public void ChangeY(double deltaY) {
        this.mY += deltaY;
    }

    public double GetX() {
        return this.mX;
    }

    public double GetY() {
        return this.mY;
    }

    public double DistanceTo(Location toLocn) {
        double answer = -1.0;
        double fromX = this.mX;
        double fromY = this.mY;
        double toX = toLocn.GetX();
        double toY = toLocn.GetY();
        double deltaX = toX - fromX;
        double deltaY = toY - fromY;
        double targetDist2 = deltaX * deltaX + deltaY * deltaY;
        answer = Math.sqrt(targetDist2);
        return answer;
    }

    public void SetRelative(Location sourceLocn, Heading heading, double distance) {
        boolean okSoFar = true;
        double degAngle = 0.0;
        double xSense = 0.0;
        double ySense = 0.0;
        if (distance < 0.0) {
            System.out.println("ERROR! Location::SetRelative, distance < 0");
            okSoFar = false;
        } else if (heading.Get() < 0.0) {
            System.out.println("ERROR! Location::SetRelative, heading < 0");
            okSoFar = false;
        } else if (heading.Get() < 90.0) {
            degAngle = heading.Get();
            xSense = 1.0;
            ySense = 1.0;
        } else if (heading.Get() < 180.0) {
            degAngle = 180.0 - heading.Get();
            xSense = 1.0;
            ySense = -1.0;
        } else if (heading.Get() < 270.0) {
            degAngle = heading.Get() - 180.0;
            xSense = -1.0;
            ySense = -1.0;
        } else if (heading.Get() < 360.0) {
            degAngle = 360.0 - heading.Get();
            xSense = -1.0;
            ySense = 1.0;
        } else {
            System.out.println("ERROR! Location::SetRelative, heading >= 360");
            okSoFar = false;
        }
        if (okSoFar) {
            double radAngle = Math.toRadians(degAngle);
            double deltaX = distance * Math.sin(radAngle) * xSense;
            double deltaY = distance * Math.cos(radAngle) * ySense;
            this.mX = sourceLocn.GetX() + deltaX;
            this.mY = sourceLocn.GetY() + deltaY;
        }
    }

    public void Print() {
        System.out.print("[" + this.dp2.format(this.mX) + "," + this.dp2.format(this.mY) + "]");
    }

    public Location() {
        this.Initialise();
    }
}

