/*
 * Decompiled with CFR 0.152.
 */
package nosteel.AI;

import java.awt.Graphics2D;
import java.util.ListIterator;
import nosteel.Basics.Vector;
import nosteel.Modules.Aiming;
import nosteel.Modules.Data.EnemyData;
import nosteel.Modules.Data.FiredBullet;
import nosteel.Modules.Data.ScanData;
import nosteel.Modules.DataList;
import nosteel.Modules.Movement;
import nosteel.Modules.Radar;
import nosteel.Modules.Statistics;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class Cirrus {
    private DataList scanList = new DataList();
    private Radar radar = new Radar(this.scanList);
    private Aiming aiming = new Aiming(this.scanList);
    private Movement move = new Movement(this.scanList, this.aiming);
    private Statistics stat = new Statistics(this.scanList, this.aiming);
    private double firePower;
    private double firePowerOldTurn;
    private FiredBullet lastAim;

    public Cirrus() {
        this.stat.openCSV();
        this.firePower = 1.0;
        this.firePowerOldTurn = 1.0;
    }

    public void setNumberOfEnemies(int enemies) {
        this.scanList.intiEnemyArray(enemies);
    }

    public void setBattlefieldSize(Vector size) {
        this.aiming.setBattlefieldSize(size);
        this.move.setBattlefieldSize(size);
    }

    public void startNewTurn(double myEnergy) {
        this.lockToBotWithLowestEnergy();
        if (this.scanList.getNrOfEnemiesAlive() <= 1) {
            ScanData s;
            this.radar.setActiveIndex(Radar.INDEX_KeepTrack);
            this.move.setActiveIndex(Movement.INDEX_SerpentineApproach);
            this.move.setActiveIndex(Movement.INDEX_Sidestep);
            this.aiming.setActiveIndex(Aiming.INDEX_PatterMatch);
            this.aiming.setActiveIndex(Aiming.INDEX_LinearTargeting);
            EnemyData e = this.scanList.getEnemyData(this.aiming.getTargetName());
            if (e != null && (s = this.scanList.getEnemyData(this.aiming.getTargetName()).getLastScan()) != null && s.velocity == 0.0) {
                this.aiming.setActiveIndex(Aiming.INDEX_LinearTargeting);
            }
        }
        this.firePowerOldTurn = this.firePower;
        this.determineFirePower();
    }

    public double getRadarAngle(long time, double radarHeading) {
        return this.radar.getRadarTurnAngel(time, radarHeading);
    }

    private void lockToBotWithLowestEnergy() {
        double minEnemgy = Double.MAX_VALUE;
        ListIterator<EnemyData> dataIt = this.scanList.getEnemyListIterator(DataList.FRONT_OF_LIST);
        while (dataIt.hasNext()) {
            EnemyData e = dataIt.next();
            ScanData s = e.getLastScan();
            if (!e.isAlive() || s == null || !(minEnemgy > e.getLastScan().energy)) continue;
            minEnemgy = e.getLastScan().energy;
            this.aiming.setTargetName(e.getName());
        }
        this.radar.setTarget(this.aiming.getTargetName());
    }

    private void determineFirePower() {
        String target = this.aiming.getTargetName();
        if (target == null) {
            return;
        }
        ScanData res = this.scanList.getEnemyData(target).getLastScan();
        if (res == null) {
            return;
        }
        double distance = res.vDirToHim.getLength();
        this.firePower = 0.5;
        if (distance < 800.0) {
            this.firePower = 1.0;
        }
        if (distance < 500.0) {
            this.firePower = 2.0;
        }
        if (distance < 300.0) {
            this.firePower = 3.0;
        }
        if (distance < 200.0) {
            this.firePower = 4.0;
        }
    }

    public double getFirePower() {
        return this.firePowerOldTurn;
    }

    public void processMovement(Vector myPos, double myHeading) {
        this.move.process(myPos, myHeading);
    }

    public double getMovementAngle() {
        return this.move.getFinalRelativeAngle();
    }

    public double getMovementDist() {
        return this.move.getFinalDist();
    }

    public boolean processAiming(Vector myCurPos, long time) {
        return this.aiming.processAiming(myCurPos, this.firePower, time);
    }

    public double getTargetDirection() {
        this.lastAim = this.aiming.getFiredData();
        return this.lastAim.targetDirection;
    }

    public void registerFiredBullet(Bullet b) {
        this.lastAim.b = b;
        EnemyData e = this.scanList.getEnemyData(this.aiming.getTargetName());
        if (e != null) {
            e.addBullet(this.lastAim);
        } else {
            System.out.println("What the Fuck! registerFiredBullet ");
        }
    }

    public void myBulletHit(BulletHitEvent event) {
        FiredBullet fired = this.scanList.getFiredBullet(event.getBullet());
        if (fired != null) {
            if (fired.targetName.equals(event.getBullet().getVictim())) {
                fired.setHit();
            } else {
                fired.setHitWrong();
            }
        }
    }

    public void myBulletMissed(BulletMissedEvent event) {
        FiredBullet fired = this.scanList.getFiredBullet(event.getBullet());
        if (fired != null) {
            fired.setMissed();
        }
    }

    public void enemyDied(RobotDeathEvent event) {
        this.scanList.setEnemyKilled(event.getName());
    }

    public void attachScan(ScannedRobotEvent event, Vector myPos, double myHeadingRad, long time) {
        this.scanList.addScan(event, myPos, myHeadingRad, time);
    }

    public double getNumberDicoveredOfEnemies() {
        return this.scanList.getNumOfDiscoveredEnemies();
    }

    public void draw(Graphics2D g) {
        this.aiming.drawTargeting(g);
        this.move.draw(g);
        this.scanList.draw(g, this.aiming.getTargetName());
        this.stat.draw(g);
    }

    public void printTotalStatistic() {
        this.stat.analyseIndexed(Statistics.INDEX_BulletHitRate);
        this.stat.print();
    }

    public void logTotalStatistic(int round) {
        this.stat.analyseIndexed(Statistics.INDEX_BulletHitRate);
        this.stat.printCsvRow(round);
    }
}

