/*
 * Decompiled with CFR 0.152.
 */
package benhorner.utility.units;

import benhorner.utility.units.Distance;
import benhorner.utility.units.Heading;
import benhorner.utility.units.RelativeLocation;
import benhorner.utility.units.interfaces.AbsoluteToRelative;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Location
implements AbsoluteToRelative<Location, RelativeLocation> {
    private Distance x;
    private Distance y;

    public Location(Distance x, Distance y) {
        this.x = x;
        this.y = y;
    }

    public Location(double x, double y) {
        this(new Distance(x), new Distance(y));
    }

    public Distance getX() {
        return this.x;
    }

    public Distance getY() {
        return this.y;
    }

    @Override
    public Location add(RelativeLocation rp) {
        return new Location(this.x.add(rp.getX()), this.y.add(rp.getY()));
    }

    @Override
    public RelativeLocation subtract(Location location) {
        return new RelativeLocation(location, this);
    }

    public Distance getDistanceTo(Location l) {
        return new RelativeLocation(this, l).getDistance();
    }

    public Heading getHeadingTo(Location l) {
        return new RelativeLocation(this, l).getHeading();
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public boolean equals(Object o) {
        boolean result;
        boolean bl = result = o.getClass() == this.getClass();
        if (result) {
            Location l = (Location)o;
            result = l.x.equals(this.x) && l.y.equals(this.y);
        }
        return result;
    }

    public int hashCode() {
        return this.x.hashCode() * 31 + this.y.hashCode();
    }
}

