/*
 * Decompiled with CFR 0.152.
 */
package benhorner.utility.units;

import benhorner.utility.units.Duration;
import benhorner.utility.units.interfaces.AbsoluteToRelative;
import benhorner.utility.units.interfaces.Continuum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Time
implements Continuum<Time>,
AbsoluteToRelative<Time, Duration> {
    private double turns;

    public Time(double turns) {
        this.turns = turns;
    }

    @Override
    public Time negate() {
        return new Time(-this.turns);
    }

    @Override
    public Time add(Duration duration) {
        return new Time(this.turns + duration.toDouble());
    }

    @Override
    public Duration subtract(Time t) {
        return new Duration(this.turns - t.turns);
    }

    @Override
    public Time multiply(double d) {
        return new Time(this.turns * d);
    }

    @Override
    public Time divide(double d) {
        return new Time(this.turns / d);
    }

    @Override
    public double divide(Time t) {
        return this.turns / t.turns;
    }

    @Override
    public double toDouble() {
        return this.turns;
    }

    public String toString() {
        return String.valueOf(Long.toString(Math.round(this.turns))) + "t";
    }

    public boolean equals(Object o) {
        boolean result;
        boolean bl = result = o.getClass() == this.getClass();
        if (result) {
            Time t = (Time)o;
            result = t.turns == this.turns;
        }
        return result;
    }

    public int hashCode() {
        return new Double(this.turns).hashCode();
    }
}

