/*
 * Decompiled with CFR 0.152.
 */
package pedersen;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import pedersen.core.Foundation;
import pedersen.opponent.Target;
import pedersen.systems.FireControl;
import pedersen.systems.FireControlStandardImpl;
import pedersen.tactics.bot.WaveAnalysisGuessFactorImpl;
import pedersen.tactics.bot.WaveAnalysisMostVisitedImpl;
import pedersen.tactics.movement.MovementMethodSet;
import pedersen.tactics.movement.MovementMethodSetBuilder;
import pedersen.tactics.movement.MovementMethodSetImpl;
import pedersen.tactics.movement.impl.MovementMethodFieldRobotImpl;
import pedersen.tactics.movement.impl.MovementMethodFieldWallImpl;
import pedersen.tactics.movement.impl.MovementMethodGridImpl2;
import pedersen.tactics.movement.impl.MovementMethodGridImpl3;
import pedersen.tactics.movement.impl.MovementMethodTangoImpl3;
import pedersen.tactics.targeting.TargetingMethodBase;
import pedersen.tactics.targeting.impl.TargetingMethodBearingOffsetImpl;
import pedersen.tactics.targeting.impl.TargetingMethodCircularWSCImpl;
import pedersen.tactics.targeting.impl.TargetingMethodDeadOnImpl;
import pedersen.tactics.targeting.impl.TargetingMethodLinearWSCImpl;

public class Ugluk
extends Foundation {
    private static MovementMethodSetBuilder movementMethods = null;
    private static final Color chassis = new Color(31, 63, 31);
    private static final Color turret = new Color(31, 63, 31);
    private static final Color radar = new Color(31, 63, 31);

    public Ugluk() {
        super(chassis, turret, radar);
    }

    public void run() {
        this.init();
        super.run();
    }

    protected void init() {
        if (movementMethods == null) {
            movementMethods = this.getMovementMethodsMelee();
        }
    }

    public MovementMethodSet getMovementMethods(int opponentCount) {
        return movementMethods;
    }

    public MovementMethodSetBuilder getMovementMethods() {
        MovementMethodSetImpl newMovementMethods = new MovementMethodSetImpl();
        newMovementMethods.addAmbientMovementMethod(new MovementMethodFieldWallImpl());
        newMovementMethods.addAmbientMovementMethod(new MovementMethodFieldRobotImpl());
        newMovementMethods.addDynamicMovementMethod(new MovementMethodGridImpl2());
        newMovementMethods.addDynamicMovementMethod(new MovementMethodTangoImpl3());
        return newMovementMethods;
    }

    private MovementMethodSetBuilder getMovementMethodsMelee() {
        MovementMethodSetImpl newMovementMethods = new MovementMethodSetImpl();
        newMovementMethods.addDynamicMovementMethod(new MovementMethodGridImpl3());
        return newMovementMethods;
    }

    public List getOffensiveTargetingMethods(Target target) {
        ArrayList<TargetingMethodBase> targetingMethods = new ArrayList<TargetingMethodBase>();
        targetingMethods.add(new TargetingMethodDeadOnImpl());
        targetingMethods.add(new TargetingMethodLinearWSCImpl());
        targetingMethods.add(new TargetingMethodCircularWSCImpl());
        targetingMethods.add(new TargetingMethodBearingOffsetImpl(target.assignOffensiveWaveAnalysis(new WaveAnalysisGuessFactorImpl())));
        return targetingMethods;
    }

    public List getDefensiveTargetingMethods(Target target) {
        ArrayList<TargetingMethodBearingOffsetImpl> targetingMethods = new ArrayList<TargetingMethodBearingOffsetImpl>();
        targetingMethods.add(new TargetingMethodBearingOffsetImpl(target.assignDefensiveWaveAnalysis(new WaveAnalysisMostVisitedImpl())));
        return targetingMethods;
    }

    public List getMeleeTargetingMethods(Target target) {
        ArrayList<TargetingMethodDeadOnImpl> targetingMethods = new ArrayList<TargetingMethodDeadOnImpl>();
        targetingMethods.add(new TargetingMethodDeadOnImpl());
        return targetingMethods;
    }

    public FireControl getFireControl() {
        return new FireControlStandardImpl();
    }
}

