/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.movement.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pedersen.core.Snapshot;
import pedersen.debug.Stopwatches;
import pedersen.misc.Arena;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;
import pedersen.physics.StaticVector;
import pedersen.physics.StaticVectorImpl;
import pedersen.tactics.movement.MovementMethodBase;

public class MovementMethodGridImpl3
extends MovementMethodBase {
    private static final List relativePositions = MovementMethodGridImpl3.getRelativePositions();
    private static final int sampleSize = 12;
    private StaticPosition destination = null;

    public MovementMethodGridImpl3() {
        super(35);
        this.exclusive = true;
        this.setDestination(null);
    }

    public void activate(Snapshot chassis) {
        super.activate(chassis);
        this.setDestination(null);
    }

    public StaticVector getVector(Snapshot position, Snapshot target, long time) {
        StaticVector vector = null;
        Stopwatches.movementMethodGetRelativePositionTarget[this.getPersistenceId()].start();
        if (this.destination == null || this.destination.getDistance(position) < 4.0) {
            this.setDestination(this.getDestination(position, target, time));
        }
        if (this.destination != null) {
            vector = position.getRelativeVector(this.destination, position.getHeading());
        }
        Stopwatches.movementMethodGetRelativePositionTarget[this.getPersistenceId()].stop();
        return vector;
    }

    private StaticPosition getDestination(Snapshot position, StaticPosition target, long time) {
        StaticPositionImpl destination = null;
        StaticPosition unsafePosition = target;
        ArrayList eligibleSectors = new ArrayList(relativePositions);
        ArrayList<StaticPositionImpl> sampleSectors = new ArrayList<StaticPositionImpl>();
        int i = 0;
        while (sampleSectors.size() < 12 && eligibleSectors.size() > 0) {
            int value = (int)(Math.random() * (double)eligibleSectors.size());
            destination = new StaticPositionImpl((StaticPosition)position, (StaticPosition)eligibleSectors.get(value));
            eligibleSectors.remove(value);
            if (unsafePosition != null && destination.getDistance(unsafePosition) < 150.0) {
                destination = new StaticPositionImpl(unsafePosition, unsafePosition.getBearing(destination), 150.0);
            }
            if (Arena.isVehicleCenterInBoundary(destination)) {
                sampleSectors.add(destination);
            }
            ++i;
        }
        return MovementMethodGridImpl3.getBestDestination(sampleSectors);
    }

    private static StaticPosition getBestDestination(List sampleSectors) {
        StaticPosition bestDestination = null;
        double bestDestinationRating = Double.POSITIVE_INFINITY;
        Iterator iterator = sampleSectors.iterator();
        while (iterator.hasNext()) {
            StaticPosition position = (StaticPosition)iterator.next();
            double rating = MovementMethodGridImpl3.getDistanceRating(position);
            if (!(rating < bestDestinationRating)) continue;
            bestDestination = position;
            bestDestinationRating = rating;
        }
        return bestDestination;
    }

    public void setDestination(StaticPosition position) {
        this.destination = position;
    }

    private static List getRelativePositions() {
        ArrayList relativePositions = new ArrayList();
        MovementMethodGridImpl3.populateRelativePositions(relativePositions, 8.0, 36.0);
        MovementMethodGridImpl3.populateRelativePositions(relativePositions, 16.0, 72.0);
        MovementMethodGridImpl3.populateRelativePositions(relativePositions, 24.0, 108.0);
        MovementMethodGridImpl3.populateRelativePositions(relativePositions, 32.0, 144.0);
        MovementMethodGridImpl3.populateRelativePositions(relativePositions, 40.0, 180.0);
        return relativePositions;
    }

    private static void populateRelativePositions(List relativePositions, double slices, double radius) {
        double slice = Math.PI * 2 / slices;
        double i = 0.0;
        while (i < slices) {
            relativePositions.add(new StaticPositionImpl(new StaticVectorImpl(i * slice, radius)));
            i += 1.0;
        }
    }
}

