/*
 * Decompiled with CFR 0.152.
 */
package mc2.enemy;

import java.awt.geom.Point2D;
import mc2.enemy.Enemy;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

class EnemyImpl
implements Enemy {
    private String m_name = null;
    private double m_energy = 0.0;
    private double m_velocity = 0.0;
    private double m_x = 0.0;
    private double m_y = 0.0;
    private Point2D.Double m_location = new Point2D.Double();
    private double m_distance = 0.0;
    private double m_headingRadians = 0.0;
    private double m_heading = 0.0;
    private double m_bearingRadians = 0.0;
    private double m_bearing = 0.0;
    private double m_angle = 0.0;
    private long m_time = 0L;
    private double m_dangerousityLevel = 0.0;

    private EnemyImpl() {
    }

    private void setName(String in_Value) {
        this.m_name = in_Value;
    }

    private void setEnergy(double in_Value) {
        this.m_energy = in_Value;
    }

    private void setVelocity(double in_Value) {
        this.m_velocity = in_Value;
    }

    private void setX(double in_Value) {
        this.m_x = in_Value;
    }

    private void setY(double in_Value) {
        this.m_y = in_Value;
    }

    private void setLocation(Point2D.Double in_Value) {
        this.m_location = in_Value;
    }

    private void setLocation(double in_X, double in_Y) {
        this.m_location = new Point2D.Double(in_X, in_Y);
    }

    private void setAngle(double in_Value) {
        this.m_angle = in_Value;
    }

    private void setDistance(double in_Value) {
        this.m_distance = in_Value;
    }

    private void setHeadingRadians(double in_Value) {
        this.m_headingRadians = in_Value;
    }

    private void setHeading(double in_Value) {
        this.m_heading = in_Value;
    }

    private void setBearingRadians(double in_Value) {
        this.m_bearingRadians = in_Value;
    }

    private void setBearing(double in_Value) {
        this.m_bearing = in_Value;
    }

    private void setTime(long in_Value) {
        this.m_time = in_Value;
    }

    private void setDangerousityLevel(double in_Value) {
        this.m_dangerousityLevel = in_Value;
    }

    @Override
    public void IncreaseDangerousityLevel() {
        this.m_dangerousityLevel += 1.0;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public double getEnergy() {
        return this.m_energy;
    }

    @Override
    public double getVelocity() {
        return this.m_velocity;
    }

    @Override
    public double getX() {
        return this.m_x;
    }

    @Override
    public double getY() {
        return this.m_y;
    }

    @Override
    public Point2D.Double getLocation() {
        return this.m_location;
    }

    @Override
    public double getAngle() {
        return this.m_angle;
    }

    @Override
    public double getDistance() {
        return this.m_distance;
    }

    @Override
    public double getHeadingRadians() {
        return this.m_headingRadians;
    }

    @Override
    public double getHeading() {
        return this.m_heading;
    }

    @Override
    public double getBearingRadians() {
        return this.m_bearingRadians;
    }

    @Override
    public double getBearing() {
        return this.m_bearing;
    }

    @Override
    public long getTime() {
        return this.m_time;
    }

    @Override
    public boolean isUpdated(long t) {
        return t - 16L <= this.m_time;
    }

    @Override
    public double getDangerousityLevel() {
        return this.m_dangerousityLevel;
    }

    public static final Enemy createEnemy(ScannedRobotEvent in_event, AdvancedRobot bot) {
        EnemyImpl out_enemy = new EnemyImpl();
        out_enemy.setName(in_event.getName());
        out_enemy.setEnergy(in_event.getEnergy());
        out_enemy.setVelocity(in_event.getVelocity());
        double angle = bot.getHeadingRadians() + in_event.getBearingRadians();
        out_enemy.setAngle(angle);
        out_enemy.setX(bot.getX() + Math.sin(angle) * in_event.getDistance());
        out_enemy.setY(bot.getY() + Math.cos(angle) * in_event.getDistance());
        out_enemy.setLocation(bot.getX() + Math.sin(angle) * in_event.getDistance(), bot.getY() + Math.cos(angle) * in_event.getDistance());
        out_enemy.setDistance(in_event.getDistance());
        out_enemy.setHeadingRadians(in_event.getHeadingRadians());
        out_enemy.setHeading(in_event.getHeading());
        out_enemy.setBearingRadians(in_event.getBearingRadians());
        out_enemy.setBearing(in_event.getBearing());
        out_enemy.setTime(in_event.getTime());
        out_enemy.setDangerousityLevel(0.0);
        return out_enemy;
    }
}

