/*
 * Decompiled with CFR 0.152.
 */
package grybgoofy;

import grybgoofy.GBot;
import grybgoofy.GMath;
import grybgoofy.Wave;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import robocode.ScannedRobotEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WaveGun {
    static double guessFactor;
    static double velocityEnemyAverage;
    LinkedList WaveList;
    Wave w;
    Point2D.Double myLocation;
    Point2D.Double enemyLocation;
    Point2D.Double waveOrigin;
    double phi;
    double theta;
    double delta;
    double x;
    double y;
    double angleBulletMinus;
    double angleBulletPlus;
    double angleTrackEnemyMinus;
    double angleTrackEnemyPlus;
    double absoluteBearingToEnemy;
    double range;
    double angleTo;
    double power;
    double velocityBullet;

    public double getPower() {
        return this.power;
    }

    public void update() {
        if (this.WaveList.size() > 0) {
            int i = 0;
            while (i < this.WaveList.size()) {
                this.w = (Wave)this.WaveList.get(i);
                this.w.update();
                ++i;
            }
        }
    }

    public void scan(ScannedRobotEvent e, GBot r) {
        velocityEnemyAverage = 0.95 * velocityEnemyAverage + 0.05 * e.getVelocity();
        this.power = r.getEnergy() <= 10.0 ? 0.1 : (r.getEnergy() <= 20.0 ? 0.5 : 2.1);
        this.velocityBullet = 20.0 - (double)3 * this.power;
        this.range = e.getDistance();
        this.myLocation = new Point2D.Double(r.getX(), r.getY());
        this.absoluteBearingToEnemy = GMath.intervalize(e.getBearingRadians() + r.getHeadingRadians(), 0.0, Math.PI * 2);
        this.enemyLocation = new Point2D.Double(this.myLocation.getX() + GMath.sin(this.absoluteBearingToEnemy) * this.range, this.myLocation.getY() + GMath.cos(this.absoluteBearingToEnemy) * this.range);
        this.angleBulletMinus = e.getHeadingRadians() - this.absoluteBearingToEnemy;
        this.angleBulletPlus = Math.PI - this.angleBulletMinus;
        this.angleTrackEnemyPlus = GMath.asin(8.0 / this.velocityBullet * GMath.sin(this.angleBulletPlus));
        this.angleTrackEnemyMinus = GMath.asin(8.0 / this.velocityBullet * GMath.sin(this.angleBulletMinus));
        this.WaveList.add(new Wave(this.myLocation, this.absoluteBearingToEnemy, this.velocityBullet, this.angleTrackEnemyPlus, this.angleTrackEnemyMinus));
        if (this.WaveList.size() > 0) {
            int i = this.WaveList.size() - 1;
            while (i >= 0) {
                this.w = (Wave)this.WaveList.get(i);
                this.waveOrigin = this.w.origin();
                if (this.w.getRadius() > this.waveOrigin.distance(this.enemyLocation) + 20.0) {
                    this.WaveList.remove(i);
                } else if (this.w.getRadius() > this.waveOrigin.distance(this.enemyLocation) - 20.0) {
                    this.x = this.enemyLocation.getX() - this.waveOrigin.getX();
                    this.y = this.enemyLocation.getY() - this.waveOrigin.getY();
                    this.phi = GMath.intervalize(GMath.atan2(this.x, this.y), 0.0, Math.PI * 2);
                    this.theta = this.w.absoluteBearingToEnemy();
                    this.delta = this.phi - this.theta;
                    guessFactor = this.delta > 0.0 ? 0.85 * guessFactor + 0.15 * this.delta / this.w.angleTrackEnemyPlus() : 0.85 * guessFactor + 0.15 * this.delta / this.w.angleTrackEnemyMinus();
                }
                --i;
            }
        }
        if (guessFactor > 1.0) {
            guessFactor = 1.0;
        } else if (guessFactor < -1.0) {
            guessFactor = -1.0;
        }
        this.angleTrackEnemyPlus = GMath.asin(velocityEnemyAverage / this.velocityBullet * GMath.sin(this.angleBulletPlus));
        this.angleTrackEnemyMinus = GMath.asin(velocityEnemyAverage / this.velocityBullet * GMath.sin(this.angleBulletMinus));
        this.angleTo = guessFactor > 0.0 ? this.absoluteBearingToEnemy + guessFactor * this.angleTrackEnemyPlus : this.absoluteBearingToEnemy + guessFactor * this.angleTrackEnemyMinus;
        r.setTurnGunRightRadians(GMath.intervalize(this.angleTo - r.getGunHeadingRadians(), -Math.PI, Math.PI));
    }

    private final /* synthetic */ void this() {
        this.WaveList = new LinkedList();
        this.w = null;
        this.power = 2;
        this.velocityBullet = 20.0 - (double)3 * this.power;
    }

    WaveGun() {
        this.this();
    }
}

