/*
 * Decompiled with CFR 0.152.
 */
package rdm;

import java.awt.Color;
import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rdm.gunners.Gunner;
import rdm.gunners.dnn.DnnGunner;
import rdm.precepts.GunPrecept;
import rdm.robots.AdvancedRobotExtensionsKt;
import rdm.state.StateCollectorImpl;
import rdm.state.entities.State;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u0006H\u0002J\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\bH\u0002J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u0016\u001a\u00020\u00152\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0002J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u0012\u001a\u0004\u0018\u00010\u001aH\u0016J\u0012\u0010\u001b\u001a\u00020\u00192\b\u0010\u0012\u001a\u0004\u0018\u00010\u001cH\u0016J\u0012\u0010\u001d\u001a\u00020\u00192\b\u0010\u0012\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0016J\u0012\u0010\"\u001a\u00020\u00192\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010#\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lrdm/Grasshopper;", "Lrobocode/AdvancedRobot;", "()V", "collector", "Lrdm/state/StateCollectorImpl;", "gunner", "Lrdm/gunners/Gunner;", "lastPrecept", "Lkotlin/Pair;", "Lrdm/state/entities/State;", "Lrdm/precepts/GunPrecept;", "point", "", "prevEnergy", "buildHandler", "buildRandomPoint", "buildSafePoint", "absoluteBearing", "event", "Lrobocode/ScannedRobotEvent;", "canFire", "", "fireIfGunRotationDone", "precept", "onBulletHit", "", "Lrobocode/BulletHitEvent;", "onBulletHitBullet", "Lrobocode/BulletHitBulletEvent;", "onBulletMissed", "Lrobocode/BulletMissedEvent;", "onPaint", "g", "Ljava/awt/Graphics2D;", "onScannedRobot", "run", "Grasshopper"})
public final class Grasshopper
extends AdvancedRobot {
    private final StateCollectorImpl collector = StateCollectorImpl.INSTANCE;
    private Gunner gunner;
    private Pair<Double, Double> point;
    private Pair<State, GunPrecept> lastPrecept;
    private double prevEnergy = 100.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.collector.onRoundStart();
        this.gunner = this.buildHandler();
        this.point = new Pair<Double, Double>(this.getX(), this.getY());
        this.lastPrecept = null;
        try {
            try {
                this.setBodyColor(Color.ORANGE);
                this.setGunColor(Color.RED);
                this.setRadarColor(Color.BLACK);
                this.setBulletColor(Color.WHITE);
                this.setAdjustGunForRobotTurn(true);
                this.setAdjustRadarForGunTurn(true);
                while (true) {
                    if (this.getRadarTurnRemaining() == 0.0) {
                        this.setTurnRadarRightRadians(DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY());
                    }
                    Pair<Double, Double> pair = this.point;
                    if (pair == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("point");
                    }
                    AdvancedRobotExtensionsKt.setMoveTo(this, pair);
                    this.execute();
                }
            }
            catch (Error error) {
                throw (Throwable)error;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Gunner gunner = this.gunner;
                if (gunner == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("gunner");
                }
                gunner.dispose();
                this.collector.onRoundStop();
            }
        }
        catch (Throwable throwable) {
            Gunner gunner = this.gunner;
            if (gunner == null) {
                Intrinsics.throwUninitializedPropertyAccessException("gunner");
            }
            gunner.dispose();
            this.collector.onRoundStop();
            throw throwable;
        }
    }

    public void onScannedRobot(@Nullable ScannedRobotEvent event) {
        double enemyEnergyDrop;
        boolean shotDetected;
        ScannedRobotEvent scannedRobotEvent = event;
        if (scannedRobotEvent == null) {
            Intrinsics.throwNpe();
        }
        boolean bl = shotDetected = (enemyEnergyDrop = this.prevEnergy - scannedRobotEvent.getEnergy()) > 0.0 && enemyEnergyDrop <= 3.0;
        if (shotDetected) {
            this.point = this.getDistanceRemaining() == 0.0 ? this.buildSafePoint(event) : new Pair<Double, Double>(this.getX(), this.getY());
        }
        this.prevEnergy = event.getEnergy();
        try {
            AdvancedRobotExtensionsKt.lockRadarOnTarget(this, event);
            State state = this.collector.collect(AdvancedRobotExtensionsKt.instantStateOf(this, event));
            Gunner gunner = this.gunner;
            if (gunner == null) {
                Intrinsics.throwUninitializedPropertyAccessException("gunner");
            }
            GunPrecept precept = gunner.handle(state);
            Pair<State, GunPrecept> finalLastPrecept = this.lastPrecept;
            if (finalLastPrecept == null) {
                boolean shouldFire;
                boolean bl2 = shouldFire = this.canFire() && precept.getShouldFire();
                if (shouldFire) {
                    AdvancedRobotExtensionsKt.lockGunOnTarget(this, event, precept.getRotation());
                    this.lastPrecept = new Pair<State, GunPrecept>(state, precept);
                } else {
                    AdvancedRobotExtensionsKt.lockGunOnTarget(this, event, 0.0);
                }
            } else if (this.fireIfGunRotationDone(finalLastPrecept)) {
                this.lastPrecept = null;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void onBulletHit(@Nullable BulletHitEvent event) {
        Gunner gunner = this.gunner;
        if (gunner == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gunner");
        }
        BulletHitEvent bulletHitEvent = event;
        if (bulletHitEvent == null) {
            Intrinsics.throwNpe();
        }
        Bullet bullet = bulletHitEvent.getBullet();
        Intrinsics.checkExpressionValueIsNotNull(bullet, "event!!.bullet");
        gunner.saveShotResult(bullet, true);
    }

    public void onBulletHitBullet(@Nullable BulletHitBulletEvent event) {
        Gunner gunner = this.gunner;
        if (gunner == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gunner");
        }
        BulletHitBulletEvent bulletHitBulletEvent = event;
        if (bulletHitBulletEvent == null) {
            Intrinsics.throwNpe();
        }
        Bullet bullet = bulletHitBulletEvent.getBullet();
        Intrinsics.checkExpressionValueIsNotNull(bullet, "event!!.bullet");
        gunner.saveShotResult(bullet, null);
    }

    public void onBulletMissed(@Nullable BulletMissedEvent event) {
        Gunner gunner = this.gunner;
        if (gunner == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gunner");
        }
        BulletMissedEvent bulletMissedEvent = event;
        if (bulletMissedEvent == null) {
            Intrinsics.throwNpe();
        }
        Bullet bullet = bulletMissedEvent.getBullet();
        Intrinsics.checkExpressionValueIsNotNull(bullet, "event!!.bullet");
        gunner.saveShotResult(bullet, false);
    }

    public void onPaint(@NotNull Graphics2D g) {
        Intrinsics.checkParameterIsNotNull(g, "g");
        g.setColor(Color.RED);
        int n = (int)this.getX();
        int n2 = (int)this.getY();
        Pair<Double, Double> pair = this.point;
        if (pair == null) {
            Intrinsics.throwUninitializedPropertyAccessException("point");
        }
        int n3 = (int)((Number)pair.getFirst()).doubleValue();
        Pair<Double, Double> pair2 = this.point;
        if (pair2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("point");
        }
        g.drawLine(n, n2, n3, (int)((Number)pair2.getSecond()).doubleValue());
    }

    private final boolean fireIfGunRotationDone(Pair<State, GunPrecept> precept) {
        boolean bl;
        if (Utils.isNear((double)this.getGunTurnRemaining(), (double)0.0)) {
            Bullet bullet;
            Bullet bullet2 = bullet = this.setFireBullet(precept.getSecond().getBulletPower());
            if (bullet2 != null) {
                Bullet bullet3;
                Bullet it = bullet3 = bullet2;
                Gunner gunner = this.gunner;
                if (gunner == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("gunner");
                }
                gunner.saveShot(bullet, precept.getFirst(), precept.getSecond());
            }
            bl = bullet != null;
        } else {
            bl = false;
        }
        return bl;
    }

    private final Pair<Double, Double> buildRandomPoint() {
        return new Pair<Double, Double>(100.0 + (double)Utils.getRandom().nextInt(600), 100.0 + (double)Utils.getRandom().nextInt(400));
    }

    private final Pair<Double, Double> buildSafePoint(ScannedRobotEvent event) {
        double distance2;
        double absoluteBearing = this.getHeading() + event.getBearing();
        Pair<Double, Double> point1 = this.buildSafePoint(absoluteBearing);
        Pair<Double, Double> point2 = this.buildSafePoint(absoluteBearing);
        double halfBattleFieldWidth = this.getBattleFieldWidth() / (double)2;
        double halfBattleFieldHeight = this.getBattleFieldHeight() / (double)2;
        double distance1 = Math.sqrt(Math.pow(((Number)point1.getFirst()).doubleValue() - halfBattleFieldWidth, 2.0) + Math.pow(((Number)point1.getSecond()).doubleValue() - halfBattleFieldHeight, 2.0));
        return distance1 < (distance2 = Math.sqrt(Math.pow(((Number)point2.getFirst()).doubleValue() - halfBattleFieldWidth, 2.0) + Math.pow(((Number)point2.getSecond()).doubleValue() - halfBattleFieldHeight, 2.0))) ? point1 : point2;
    }

    private final Pair<Double, Double> buildSafePoint(double absoluteBearing) {
        double safeAngle = Math.toRadians(absoluteBearing - (double)90);
        int distance = 50 + Utils.getRandom().nextInt(200);
        int safeDistance = Utils.getRandom().nextBoolean() ? distance : -distance;
        double relativeX = (double)safeDistance * Math.sin(safeAngle);
        double relativeY = (double)safeDistance * Math.cos(safeAngle);
        double rawTargetX = this.getX() + relativeX;
        double targetX = Math.max(50.0, Math.min(750.0, rawTargetX));
        double rawTargetY = this.getY() + relativeY;
        double targetY = Math.max(50.0, Math.min(550.0, rawTargetY));
        return new Pair<Double, Double>(targetX, targetY);
    }

    private final boolean canFire() {
        return !(this.getGunHeat() > 0.0);
    }

    private final Gunner buildHandler() {
        Gunner gunner = new DnnGunner();
        return gunner;
    }
}

