/*
 * Decompiled with CFR 0.152.
 */
package apc;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Random;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Colossus2
extends AdvancedRobot {
    final double safeDistance = 100.0;
    final double shootDistLimit = 250.0;
    static int posIndex = 0;
    static int scanDirection = 1;
    static boolean haveTarget = false;
    static boolean targetingMode = false;
    static int numOthers;
    Random randomGen = new Random();
    static double[][] RS;
    static String[] RSnames;
    static double[][] RS_F;
    static String[] RSnames_F;
    static double[] targetScan;
    static String targetName;
    static int RSlength;
    final int[] RSindex;
    static int scannedX;
    static int scannedY;
    static int predictedX_T;
    static int predictedY_T;
    static int headingX;
    static int headingY;
    final double meleePower = 3.0;
    static long fireTime;
    int nearestRobot;
    static double oldEnemyHeading;
    static String lastBulletHitRobotName;
    static int numberOfHits;
    static boolean makingMovement;
    static double bearingToPredTarget;
    static long moveEndTime;
    static long timeSinceLastScan;

    static {
        RS = new double[20][5];
        RSnames = new String[20];
        RS_F = new double[20][5];
        RSnames_F = new String[20];
        targetScan = new double[5];
        RSlength = 0;
        fireTime = 0L;
        oldEnemyHeading = 0.0;
        lastBulletHitRobotName = null;
        numberOfHits = 0;
        makingMovement = false;
        bearingToPredTarget = 0.0;
        moveEndTime = 0L;
        timeSinceLastScan = 0L;
    }

    public Colossus2() {
        int[] nArray = new int[20];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        nArray[12] = 12;
        nArray[13] = 13;
        nArray[14] = 14;
        nArray[15] = 15;
        nArray[16] = 16;
        nArray[17] = 17;
        nArray[18] = 18;
        nArray[19] = 19;
        this.RSindex = nArray;
        this.meleePower = 3.0;
        this.nearestRobot = 0;
    }

    public double distanceToTarget(double[] Tpos) {
        double[] pos = new double[]{this.getX(), this.getY()};
        double distance = Math.sqrt(Math.pow(Tpos[0] - pos[0], 2.0) + Math.pow(Tpos[1] - pos[1], 2.0));
        return distance;
    }

    public double bearingToTarget(double[] Tpos) {
        double[] pos = new double[]{this.getX(), this.getY()};
        double headingToCentre = Math.atan2(Tpos[1] - pos[1], Tpos[0] - pos[0]);
        headingToCentre = headingToCentre / (Math.PI * 2) * 360.0;
        headingToCentre = -1.0 * (headingToCentre - 90.0);
        double bearingFromCentre = Utils.normalRelativeAngleDegrees((double)(headingToCentre - this.getHeading()));
        return bearingFromCentre;
    }

    public double[] locationOfTarget(double x, double y, double bearing, double distance) {
        double[] newpos = new double[2];
        double bearingRad = bearing * Math.PI / 180.0;
        newpos[0] = x + distance * Math.sin(bearingRad);
        newpos[1] = y + distance * Math.cos(bearingRad);
        return newpos;
    }

    public int nearestRobot() {
        int bestSoFar = 1;
        double highestDist = 9999.9;
        int[] nArray = this.RSindex;
        int n = this.RSindex.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (RS[i][2] < highestDist && RS[i][2] > 0.0) {
                bestSoFar = i;
                highestDist = RS[i][2];
            }
            ++n2;
        }
        return bestSoFar;
    }

    public void run() {
        this.setColors(Color.black, Color.red, Color.red);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        moveEndTime = 0L;
        while (true) {
            ++timeSinceLastScan;
            if (!targetingMode) {
                this.turnRadarRight(360.0);
                this.nearestRobot = this.nearestRobot();
                targetingMode = true;
                targetScan = RS[this.nearestRobot];
                targetName = RSnames[this.nearestRobot];
                System.out.println("Target is " + targetName);
                int i = 0;
                while (i < 5) {
                    System.out.print(String.valueOf(targetScan[i]) + ", ");
                    ++i;
                }
                if (RSnames[this.nearestRobot] == null) {
                    targetingMode = false;
                }
                double absoluteBearingDeg = Utils.normalRelativeAngleDegrees((double)(this.getHeading() + targetScan[1]));
                System.out.print("\nAbsolute bearing is " + absoluteBearingDeg + "\n");
                this.setTurnRadarRight((double)scanDirection * Double.POSITIVE_INFINITY);
            } else {
                System.out.println("Target is " + RSnames[this.nearestRobot]);
                this.setTurnRight(targetScan[1]);
                double angle = Math.toRadians(Utils.normalRelativeAngleDegrees((double)(this.getHeading() + targetScan[1])));
                double bulletPower = -0.0116 * targetScan[2] + 4.74;
                double bulletVelocity = 20.0 - 3.0 * bulletPower;
                double timeToReachTarget = targetScan[2] / bulletVelocity;
                double distanceTravelled_T = timeToReachTarget * targetScan[4];
                scannedX = (int)(this.getX() + Math.sin(angle) * targetScan[2]);
                scannedY = (int)(this.getY() + Math.cos(angle) * targetScan[2]);
                double headingOfTarget = Math.toRadians(targetScan[3]);
                predictedX_T = (int)((double)scannedX + Math.sin(headingOfTarget) * distanceTravelled_T);
                predictedY_T = (int)((double)scannedY + Math.cos(headingOfTarget) * distanceTravelled_T);
                double myHeading = Math.toRadians(this.getHeading() % 360.0);
                headingX = (int)(this.getX() + Math.sin(myHeading) * targetScan[2]);
                headingY = (int)(this.getY() + Math.cos(myHeading) * targetScan[2]);
                double[] PredT_pos = new double[]{predictedX_T, predictedY_T};
                bearingToPredTarget = this.bearingToTarget(PredT_pos);
                if (timeSinceLastScan > 5L) {
                    this.setTurnRadarRight(360.0);
                } else if (scanDirection == 1) {
                    this.setTurnRadarRight(40.0);
                    scanDirection = 0;
                } else {
                    this.setTurnRadarLeft(40.0);
                    scanDirection = 1;
                }
                this.doGun(bulletPower);
                this.movementRoutine();
            }
            this.scan();
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        timeSinceLastScan = 0L;
        String name = e.getName();
        int nameLocation = 0;
        boolean nameFound = false;
        int i = 0;
        while (i < 20) {
            if (name == RSnames[i]) {
                nameFound = true;
                nameLocation = i;
            }
            ++i;
        }
        if (nameFound) {
            Colossus2.RS[nameLocation][0] = e.getEnergy();
            Colossus2.RS[nameLocation][1] = e.getBearing();
            Colossus2.RS[nameLocation][2] = e.getDistance();
            Colossus2.RS[nameLocation][3] = e.getHeading();
            Colossus2.RS[nameLocation][4] = e.getVelocity();
            Colossus2.RSnames[nameLocation] = e.getName();
        } else {
            Colossus2.RS[++Colossus2.RSlength][0] = e.getEnergy();
            Colossus2.RS[Colossus2.RSlength][1] = e.getBearing();
            Colossus2.RS[Colossus2.RSlength][2] = e.getDistance();
            Colossus2.RS[Colossus2.RSlength][3] = e.getHeading();
            Colossus2.RS[Colossus2.RSlength][4] = e.getVelocity();
            Colossus2.RSnames[Colossus2.RSlength] = e.getName();
        }
        if (targetingMode && targetName == e.getName()) {
            Colossus2.targetScan[0] = e.getEnergy();
            Colossus2.targetScan[1] = e.getBearing();
            Colossus2.targetScan[2] = e.getDistance();
            Colossus2.targetScan[3] = e.getHeading();
            Colossus2.targetScan[4] = e.getVelocity();
            double BPslope = -0.019333333333333334;
            double BPintercept = 3.0 - BPslope * 100.0;
            double bulletPower = BPslope * targetScan[2] + BPintercept;
            double myX = this.getX();
            double myY = this.getY();
            double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
            double enemyX = this.getX() + e.getDistance() * Math.sin(absoluteBearing);
            double enemyY = this.getY() + e.getDistance() * Math.cos(absoluteBearing);
            double enemyHeading = e.getHeadingRadians();
            double enemyHeadingChange = enemyHeading - oldEnemyHeading;
            double enemyVelocity = e.getVelocity();
            oldEnemyHeading = enemyHeading;
            double deltaTime = 0.0;
            double battleFieldHeight = this.getBattleFieldHeight();
            double battleFieldWidth = this.getBattleFieldWidth();
            double predictedX = enemyX;
            double predictedY = enemyY;
            while ((deltaTime += 1.0) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)) {
                predictedY += Math.cos(enemyHeading) * enemyVelocity;
                if (!((predictedX += Math.sin(enemyHeading += enemyHeadingChange) * enemyVelocity) < 18.0 || predictedY < 18.0 || predictedX > battleFieldWidth - 18.0) && !(predictedY > battleFieldHeight - 18.0)) continue;
                predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);
                predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
                break;
            }
            double theta = Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - this.getX(), predictedY - this.getY()));
            this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absoluteBearing - this.getRadarHeadingRadians())));
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(theta - this.getGunHeadingRadians())));
            this.doGun(bulletPower);
            double[] PredT_pos = new double[]{predictedX, predictedY};
            bearingToPredTarget = this.bearingToTarget(PredT_pos);
            this.movementRoutine();
            this.scan();
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        numberOfHits = lastBulletHitRobotName == e.getName() ? ++numberOfHits : 0;
        lastBulletHitRobotName = e.getName();
        if (numberOfHits > 2) {
            this.nearestRobot = this.selectRobotByName(lastBulletHitRobotName);
            targetScan = RS[this.nearestRobot];
            targetName = lastBulletHitRobotName;
            Colossus2.targetScan[1] = e.getBearing();
            this.setTurnRight(targetScan[1]);
            this.setTurnRadarRight(360.0);
        }
    }

    public void onHitWall(HitWallEvent e) {
        System.out.println("Hit Wall Event");
        double Xpos = this.getX();
        double Ypos = this.getY();
        double BattlefieldY = this.getBattleFieldHeight();
        double BattlefieldX = this.getBattleFieldWidth();
        double centreY = BattlefieldY / 2.0;
        double centreX = BattlefieldX / 2.0;
        double headingToCentre = Math.atan2(centreY - Ypos, centreX - Xpos);
        headingToCentre = headingToCentre / (Math.PI * 2) * 360.0;
        headingToCentre = -1.0 * (headingToCentre - 90.0);
        double bearingFromCentre = Utils.normalRelativeAngleDegrees((double)(headingToCentre - this.getHeading()));
        this.setTurnRight(bearingFromCentre);
        this.setAhead(80.0);
    }

    public void onHitRobot(HitRobotEvent event) {
        if (event.getBearing() > -90.0 && event.getBearing() <= 90.0) {
            this.setBack(60.0);
        } else {
            this.setAhead(60.0);
        }
        String robotName = event.getName();
        this.nearestRobot = this.selectRobotByName(robotName);
        targetScan = RS[this.nearestRobot];
        targetName = RSnames[this.nearestRobot];
        Colossus2.targetScan[1] = event.getBearing();
        this.setTurnRadarRight(360.0);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        int i = 0;
        while (i < 20) {
            Colossus2.RSnames[i] = null;
            int j = 0;
            while (j < 5) {
                Colossus2.RS[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        RSlength = 0;
        targetingMode = false;
        moveEndTime = 0L;
        makingMovement = false;
    }

    void doGun(double bulletPower) {
        boolean fireGun;
        boolean bl = fireGun = fireTime <= this.getTime() && Math.abs(this.getGunTurnRemaining()) < 5.0 && targetScan[2] < 250.0;
        if (!fireGun) {
            if (fireTime > this.getTime()) {
                System.out.print("Fire time exception, ");
            }
            if (!(Math.abs(this.getGunTurnRemaining()) < 5.0)) {
                System.out.print("Gun position exception, ");
            }
            if (!(targetScan[2] < 250.0)) {
                System.out.print("Range exception.");
            }
            System.out.print("\n");
        }
        if (fireGun) {
            this.setFire(bulletPower);
        }
        fireTime = this.getTime() + 1L;
    }

    public void movementRoutine() {
        if (makingMovement) {
            if (this.getTime() > moveEndTime) {
                makingMovement = false;
                if (targetScan[2] > 100.0) {
                    this.setTurnRight(bearingToPredTarget);
                    this.setAhead(20.0);
                } else if (targetScan[2] < 100.0) {
                    this.setTurnRight(60.0);
                    this.setBack(150.0);
                    moveEndTime = this.getTime() + 23L;
                    makingMovement = true;
                    this.setTurnRadarRight(360.0);
                }
            }
        } else if (targetScan[2] > 100.0) {
            this.setTurnRight(bearingToPredTarget);
            this.setAhead(20.0);
        } else if (targetScan[2] < 100.0) {
            double randomNum = this.randomGen.nextDouble();
            if (randomNum < 0.5) {
                this.setTurnRight(60.0);
            } else {
                this.setTurnLeft(60.0);
            }
            this.setBack(100.0);
            moveEndTime = this.getTime() + 16L;
            makingMovement = true;
        }
    }

    public void onPaint(Graphics2D g) {
        g.setColor(new Color(255, 0, 0, 128));
        g.drawLine(scannedX, scannedY, (int)this.getX(), (int)this.getY());
        g.fillRect(scannedX - 20, scannedY - 20, 40, 40);
        g.setColor(Color.GREEN);
        g.drawLine(headingX, headingY, (int)this.getX(), (int)this.getY());
        g.setColor(Color.BLUE);
        g.drawLine(predictedX_T, predictedY_T, (int)this.getX(), (int)this.getY());
        g.fillRect(predictedX_T - 5, predictedY_T - 5, 10, 10);
    }

    public int selectRobotByName(String robotName) {
        int robotIndex = 0;
        int i = 0;
        while (i < 20) {
            if (RSnames[i] == robotName) {
                robotIndex = i;
            }
            ++i;
        }
        return robotIndex;
    }

    public boolean detectWallBot(ScannedRobotEvent e) {
        boolean isWallBot = false;
        double[] newpos = new double[2];
        newpos = this.locationOfTarget(this.getX(), this.getY(), e.getBearing(), e.getDistance());
        return isWallBot;
    }
}

