/*
 * Decompiled with CFR 0.152.
 */
package romz.robot.guessfactor;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import romz.model.Enemy;
import romz.model.Wave;
import romz.util.UtilRobot;

public class TeasingFox
extends UtilRobot {
    private static final double HALF_ROBOT_SIZE = 18.0;
    private static final double RADAR_SECURITY_DISTANCE = 26.0;
    private static final int RESCAN_DELAY = 3;
    private static final int FULL_TURN = 360;
    private static final double OSCILLATION_DISTANCE = 250.0;
    private static final double MIN_WALL_DISTANCE = 100.0;
    private static final double DESIRED_ENEMY_DISTANCE = 200.0;
    private static final double MIN_DISTANCE_ADJUSTMENT_FACTOR = 0.25;
    private static final double MAX_DISTANCE_ADJUSTMENT_FACTOR = 1.75;
    private static final int DISTANCE_SENSITIVITY = 20;
    private static final double MAX_POWER_DISTANCE = 300.0;
    private static final int NB_FIRE_ANGLE_SECTORS = 17;
    private static final int HALF_FIRE_ANGLE_RANGE = 8;
    private static final int NB_DISTANCE_SECTORS = 5;
    private static final double DISTANCE_SECTOR_LENGTH = 240.0;
    private double fieldHeight;
    private double fieldWidth;
    private long time;
    private double energy;
    private double x;
    private double y;
    private double heading;
    private double radarHeading;
    private double radarTurnRemaining;
    private double gunHeading;
    private double gunHeat;
    private double distanceRemaining;
    private int gear = 1;
    private Enemy enemy;
    private Enemy lastEnemy;
    private int currentEnemyDistanceSector;
    private int[] currentEnemyHitProfile;
    private List<Wave> waves = new ArrayList<Wave>();
    private int[][] enemyHitProfile = new int[5][17];

    public void run() {
        this.init();
        while (true) {
            this.updateData();
            this.radar();
            this.move();
            this.aim();
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.lastEnemy = this.enemy;
        this.enemy = new Enemy();
        this.enemy.timeScanned = this.getTime();
        this.enemy.energy = e.getEnergy();
        this.enemy.relativeBearing = e.getBearing();
        this.enemy.absoluteBearing = Utils.normalAbsoluteAngleDegrees((double)(this.heading + this.enemy.relativeBearing));
        this.enemy.distance = e.getDistance();
        this.enemy.x = this.x + this.enemy.distance * this.sin(this.enemy.absoluteBearing);
        this.enemy.y = this.y + this.enemy.distance * this.cos(this.enemy.absoluteBearing);
        this.enemy.heading = e.getHeading();
        this.enemy.velocity = e.getVelocity();
        if (this.lastEnemy != null) {
            this.enemy.acceleration = (this.enemy.velocity - this.lastEnemy.velocity) / (double)(this.enemy.timeScanned - this.lastEnemy.timeScanned);
            this.enemy.turnRate = Utils.normalRelativeAngleDegrees((double)(this.enemy.heading - this.lastEnemy.heading)) / (double)(this.enemy.timeScanned - this.lastEnemy.timeScanned);
        }
    }

    public void onPaint(Graphics2D g) {
        g.drawLine(0, 0, 500, 500);
    }

    private void init() {
        this.setColors(Color.BLACK, Color.DARK_GRAY, Color.WHITE);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.fieldHeight = this.getBattleFieldHeight();
        this.fieldWidth = this.getBattleFieldWidth();
    }

    private void updateData() {
        this.time = this.getTime();
        this.energy = this.getEnergy();
        this.x = this.getX();
        this.y = this.getY();
        this.heading = this.getHeading();
        this.radarHeading = this.getRadarHeading();
        this.radarTurnRemaining = this.getRadarTurnRemaining();
        this.gunHeading = this.getGunHeading();
        this.gunHeat = this.getGunHeat();
        this.distanceRemaining = this.getDistanceRemaining();
        if (this.enemy != null) {
            this.enemy.absoluteBearing = this.heading + this.enemy.relativeBearing;
            this.currentEnemyDistanceSector = this.getDistanceSector(this.enemy.distance);
            this.currentEnemyHitProfile = this.enemyHitProfile[this.currentEnemyDistanceSector];
        }
        this.updateFireData();
    }

    private void updateFireData() {
        int i = 0;
        while (i < this.waves.size()) {
            Wave wave = this.waves.get(i);
            if (this.waveOverEnemy(wave)) {
                double hitAngle = this.heading(wave.startX, wave.startY, this.enemy.x, this.enemy.y);
                double offsetAngle = Utils.normalRelativeAngleDegrees((double)(hitAngle - wave.startEnemyBearing));
                double guessFactor = this.limit(-1.0, wave.startEnemyDirection * offsetAngle / wave.maxEscapeAngle, 1.0);
                int hitGuessFactorIndex = this.getFireSector(guessFactor);
                int hitDistanceSector = this.getDistanceSector(wave.startEnemyDistance);
                this.out.println("---- Wave hit -----");
                this.out.println("hitDistanceSector : " + hitDistanceSector);
                this.out.println("hitGuessFactorIndex : " + hitGuessFactorIndex);
                this.out.println("-------------------");
                int[] nArray = this.enemyHitProfile[hitDistanceSector];
                int n = hitGuessFactorIndex;
                nArray[n] = nArray[n] + 1;
                this.displayHitProfile();
                this.waves.remove(i);
            }
            ++i;
        }
    }

    private void displayHitProfile() {
        this.out.print("    ");
        int i = 0;
        while (i < 17) {
            this.out.print(String.valueOf(i % 10) + " ");
            ++i;
        }
        this.out.println();
        int distanceIndex = 0;
        while (distanceIndex < 5) {
            int[] distancedEnemyHitProfile = this.enemyHitProfile[distanceIndex];
            this.out.print(String.valueOf(distanceIndex) + " : ");
            int[] nArray = distancedEnemyHitProfile;
            int n = distancedEnemyHitProfile.length;
            int n2 = 0;
            while (n2 < n) {
                int i2 = nArray[n2];
                this.out.print(String.valueOf(i2) + " ");
                ++n2;
            }
            this.out.println();
            ++distanceIndex;
        }
    }

    private int getFireSector(double guessFactor) {
        return 8 + this.round(guessFactor * 8.0);
    }

    private boolean waveOverEnemy(Wave wave) {
        return wave.getTravelledDistance(this.time) >= this.enemy.distance;
    }

    private void radar() {
        if (this.fullScanNeeded()) {
            this.fullScan();
        } else {
            this.lockRadar();
        }
    }

    private boolean fullScanNeeded() {
        if (this.enemy == null) {
            return true;
        }
        return this.time - this.enemy.timeScanned > 3L;
    }

    private void fullScan() {
        if (this.abs(this.radarTurnRemaining) < 45.0) {
            double angleToCenter = this.heading(this.x, this.y, this.fieldWidth / 2.0, this.fieldHeight / 2.0);
            double orientation = this.signum(Utils.normalRelativeAngleDegrees((double)(angleToCenter - this.gunHeading)));
            double fullTurn = orientation * 360.0;
            this.setTurnRight(fullTurn);
            this.setTurnGunRight(fullTurn);
            this.setTurnRadarRight(fullTurn);
        }
    }

    private void lockRadar() {
        double radarOffset = Utils.normalRelativeAngleDegrees((double)(this.enemy.absoluteBearing - this.radarHeading));
        double additionalTurn = this.signum(radarOffset) * this.min(this.atan(26.0 / this.enemy.distance), 45.0);
        double radarTurn = radarOffset + additionalTurn;
        this.setTurnRadarRight(radarTurn);
    }

    private void move() {
        if (this.enemy != null) {
            this.adjustedPerpendicularHeading();
        }
        this.gear();
    }

    private void adjustedPerpendicularHeading() {
        int side = this.enemy.relativeBearing > 0.0 ? 1 : -1;
        double distanceAdjustmentFactor = this.getDistanceAdjustmentFactor();
        double adjustedPerpendicularAngle = distanceAdjustmentFactor * 90.0;
        double adjustedPerpendicularHeading = Utils.normalAbsoluteAngleDegrees((double)(this.enemy.absoluteBearing - (double)side * adjustedPerpendicularAngle));
        double headingOffset = Utils.normalRelativeAngleDegrees((double)(adjustedPerpendicularHeading - this.heading));
        this.setTurnRight(headingOffset);
    }

    private double getDistanceAdjustmentFactor() {
        double rawDistanceAdjustmentFactor = 1.0 + 20.0 * ((double)this.gear * (200.0 - this.enemy.distance)) / 200.0;
        return this.limit(0.25, rawDistanceAdjustmentFactor, 1.75);
    }

    private void gear() {
        if (this.reverseNeeded()) {
            this.gear = -this.gear;
            double distance = (0.5 + this.random()) * 250.0;
            if (this.gear > 0) {
                this.setAhead(distance);
            } else {
                this.setBack(distance);
            }
        }
    }

    private boolean reverseNeeded() {
        return this.distanceRemaining == 0.0 || this.tooCloseFromWall();
    }

    private boolean tooCloseFromWall() {
        double trueHeading = this.gear > 0 ? this.heading : this.heading + 180.0;
        double projectedX = this.x + 100.0 * this.sin(trueHeading);
        double projectedY = this.y + 100.0 * this.cos(trueHeading);
        return projectedX < 18.0 || projectedX > this.fieldWidth - 18.0 || projectedY < 18.0 || projectedY > this.fieldHeight - 18.0;
    }

    private void aim() {
        if (this.enemy != null && this.lastEnemy != null && this.enemy.timeScanned > this.time - 3L) {
            double firePower = this.selectFirePower();
            double fireAngle = this.selectFireAngle(firePower);
            double gunTurn = Utils.normalRelativeAngleDegrees((double)(fireAngle - this.gunHeading));
            this.setTurnGunRight(gunTurn);
            if (this.fireAllowed(gunTurn)) {
                this.fireWaveBullet(firePower);
            }
        }
    }

    private double selectFirePower() {
        double firePower = 0.0;
        if (this.energy > 0.1) {
            firePower = this.enemy.energy <= 4.0 ? this.enemy.energy / 4.0 : (this.enemy.energy <= 16.0 ? (this.enemy.energy + 2.0) / 6.0 : 3.0 * (300.0 / this.enemy.distance));
            firePower = this.min(firePower, (this.energy - 0.1) / 8.0);
            firePower = this.limit(0.1, firePower, 3.0);
        }
        return firePower;
    }

    private double selectFireAngle(double firePower) {
        double fireAngle;
        if (this.useGuessFactorTargeting()) {
            this.displayUsedData();
            fireAngle = this.bestGuessFactorAngle(firePower);
        } else {
            this.out.println("Using circular accelerated targeting");
            fireAngle = this.circularAcceleratedAngle(firePower);
        }
        return fireAngle;
    }

    private boolean useGuessFactorTargeting() {
        return this.hasHitData() && this.enemy.velocity != 0.0;
    }

    private boolean hasHitData() {
        int index = 0;
        while (index < this.currentEnemyHitProfile.length) {
            if (this.currentEnemyHitProfile[index] > 0) {
                return true;
            }
            ++index;
        }
        return false;
    }

    private double bestGuessFactorAngle(double firePower) {
        int bestIndex = this.getBestGuessFactorIndex(this.currentEnemyDistanceSector);
        double bestGuessFactor = (double)(bestIndex - 8) / 8.0;
        double angleOffset = this.getEnemyDirection() * bestGuessFactor * this.getMaxEscapeAngle(firePower);
        return Utils.normalRelativeAngleDegrees((double)(this.enemy.absoluteBearing + angleOffset));
    }

    private void displayUsedData() {
        this.out.println("--- Used Fire data ---");
        this.out.println("currentEnemyDistanceSector : " + this.currentEnemyDistanceSector);
        int[] nArray = this.currentEnemyHitProfile;
        int n = this.currentEnemyHitProfile.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            this.out.print(String.valueOf(i) + " ");
            ++n2;
        }
        this.out.println();
        this.out.println("-------");
    }

    private int getBestGuessFactorIndex(int distanceIndex) {
        int bestIndex = 0;
        int index = 0;
        while (index < this.currentEnemyHitProfile.length) {
            if (this.currentEnemyHitProfile[index] > this.currentEnemyHitProfile[bestIndex]) {
                bestIndex = index;
            }
            ++index;
        }
        return bestIndex;
    }

    private double circularAcceleratedAngle(double firePower) {
        double bulletVelocity = Rules.getBulletSpeed((double)firePower);
        double enemyX = this.enemy.x;
        double enemyY = this.enemy.y;
        double enemyHeading = this.enemy.heading;
        double enemyTurnRate = this.enemy.turnRate;
        double enemyVelocity = this.enemy.velocity;
        double enemyAcceleration = this.enemy.acceleration;
        int t = 0;
        do {
            enemyHeading = Utils.normalRelativeAngleDegrees((double)(enemyHeading + enemyTurnRate));
        } while ((double)(++t) * bulletVelocity < this.distance(this.x, this.y, enemyX = this.limit(18.0, enemyX + (enemyVelocity = this.min(8.0, enemyVelocity + enemyAcceleration)) * this.sin(enemyHeading), this.fieldWidth - 18.0), enemyY = this.limit(18.0, enemyY + enemyVelocity * this.cos(enemyHeading), this.fieldHeight - 18.0)));
        double fireAngle = this.heading(this.x, this.y, enemyX, enemyY);
        return Utils.normalAbsoluteAngleDegrees((double)fireAngle);
    }

    private boolean gunIsAdjusted(double gunTurn) {
        return gunTurn < 10.0;
    }

    private boolean fireAllowed(double gunTurn) {
        return this.gunIsAdjusted(gunTurn) && this.gunHeat == 0.0 && this.energy > 0.1;
    }

    private void fireWaveBullet(double firePower) {
        this.addWave(firePower);
        this.setFire(firePower);
    }

    private void addWave(double firePower) {
        Wave wave = new Wave();
        wave.startX = this.x;
        wave.startY = this.y;
        wave.startTime = this.time;
        wave.startEnemyDirection = this.getEnemyDirection();
        wave.startEnemyBearing = this.enemy.absoluteBearing;
        wave.startEnemyDistance = this.enemy.distance;
        wave.velocity = Rules.getBulletSpeed((double)firePower);
        wave.maxEscapeAngle = this.getMaxEscapeAngle(firePower);
        this.waves.add(wave);
    }

    private double getMaxEscapeAngle(double firePower) {
        return this.asin(8.0 / Rules.getBulletSpeed((double)firePower));
    }

    private double getEnemyDirection() {
        return this.signum(this.sin(this.enemy.heading - this.enemy.absoluteBearing));
    }

    private int getDistanceSector(double distance) {
        return (int)this.limit(0.0, (int)(distance / 240.0), 4.0);
    }
}

