/*
 * Decompiled with CFR 0.152.
 */
package muf.utils;

public class SimpleBuffer {
    protected Object[] data;
    protected int lastIndex;
    protected int currentIndex;
    protected boolean hasPrev;

    public SimpleBuffer(int n) {
        this.setSize(n);
    }

    public void setSize(int n) {
        this.lastIndex = -1;
        this.currentIndex = -1;
        this.hasPrev = false;
        this.data = new Object[n];
    }

    public void add(Object object) {
        this.lastIndex = (this.lastIndex + 1) % this.data.length;
        this.data[this.lastIndex] = object;
    }

    public void reset() {
        this.currentIndex = this.lastIndex;
        this.hasPrev = this.currentIndex != -1;
    }

    public Object getPrevObject() {
        int n = this.currentIndex;
        this.currentIndex = (this.currentIndex - 1 + this.data.length) % this.data.length;
        this.hasPrev = this.data[this.currentIndex] != null && this.currentIndex != this.lastIndex;
        return this.data[n];
    }

    public boolean hasPrev() {
        return this.hasPrev;
    }

    public void delAll() {
        this.setSize(this.data.length);
    }
}

