/*
 * Decompiled with CFR 0.152.
 */
package steff;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RoundEndedEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import steff.Config;
import steff.guns.Gun;
import steff.guns.HeadOnGun;
import steff.guns.LinearTargetingGun;
import steff.guns.VirtualBullet;

public class Rebel
extends AdvancedRobot {
    private double nextInvertDelay = 0.0;
    private static Gun activeGun;
    int direction = 1;
    int directionInvertDelay = 0;
    long lastScanDelay = 0L;
    private int bulletHitBullet = 0;
    private long fireTime = 0L;
    private double bulletPower = 3.0;
    private ScannedRobotEvent target;
    private boolean bulletShieldDetected;
    private static List<Gun> guns;
    private Collection<VirtualBullet> virtualBullets = new ArrayList<VirtualBullet>();
    private double enemyX;
    private double enemyY;
    private Rectangle2D.Double battleField;
    private long lastBulletMoveTime;
    boolean slowDown = false;
    private double enemyEnergy;

    static {
        guns = new ArrayList<Gun>();
    }

    public void run() {
        this.battleField = new Rectangle2D.Double(0.0, 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
        this.setTurnRadarRight(Double.POSITIVE_INFINITY);
        this.setColors(Config.BODY_COLOR, Config.GUN_COLOR, Config.RADAR_COLOR);
        this.setBulletColor(Config.BULLET_COLOR);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.createGuns();
        while (true) {
            this.process();
        }
    }

    private void createGuns() {
        if (guns.size() == 0) {
            guns.add(new LinearTargetingGun(this, 1.0));
            guns.add(new LinearTargetingGun(this, 0.75));
            guns.add(new LinearTargetingGun(this, 0.5));
            guns.add(new LinearTargetingGun(this, 0.25));
            guns.add(new LinearTargetingGun(this, -0.25));
            guns.add(new LinearTargetingGun(this, -0.5));
            guns.add(new HeadOnGun(this));
            activeGun = guns.get(0);
        }
    }

    private void process() {
        this.scan();
        this.drive();
        this.calculateVirtualBulletMoves();
        this.detectBulletShield();
        ++this.directionInvertDelay;
        ++this.lastScanDelay;
        if (this.lastScanDelay > 10L) {
            this.setTurnRadarRight(Double.POSITIVE_INFINITY);
        }
        this.execute();
    }

    private void calculateVirtualBulletMoves() {
        Iterator<VirtualBullet> iterator = this.virtualBullets.iterator();
        while (iterator.hasNext()) {
            VirtualBullet virtualBullet = iterator.next();
            virtualBullet.move(this.getTime() - this.lastBulletMoveTime);
            if (virtualBullet.collides(this.enemyX, this.enemyY)) {
                virtualBullet.getGun().incScore();
                iterator.remove();
                continue;
            }
            if (this.battleField.contains(virtualBullet.getX(), virtualBullet.getY())) continue;
            iterator.remove();
        }
        this.lastBulletMoveTime = this.getTime();
    }

    private void drive() {
        this.setAhead(500 * this.direction);
        this.invertDirection();
        this.driveAroundEnemy();
    }

    private void detectBulletShield() {
        this.bulletShieldDetected = this.bulletHitBullet > 3;
    }

    private void driveAroundEnemy() {
        boolean inCorner = this.inCorner();
        boolean nearWall = this.nearWall();
        if (this.target != null) {
            double factor = 1.0;
            if (this.target.getDistance() < 200.0) {
                factor = 1.2;
                if (inCorner || nearWall) {
                    factor = 0.6;
                }
            } else if (this.target.getDistance() > 350.0) {
                factor = 0.8;
            }
            if (this.getVelocity() < 0.0) {
                factor = 1.0 / factor;
            }
            if (this.target.getBearing() < 0.0) {
                double turnAmount = this.target.getBearing() + 90.0 * factor;
                this.setTurnRight(turnAmount);
            } else {
                double turnAmount = this.target.getBearing() - 90.0 * factor;
                this.setTurnRight(turnAmount);
            }
        }
    }

    private boolean inCorner() {
        boolean inCorner = false;
        double x = this.getX();
        double y = this.getY();
        inCorner = inCorner || x < 150.0 && y < 150.0;
        inCorner = inCorner || x < 150.0 && y > this.getBattleFieldHeight() - 150.0;
        inCorner = inCorner || x > this.getBattleFieldWidth() - 150.0 && y < 150.0;
        inCorner = inCorner || x > this.getBattleFieldWidth() - 150.0 && y < this.getBattleFieldHeight() - 150.0;
        return inCorner;
    }

    private void invertDirection() {
        boolean invertDueToTime;
        boolean nearWall = this.nearWall();
        boolean invertDueToWall = nearWall && this.directionInvertDelay > 15;
        boolean bl = invertDueToTime = (double)this.directionInvertDelay > this.nextInvertDelay;
        if (invertDueToWall || invertDueToTime) {
            this.directionInvertDelay = 0;
            this.direction *= -1;
            this.nextInvertDelay = Config.RANDOM_VALUE.INVERT_DIRECTION_DELAY.value();
        }
    }

    private boolean nearWall() {
        boolean xWall = this.getX() < 100.0 || this.getX() > this.getBattleFieldWidth() - 100.0;
        boolean yWall = this.getY() < 100.0 || this.getY() > this.getBattleFieldHeight() - 100.0;
        boolean nearWall = xWall || yWall;
        return nearWall;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.target = e;
        this.lastScanDelay = 0L;
        double myX = this.getX();
        double myY = this.getY();
        double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        this.enemyX = myX + e.getDistance() * Math.sin(absoluteBearing);
        this.enemyY = myY + e.getDistance() * Math.cos(absoluteBearing);
        this.adjustFirePower();
        this.aimRadar(e);
        this.gun(e);
        double energyDrop = this.enemyEnergy - e.getEnergy();
        if (energyDrop >= 0.1 && energyDrop <= 3.0) {
            this.directionInvertDelay += 5;
        }
        this.enemyEnergy = e.getEnergy();
        this.fireTime = this.getTime() + 1L;
    }

    private void gun(ScannedRobotEvent e) {
        this.selectGun();
        this.fireGun();
        this.aimGun(e);
    }

    private void selectGun() {
        Gun bestGun = activeGun;
        for (Gun gun : guns) {
            if (gun.getScore() <= bestGun.getScore()) continue;
            bestGun = gun;
        }
        activeGun = bestGun;
    }

    private void adjustFirePower() {
        if (this.bulletShieldDetected) {
            this.bulletPower = 0.1;
        } else {
            this.bulletPower = 2.0;
            if (this.target.getDistance() < 150.0) {
                this.bulletPower = 3.0;
            }
        }
        this.bulletPower = Math.min(this.bulletPower, this.getEnergy() - 0.1);
    }

    private void fireGun() {
        Bullet setFireBullet;
        if (this.fireTime == this.getTime() && Math.abs(this.getGunTurnRemaining()) == 0.0 && (setFireBullet = this.setFireBullet(this.bulletPower)) != null) {
            this.fireVirtualBullets();
        }
    }

    private void fireVirtualBullets() {
        if (this.virtualBullets.size() == 0) {
            for (Gun gun : guns) {
                double gunAngle = gun.target(this.target, this.bulletPower);
                double angle = Utils.normalAbsoluteAngle((double)(this.getGunHeadingRadians() + gunAngle));
                this.virtualBullets.add(new VirtualBullet(gun, this.getX(), this.getY(), angle, this.bulletPower, this.target));
            }
        }
    }

    private void aimGun(ScannedRobotEvent e) {
        double angle = activeGun.target(e, this.bulletPower);
        this.setTurnGunRightRadians(angle);
    }

    private void aimRadar(ScannedRobotEvent e) {
        double radarTurn = this.getHeadingRadians() + e.getBearingRadians() - this.getRadarHeadingRadians();
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)radarTurn));
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        ++this.bulletHitBullet;
    }

    public void onBulletHit(BulletHitEvent event) {
        this.bulletHitBullet = 0;
    }

    public void onHitByBullet(HitByBulletEvent event) {
        this.bulletHitBullet = 0;
    }

    public void onHitRobot(HitRobotEvent event) {
        this.virtualBullets.clear();
    }

    public void onBattleEnded(BattleEndedEvent event) {
    }

    public void onRoundEnded(RoundEndedEvent event) {
    }
}

