/*
 * Decompiled with CFR 0.152.
 */
package steff.guns;

import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import steff.guns.Gun;

public class LinearTargetingGun
extends Gun {
    private double predictionFactor;

    public LinearTargetingGun(AdvancedRobot robot, double predictionFactor) {
        super("LinearTargetingGun (" + predictionFactor + ")", robot);
        this.predictionFactor = predictionFactor;
    }

    @Override
    public double target(ScannedRobotEvent e, double bulletPower) {
        double myX = this.robot.getX();
        double myY = this.robot.getY();
        double absoluteBearing = this.robot.getHeadingRadians() + e.getBearingRadians();
        double enemyX = myX + e.getDistance() * Math.sin(absoluteBearing);
        double enemyY = myY + e.getDistance() * Math.cos(absoluteBearing);
        double enemyHeading = e.getHeadingRadians();
        double enemyVelocity = e.getVelocity();
        double deltaTime = 0.0;
        double battleFieldHeight = this.robot.getBattleFieldHeight();
        double battleFieldWidth = this.robot.getBattleFieldWidth();
        double predictedX = enemyX;
        double predictedY = enemyY;
        double bulletSpeed = Rules.getBulletSpeed((double)bulletPower);
        boolean bulledDistanceEnough = false;
        while (!bulledDistanceEnough) {
            double distanceMyBulletTravels = (deltaTime += 1.0) * bulletSpeed;
            double distanceToEnemy = Point2D.Double.distance(myX, myY, predictedX, predictedY);
            bulledDistanceEnough = distanceMyBulletTravels > distanceToEnemy;
            predictedY += Math.cos(enemyHeading) * enemyVelocity * this.predictionFactor;
            if (!((predictedX += Math.sin(enemyHeading) * enemyVelocity * this.predictionFactor) < 18.0 || predictedY < 18.0 || predictedX > battleFieldWidth - 18.0) && !(predictedY > battleFieldHeight - 18.0)) continue;
            predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);
            predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
            break;
        }
        double theta = Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - myX, predictedY - myY));
        double normalRelativeAngle = Utils.normalRelativeAngle((double)(theta - this.robot.getGunHeadingRadians()));
        return normalRelativeAngle;
    }
}

