/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.util.AngularDir;

public class Compass {
    public static final Compass NORTH = new Compass(0.0);
    public static final Compass SOUTH = new Compass(180.0);
    public static final Compass EAST = new Compass(90.0);
    public static final Compass WEST = new Compass(270.0);
    public static final Compass NORTHEAST = new Compass(45.0);
    public static final Compass SOUTHEAST = new Compass(135.0);
    public static final Compass NORTHWEST = new Compass(315.0);
    public static final Compass SOUTHWEST = new Compass(225.0);
    private double degrees;

    public Compass(double degrees) {
        this.degrees = degrees % 360.0;
        if (this.degrees < 0.0) {
            this.degrees += 360.0;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof Compass) {
            Compass other = (Compass)o;
            return (int)other.degrees == (int)this.degrees;
        }
        return false;
    }

    public double getDegrees() {
        return this.degrees;
    }

    public double getRadians() {
        return Math.toRadians(this.degrees);
    }

    public double bearingTo(Compass other) {
        Compass relativeHeading = new Compass(other.getDegrees() - this.toBearing());
        return relativeHeading.toBearing();
    }

    public double toBearing() {
        if (this.degrees > 180.0) {
            return this.degrees - 360.0;
        }
        return this.degrees;
    }

    public AngularDir fastestTurnTo(Compass target) {
        Object fastestDir = null;
        if (this.bearingTo(target) > 0.0) {
            return AngularDir.CLOCKWISE;
        }
        return AngularDir.ANTICLOCKWISE;
    }

    public Compass add(double angle) {
        return new Compass(this.degrees + angle);
    }

    public String toString() {
        return "" + (int)this.degrees + " deg";
    }
}

