/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.util.Coord;
import agd.util.Enemy;
import agd.util.RobotSighting;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class Region
implements Comparable {
    Coord bottomleft = null;
    Coord topright = null;
    Coord hideout = null;
    int count = 0;

    public static Region[] getQuadrants(double battleFieldWidth, double battleFieldHeight, double hideoutIndent) {
        double qwidth = battleFieldWidth / 2.0;
        double qheight = battleFieldHeight / 2.0;
        Coord midpoint = new Coord(qwidth, qheight);
        Region[] quadrants = new Region[]{new Region(Coord.ORIGIN, midpoint, new Coord(hideoutIndent, hideoutIndent)), new Region(new Coord(midpoint.getX(), 0.0), new Coord(battleFieldWidth, midpoint.getY()), new Coord(battleFieldWidth - hideoutIndent, hideoutIndent)), new Region(new Coord(0.0, battleFieldHeight / 2.0), new Coord(battleFieldWidth / 2.0, battleFieldHeight), new Coord(hideoutIndent, battleFieldHeight - hideoutIndent)), new Region(midpoint, new Coord(battleFieldWidth, battleFieldHeight), new Coord(battleFieldWidth - hideoutIndent, battleFieldHeight - hideoutIndent))};
        return quadrants;
    }

    public static Region[] getEdgeRegions(double battleFieldWidth, double battleFieldHeight, double hideoutIndent) {
        double w13 = battleFieldWidth / 3.0;
        double w23 = 2.0 * w13;
        double h13 = battleFieldWidth / 3.0;
        double h23 = 2.0 * h13;
        double halfw = battleFieldWidth / 2.0;
        double halfh = battleFieldHeight / 2.0;
        Region[] regions = new Region[]{new Region(Coord.ORIGIN, new Coord(w13, h13), new Coord(hideoutIndent, hideoutIndent)), new Region(new Coord(w13, 0.0), new Coord(w23, h13), new Coord(halfw, hideoutIndent)), new Region(new Coord(w23, 0.0), new Coord(battleFieldWidth, h13), new Coord(battleFieldWidth - hideoutIndent, hideoutIndent)), new Region(new Coord(0.0, h13), new Coord(w13, h23), new Coord(hideoutIndent, halfh)), new Region(new Coord(w23, h13), new Coord(battleFieldWidth, h23), new Coord(battleFieldWidth - hideoutIndent, halfh)), new Region(new Coord(0.0, h23), new Coord(w13, h23), new Coord(hideoutIndent, battleFieldHeight - hideoutIndent)), new Region(new Coord(w13, h23), new Coord(w23, battleFieldHeight), new Coord(halfw, battleFieldHeight - hideoutIndent)), new Region(new Coord(w23, h23), new Coord(battleFieldWidth, battleFieldHeight), new Coord(battleFieldWidth - hideoutIndent, battleFieldHeight - hideoutIndent))};
        return regions;
    }

    public static Region getPreferredRegion(Region[] regions, Collection enemies) {
        Iterator it = enemies.iterator();
        int idx = 0;
        while (idx < 4) {
            regions[idx].resetCount();
            ++idx;
        }
        block1: while (it.hasNext()) {
            Enemy enemy = (Enemy)it.next();
            RobotSighting sight = enemy.getLastSighting();
            if (sight == null) continue;
            int q = 0;
            while (q < 4) {
                if (regions[q].contains(sight.getTheirPosition())) {
                    ++regions[q].count;
                    continue block1;
                }
                ++q;
            }
        }
        Arrays.sort(regions);
        return regions[0];
    }

    public static Region whichRegionContains(Region[] regions, Coord point) {
        Region found = null;
        int i = 0;
        while (found == null && i < regions.length) {
            if (regions[i].contains(point)) {
                found = regions[i];
            }
            ++i;
        }
        return found;
    }

    public Region(Coord bottomleft, Coord topright) {
        this.bottomleft = bottomleft;
        this.topright = topright;
        double width = topright.getX() - bottomleft.getX();
        double height = topright.getY() - bottomleft.getY();
        this.hideout = new Coord(bottomleft.getX() + width / 2.0, bottomleft.getY() + height / 2.0);
    }

    public Region(Coord bottomleft, Coord topright, Coord hideout) {
        this(bottomleft, topright);
        this.hideout = hideout;
    }

    public void resetCount() {
        this.count = 0;
    }

    public int getCount() {
        return this.count;
    }

    public Coord getHideout() {
        return this.hideout;
    }

    boolean contains(Coord point) {
        return point.getX() >= this.bottomleft.getX() && point.getY() >= this.bottomleft.getY() && point.getX() <= this.topright.getX() && point.getY() <= this.topright.getY();
    }

    public int compareTo(Object o) {
        return this.count - ((Region)o).count;
    }

    public String toString() {
        return "Region {" + this.bottomleft + " - " + this.topright + "}";
    }
}

