/*
 * Decompiled with CFR 0.152.
 */
package catcat20.core.radar;

import catcat20.core.bot.Bot;
import catcat20.core.bot.BotState;
import catcat20.core.utils.LConstants;
import catcat20.core.utils.LUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import robocode.util.Utils;

public class Radar {
    public static HashMap<String, Bot> enemies;
    public static ArrayList<Bot> enemyList;
    public static ArrayList<Bot> aliveEnemyList;
    public static ArrayList<Double> enDistanceSqList;
    public static ArrayList<BotState> myStates;
    public static BotState myState;
    public static String myName;
    public static Bot nearestBot;
    public static double nearestDist;
    public double avgEnemyEnergy = 100.0;
    public TeamRobot _robot;
    public static double totalStrengthValue;
    static LinkedHashMap<String, Double> enemyHashMap;
    public static double scanDir;
    public static double scanAbsAngle;
    public static double scanMEA;
    static Object sought;
    public static double surfNearestEnDist;
    private static double firePower;

    public Radar(TeamRobot _robot) {
        this._robot = _robot;
        if (enemies == null) {
            enemies = new HashMap();
            enemyList = new ArrayList();
            aliveEnemyList = new ArrayList();
            enDistanceSqList = new ArrayList();
        }
    }

    public void init() {
        nearestDist = Double.POSITIVE_INFINITY;
        nearestBot = null;
        enDistanceSqList.clear();
        myStates = new ArrayList();
        myState = new BotState();
        myName = this._robot.getName();
        scanDir = 1.0;
        scanAbsAngle = Double.NaN;
        enemyHashMap = new LinkedHashMap(5, 2.0f, true);
        for (Bot bot : enemyList) {
            bot.states.clear();
            bot.shotDataMaps = new ArrayList();
            bot.lastScanTime = -1L;
            bot.isAlive = false;
            bot.currentState = null;
            bot.lastPIFData = null;
            bot.gunHeat = 26.0 * LConstants.GUN_COOLING_RATE;
        }
        aliveEnemyList.clear();
        aliveEnemyList.addAll(enemyList);
    }

    public static Bot getBot(String name) {
        return enemies.get(name);
    }

    public static int botsCloser(double distanceSq) {
        surfNearestEnDist = Double.POSITIVE_INFINITY;
        int botsCloser = 0;
        for (double botDistanceSq : enDistanceSqList) {
            if (botDistanceSq < distanceSq) {
                ++botsCloser;
            }
            if (!(surfNearestEnDist > botDistanceSq)) continue;
            surfNearestEnDist = botDistanceSq;
        }
        return botsCloser;
    }

    public void onTick() {
        Point2D.Double myPos = new Point2D.Double(this._robot.getX(), this._robot.getY());
        myState = new BotState();
        Radar.myState.name = this._robot.getName();
        Radar.myState.time = this._robot.getTime();
        Radar.myState.x = this._robot.getX();
        Radar.myState.y = this._robot.getY();
        Radar.myState.energy = this._robot.getEnergy();
        Radar.myState.velocity = this._robot.getVelocity();
        Radar.myState.heading = this._robot.getHeadingRadians();
        if (myStates.size() > 2) {
            BotState last8 = myStates.get(LUtils.limit(0, myStates.size() - 1, 8));
            Radar.myState.dist8 = myState.distance(last8.x, last8.y);
            BotState last20 = myStates.get(LUtils.limit(0, myStates.size() - 1, 20));
            Radar.myState.dist20 = myState.distance(last20.x, last20.y);
        }
        myStates.add(0, myState);
        Graphics2D g = this._robot.getGraphics();
        Color transRed = new Color(1.0f, 0.25f, 0.0f, 0.125f);
        Color transYellow = new Color(1.0f, 1.0f, 0.0f, 0.1f);
        this.avgEnemyEnergy = 0.0;
        totalStrengthValue = 0.0;
        long time = this._robot.getTime();
        int others = this._robot.getOthers();
        nearestDist = Double.POSITIVE_INFINITY;
        for (int i = 0; i < aliveEnemyList.size(); ++i) {
            Bot bot = aliveEnemyList.get(i);
            if (!bot.isAlive) continue;
            totalStrengthValue += bot.getStrongScore();
            bot.updateState(time, others);
            if (bot.currentState == null) continue;
            this.avgEnemyEnergy += bot.currentState.energy;
            double dist = myPos.distance(bot.currentState.x, bot.currentState.y);
            enDistanceSqList.add(dist * dist);
            if (dist < nearestDist) {
                nearestBot = bot;
                nearestDist = dist;
            }
            g.setColor(Color.white);
            g.drawString("" + bot.gunHeat, (int)bot.currentState.x - 50, (int)(bot.currentState.y - 50.0));
        }
        this.avgEnemyEnergy /= (double)others;
        for (Bot bot : aliveEnemyList) {
            if (!bot.isAlive) continue;
            bot.updateOtherInfo(myName, myState);
            if (bot.nearestBotName.equals(myName)) {
                g.setColor(transRed);
            } else {
                g.setColor(transYellow);
            }
            g.fillOval((int)(bot.currentState.x - bot.nearestBotDist), (int)(bot.currentState.y - bot.nearestBotDist), (int)bot.nearestBotDist * 2, (int)bot.nearestBotDist * 2);
        }
        if (this._robot.getRadarTurnRemaining() == 0.0) {
            this._robot.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
        if (others > 1) {
            this._robot.setTurnRadarRightRadians(scanDir * Double.POSITIVE_INFINITY);
        } else if (nearestBot != null && Radar.nearestBot.isAlive) {
            double angleToEnemy = LUtils.absoluteBearing(myPos.x, myPos.y, Radar.nearestBot.currentState.x, Radar.nearestBot.currentState.y);
            double radarTurn = Utils.normalRelativeAngle((double)(angleToEnemy - this._robot.getRadarHeadingRadians()));
            double extraTurn = Math.min(Math.atan(36.0 / myPos.distance(Radar.nearestBot.currentState.x, Radar.nearestBot.currentState.y)), Rules.RADAR_TURN_RATE_RADIANS);
            radarTurn = radarTurn < 0.0 ? (radarTurn -= extraTurn) : (radarTurn += extraTurn);
            this._robot.setTurnRadarRightRadians(radarTurn);
        } else {
            this._robot.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
        this.updateFirePower();
    }

    public void updateFirePower() {
        firePower = 0.1;
        int others = this._robot.getOthers();
        if (others <= 1) {
            firePower = 1.95;
            if (nearestBot != null && Radar.nearestBot.isAlive && Radar.nearestBot.currentState != null) {
                if (this._robot.getEnergy() <= 10.0) {
                    firePower = 0.15;
                }
                if (nearestDist < 200.0) {
                    firePower = 2.95;
                } else if (nearestDist < 250.0) {
                    firePower = 2.45;
                }
                BotState state = Radar.nearestBot.currentState;
                double minimumKillPower = 0.001 + state.energy / 4.0;
                if (state.energy > 4.0) {
                    minimumKillPower = 0.001 + (state.energy + 2.0) / 6.0;
                }
                firePower = Math.min(minimumKillPower, firePower);
                firePower = Math.min(firePower, this._robot.getEnergy() - 0.11);
            }
        } else if (nearestBot != null && Radar.nearestBot.isAlive && Radar.nearestBot.currentState != null) {
            double myEnergy = this._robot.getEnergy();
            double bulletPower = 2.999;
            int enemiesAlive = this._robot.getOthers();
            if (enemiesAlive <= 3) {
                bulletPower = 1.999;
            }
            if (enemiesAlive <= 5 && nearestDist > 500.0) {
                bulletPower = 1.499;
            }
            if (myEnergy < this.avgEnemyEnergy && enemiesAlive <= 5 && nearestDist > 300.0 || nearestDist > 700.0) {
                bulletPower = 0.999;
            }
            if (myEnergy < 20.0 && myEnergy < this.avgEnemyEnergy) {
                bulletPower = Math.min(bulletPower, 2.0 - (20.0 - myEnergy) / 11.0);
            }
            if (nearestDist <= 150.0) {
                bulletPower = 2.99;
            } else if (nearestDist <= 275.0) {
                bulletPower = 2.45;
            }
            bulletPower = Math.max(bulletPower, 0.1);
            firePower = bulletPower = Math.min(bulletPower, myEnergy - 0.15);
        }
        if (LConstants.TC_MODE) {
            firePower = 3.0;
        }
    }

    public static double getFirePower() {
        return firePower;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Bot bot;
        String name = e.getName();
        if (!enemies.containsKey(name)) {
            bot = new Bot(e.getName());
            enemies.put(name, bot);
            enemyList.add(bot);
            aliveEnemyList.add(bot);
            bot.gunHeat = 28.0 * LConstants.GUN_COOLING_RATE - (double)(e.getTime() + 1L) * LConstants.GUN_COOLING_RATE;
        }
        bot = enemies.get(name);
        bot.isAlive = true;
        bot.lastScanTime = e.getTime();
        bot.onScannedRobot(this._robot, e);
        if (e.getTime() < 35L) {
            bot.gunHeat = this._robot.getGunHeat() - LConstants.GUN_COOLING_RATE;
        }
        LinkedHashMap<String, Double> ehm = enemyHashMap;
        ehm.put(name, this._robot.getHeadingRadians() + e.getBearingRadians());
        if ((name == sought || sought == null) && ehm.size() == this._robot.getOthers()) {
            double ang = 0.0;
            ang = ehm.values().iterator().next() - this._robot.getRadarHeadingRadians();
            scanDir = Utils.normalRelativeAngle((double)ang);
            scanAbsAngle = ang;
            if (enemies.containsKey((String)sought)) {
                Bot target = enemies.get((String)sought);
                if (target.currentState != null && target.isAlive) {
                    scanMEA = Math.atan(36.0 / target.currentState.distance(Radar.myState.x, Radar.myState.y));
                }
            }
            sought = ehm.keySet().iterator().next();
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        Bot bot = Radar.getBot(e.getName());
        if (bot != null) {
            bot.myHitRateScore += 1.0;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Bot bot = Radar.getBot(e.getName());
        if (bot != null) {
            bot.youHitRateScore += Rules.getBulletDamage((double)e.getBullet().getPower());
            bot.lastHitTime = e.getTime();
        }
    }

    public void onDeath(DeathEvent e) {
        for (Bot bot : aliveEnemyList) {
            if (!bot.isAlive) continue;
            bot.aliveScore += 1.0;
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        enemyHashMap.remove(e.getName());
        sought = null;
        Bot bot = Radar.getBot(e.getName());
        if (bot != null) {
            bot.isAlive = false;
        }
        for (Bot aBot : aliveEnemyList) {
            if (!aBot.isAlive) continue;
            aBot.aliveScore += 1.0;
        }
        aliveEnemyList.remove(bot);
    }

    static {
        totalStrengthValue = 0.0;
        scanDir = 1.0;
        scanAbsAngle = Double.NaN;
        scanMEA = Double.NaN;
        firePower = 0.1;
    }
}

