/*
 * Decompiled with CFR 0.152.
 */
package gf.Centaur.utils;

import gf.Centaur.utils.VirtualRobot;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;

public class ExecutingRobot {
    private String name;
    private Point2D.Double position;
    private long time;
    private double heading;
    private double headingRadians;
    private double energy;
    private double velocity;
    private double battleFieldWidth;
    private double battleFieldHeight;

    public ExecutingRobot(VirtualRobot robot, long time, double width, double height) {
        this.name = robot.getName();
        this.time = time;
        this.heading = robot.getHeading();
        this.headingRadians = robot.getHeadingRadians();
        this.energy = robot.getEnergy();
        this.velocity = robot.getVelocity();
        this.position = robot.getPosition();
        this.battleFieldWidth = width;
        this.battleFieldHeight = height;
    }

    public ExecutingRobot(AdvancedRobot robot) {
        this.name = robot.getName();
        this.time = robot.getTime();
        this.heading = robot.getHeading();
        this.headingRadians = robot.getHeadingRadians();
        this.energy = robot.getEnergy();
        this.velocity = robot.getVelocity();
        this.position = new Point2D.Double(robot.getX(), robot.getY());
        this.battleFieldWidth = robot.getBattleFieldWidth();
        this.battleFieldHeight = robot.getBattleFieldHeight();
    }

    public Point2D.Double getPosition() {
        return this.position;
    }

    public double getX() {
        return this.position.getX();
    }

    public double getY() {
        return this.position.getY();
    }

    public String getName() {
        return this.name;
    }

    public long getTime() {
        return this.time;
    }

    public double getHeading() {
        return this.heading;
    }

    public double getHeadingRadians() {
        return this.headingRadians;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getBattleFieldWidth() {
        return this.battleFieldWidth;
    }

    public double getBattleFieldHeight() {
        return this.battleFieldHeight;
    }
}

