/*
 * Decompiled with CFR 0.152.
 */
package reaper;

import reaper.Methods;
import reaper.Reaper;
import robocode.ScannedRobotEvent;

public class Enemy {
    private Reaper r;
    public ScannedRobotEvent e;
    private double reaperX;
    private double reaperY;
    private double reaperHeading;
    private Methods m;
    private int direction;
    private Enemy lastScan;
    private double timeScanned;

    public double getRelatiefAngle() {
        return Methods.normalizeRelatief(this.e.getBearing());
    }

    public double getAbsoluutAngle() {
        return Methods.normalizeAbsoluut(this.m.absoluutTank(this.e.getBearing()));
    }

    public double getRelatiefGunAngle() {
        return Methods.normalizeRelatief(this.m.relatiefGun(this.getAbsoluutAngle()));
    }

    public double getNewRelatiefAngle() {
        return Methods.normalizeAbsoluut(this.m.relatiefTank(this.getNewAbsoluutAngle()));
    }

    public double getNewAbsoluutAngle() {
        return Methods.normalizeAbsoluut(Methods.absoluteBearing(this.r.getX(), this.r.getY(), this.getX(), this.getY()));
    }

    public double getNewRelatiefGunAngle() {
        return Methods.normalizeRelatief(this.m.relatiefGun(this.getNewAbsoluutAngle()));
    }

    public double getNewRelatiefRadarAngle() {
        return Methods.normalizeRelatief(this.m.relatiefRadar(this.getNewAbsoluutAngle()));
    }

    public double absoluteAngle() {
        return Math.toRadians(this.reaperHeading) + this.e.getBearingRadians();
    }

    public double getDistance() {
        return this.e.getDistance();
    }

    public double getNewDistance() {
        return Methods.getDistance(this.r.getX(), this.r.getY(), this.getX(), this.getY());
    }

    public double getFutureX(double tijd) {
        double x = this.getX() + Math.sin(Math.toRadians(this.e.getHeading())) * this.e.getVelocity() * tijd;
        if (x < 0.0) {
            x = 0.0;
        } else if (x > this.r.getFieldWidth()) {
            x = this.r.getFieldWidth();
        }
        return x;
    }

    public double getFutureY(double tijd) {
        double y = this.getY() + Math.cos(Math.toRadians(this.e.getHeading())) * this.e.getVelocity() * tijd;
        if (y < 0.0) {
            y = 0.0;
        } else if (y > this.r.getFieldHeight()) {
            y = this.r.getFieldHeight();
        }
        return y;
    }

    public double getAngleDiff() {
        return Methods.normalizeRelatief(this.e.getHeading() - this.lastScan.getScan().getHeading());
    }

    public double getCircularFutureY(double tijd) {
        double radius = this.e.getVelocity() / Math.toRadians(this.getAngleDiff());
        double tothead = tijd * Math.toRadians(this.getAngleDiff());
        double y = this.getY() + Math.sin(Math.toRadians(this.e.getHeading()) + tothead) * radius - Math.sin(Math.toRadians(this.e.getHeading())) * radius;
        if (y < 0.0) {
            y = 0.0;
        } else if (y > this.r.getFieldHeight()) {
            y = this.r.getFieldHeight();
        }
        return y;
    }

    public double getCircularFutureX(double tijd) {
        double radius = this.e.getVelocity() / Math.toRadians(this.getAngleDiff());
        double tothead = tijd * Math.toRadians(this.getAngleDiff());
        double x = this.getX() + Math.cos(Math.toRadians(this.e.getHeading())) * radius - Math.cos(Math.toRadians(this.e.getHeading()) + tothead) * radius;
        if (x < 0.0) {
            x = 0.0;
        } else if (x > this.r.getFieldWidth()) {
            x = this.r.getFieldWidth();
        }
        return x;
    }

    public double getFutureHoek(double tijd) {
        return Methods.normalizeAbsoluut(Methods.absoluteBearing(this.reaperX, this.reaperY, this.getFutureX(tijd), this.getFutureY(tijd)));
    }

    public double getCircularFutureHoek(double tijd) {
        return Methods.normalizeAbsoluut(Methods.absoluteBearing(this.reaperX, this.reaperY, this.getCircularFutureX(tijd), this.getCircularFutureY(tijd)));
    }

    public double getX() {
        return this.reaperX + Math.sin(Math.toRadians(Methods.normalizeAbsoluut(Methods.normalizeRelatief(this.reaperHeading) + Methods.normalizeRelatief(this.e.getBearing())))) * this.e.getDistance();
    }

    public double getY() {
        return this.reaperY + Math.cos(Math.toRadians(Methods.normalizeAbsoluut(Methods.normalizeRelatief(this.reaperHeading) + Methods.normalizeRelatief(this.e.getBearing())))) * this.e.getDistance();
    }

    public String getName() {
        return this.e.getName();
    }

    public String getTrimmedName() {
        return this.e.getName().split("\\(")[0];
    }

    public double getEnergy() {
        return this.e.getEnergy();
    }

    public double compareEnergy() {
        return this.r.getEnergy() - this.e.getEnergy();
    }

    public double energySinceLast() {
        return this.lastScan.getEnergy() - this.e.getEnergy();
    }

    public int accelerating() {
        if (this.e.getVelocity() < this.lastScan.e.getVelocity()) {
            return -1;
        }
        if (this.e.getVelocity() > this.lastScan.e.getVelocity()) {
            return 1;
        }
        return 0;
    }

    public boolean hasShot() {
        return this.energySinceLast() <= (double)3 && this.energySinceLast() > 0.0;
    }

    public void setLastScan(Enemy lastScan) {
        this.lastScan = lastScan;
    }

    public Enemy getLastScan() {
        return this.lastScan;
    }

    public long getTime() {
        return (long)this.timeScanned;
    }

    public ScannedRobotEvent getScan() {
        return this.e;
    }

    public int direction() {
        double angle = this.getAbsoluutAngle();
        if (angle < 45.0 && angle >= 315.0) {
            return 0;
        }
        if (angle >= 45.0 && angle < 135.0) {
            return 1;
        }
        if (angle >= 135.0 && angle < 225.0) {
            return 2;
        }
        return 3;
    }

    public int getDirection() {
        return this.direction;
    }

    public Enemy(ScannedRobotEvent e, Reaper r) {
        this.r = r;
        this.e = e;
        this.reaperX = r.getX();
        this.reaperY = r.getY();
        this.reaperHeading = r.getHeading();
        this.m = r.getMethods();
        this.timeScanned = r.getTime();
        this.direction = r.getCurrentDirection();
    }
}

