/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics;

import pedersen.core.Constraints;
import pedersen.debug.Debug;
import pedersen.physics.StaticVelocity;

public class StaticVelocityImpl
implements StaticVelocity {
    private final double velocity;

    public StaticVelocityImpl(double newVelocity) {
        this.velocity = newVelocity;
    }

    public StaticVelocityImpl(StaticVelocity other) {
        this.velocity = other.getVelocity();
    }

    public double getVelocity() {
        return this.velocity;
    }

    public boolean equalsVelocity(double other) {
        return Constraints.isApproximatelyZero(this.getRelativeVelocity(other));
    }

    public boolean equalsVelocity(StaticVelocity other) {
        return this.equalsVelocity(other.getVelocity());
    }

    public double getRelativeVelocity(double other) {
        return other - this.velocity;
    }

    public double getRelativeVelocity(StaticVelocity other) {
        return this.getRelativeVelocity(other.getVelocity());
    }

    public double getCompoundVelocity(double other) {
        return this.velocity + other;
    }

    public double getCompoundVelocity(StaticVelocity other) {
        return this.getCompoundVelocity(other.getVelocity());
    }

    public void debug() {
        Debug.debug("Static velocity: " + this.velocity);
    }
}

