/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.grail;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pedersen.debug.Debug;
import pedersen.divination.WaveData;
import pedersen.tactics.grail.Segment;
import pedersen.tactics.grail.SegmentBearingOffsetImpl;
import pedersen.tactics.grail.SegmentLinearProjectionImpl;
import pedersen.tactics.grail.TargetingSuccess;
import pedersen.tactics.targeting.TargetingMethod;
import pedersen.tactics.targeting.TargetingStatistics;

public class SegmentStatisticsImpl
implements Segment {
    private final SegmentBearingOffsetImpl bearingOffsets = new SegmentBearingOffsetImpl();
    private final SegmentLinearProjectionImpl linearProjections = new SegmentLinearProjectionImpl();
    private final List targetingStatistics = new ArrayList();

    public void addWaveData(WaveData waveData) {
        Iterator iterator = waveData.getTargetingSuccessIterator();
        while (iterator.hasNext()) {
            TargetingSuccess targetingSuccess = (TargetingSuccess)iterator.next();
            this.updateTargetingStatistics(targetingSuccess.targetingMethod, targetingSuccess.success);
        }
        this.bearingOffsets.addWaveData(waveData);
        this.linearProjections.addWaveData(waveData);
    }

    private void updateTargetingStatistics(TargetingMethod targetingMethod, boolean success) {
        boolean matchFound = false;
        Iterator iterator = this.targetingStatistics.iterator();
        while (!matchFound && iterator.hasNext()) {
            TargetingStatistics stats = (TargetingStatistics)iterator.next();
            if (!stats.getTargetingMethod().equals(targetingMethod)) continue;
            stats.incrementFired();
            if (success) {
                stats.incrementHit();
            }
            matchFound = true;
        }
        if (!matchFound) {
            this.targetingStatistics.add(new TargetingStatistics(targetingMethod));
        }
    }

    public double getMostVisitedBearingOffset(WaveData waveData) {
        return this.bearingOffsets.getMostVisitedValue(waveData);
    }

    public double getLeastVisitedBearingOffset(WaveData waveData) {
        return this.bearingOffsets.getLeastVisitedValue(waveData);
    }

    public double getMostVisitedLinearProjection(WaveData waveData) {
        return this.linearProjections.getMostVisitedValue(waveData);
    }

    public long getHitCountByIndex(int index) {
        return this.bearingOffsets.getHitCountByIndex(index);
    }

    public TargetingMethod getFavoredTargetingMethod(WaveData waveData) {
        TargetingMethod preferredTargetingMethod = null;
        double preferredSuccessRate = 0.0;
        Iterator iterator = this.targetingStatistics.iterator();
        while (iterator.hasNext()) {
            TargetingStatistics stats = (TargetingStatistics)iterator.next();
            double successRate = stats.getSuccessRate();
            if (preferredTargetingMethod != null && !(successRate > preferredSuccessRate)) continue;
            preferredTargetingMethod = stats.getTargetingMethod();
            preferredSuccessRate = successRate;
        }
        return preferredTargetingMethod;
    }

    public void debug(String prefix) {
        Debug.debug(String.valueOf(prefix) + "][*]");
    }

    public void debug() {
        Debug.debug(String.valueOf(this.getClass().getSimpleName()) + ": No debug information defined.");
    }
}

