/*
 * Decompiled with CFR 0.152.
 */
package lechu;

import java.util.ArrayList;
import java.util.List;
import lechu.BulletSimulator;
import lechu.RobotSimulator;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Ala
extends AdvancedRobot {
    static int fieldWidth;
    static int fieldHeight;
    private static double CIRCLE_FULL;
    private static double CIRCLE_QUARTER;
    private static double CIRCLE_8;
    static int HISTORY_SIZE;
    static int HISTORY_AVERAGE;
    static int historyPointer;
    static double[] historyTurn;
    static double[] historyTurnAvg;
    static double[] historyVelocity;
    private double radarTurn;
    private List buletList;
    private double previousEnergy;
    private double previousHeading;
    private double previousVelocity;
    private RobotSimulator me;
    private int skipFire;
    private double bestSpin;

    public void run() {
        if (fieldWidth == 0) {
            this.MakeMovement();
        }
        fieldWidth = (int)this.getBattleFieldWidth();
        fieldHeight = (int)this.getBattleFieldHeight();
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.me = new RobotSimulator(fieldWidth, fieldHeight);
        this.skipFire = 0;
        while (true) {
            this.setTurnRadarRightRadians(this.radarTurn);
            this.radarTurn = this.radarTurn >= 0.0 ? CIRCLE_8 : -CIRCLE_8;
            int i = 0;
            while (i < this.buletList.size()) {
                BulletSimulator obj = (BulletSimulator)this.buletList.get(i);
                if (!obj.NextTime()) {
                    this.buletList.remove(obj);
                    --i;
                }
                ++i;
            }
            if (this.me != null) {
                double roznica = Math.sqrt(Math.pow(this.me.predictedX - this.getX(), 2) + Math.pow(this.me.predictedY - this.getY(), 2));
                this.me.SimulateTime();
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double x = this.getX();
        double y = this.getY();
        double heading = this.getHeadingRadians();
        double distance = e.getDistance();
        double bearing = e.getBearingRadians();
        double robotX = x + Math.sin(heading + bearing) * distance;
        double robotY = y + Math.cos(heading + bearing) * distance;
        double setRadar = heading + bearing + (this.radarTurn > 0.0 ? -0.39269908169872414 : 0.39269908169872414);
        if (setRadar > CIRCLE_FULL) {
            setRadar -= CIRCLE_FULL;
        }
        if (setRadar < 0.0) {
            setRadar += CIRCLE_FULL;
        }
        this.radarTurn = this.radarTurn < 0.0 ? (setRadar < 0.0 ? setRadar + CIRCLE_FULL : setRadar) : (setRadar > 0.0 ? setRadar - CIRCLE_FULL : (setRadar -= this.getRadarHeadingRadians()));
        double currentEnergy = e.getEnergy();
        double buletEnergy = this.previousEnergy - currentEnergy;
        if (buletEnergy >= 0.1 && buletEnergy <= (double)3 || this.getDistanceRemaining() == 0.0) {
            double realAngle = heading + bearing + Math.PI;
            if (realAngle < 0.0) {
                realAngle += CIRCLE_FULL;
            }
            BulletSimulator b1 = new BulletSimulator(robotX, robotY, realAngle %= CIRCLE_FULL, Rules.getBulletSpeed((double)buletEnergy));
            this.buletList.add(b1);
            double enemyFire = Rules.getBulletSpeed((double)buletEnergy);
            enemyFire = distance / enemyFire;
            double myPosX = x + Math.sin(heading) * this.getVelocity() * enemyFire;
            double myPosY = y + Math.cos(heading) * this.getVelocity() * enemyFire;
            double gap = Math.atan2(myPosX - robotX, myPosY - robotY);
            BulletSimulator b4 = new BulletSimulator(robotX, robotY, gap, Rules.getBulletSpeed((double)buletEnergy));
            this.buletList.add(b4);
            realAngle = gap;
            double x1 = myPosX + Math.sin(realAngle += CIRCLE_QUARTER) * 24.0;
            double y1 = myPosX + Math.cos(realAngle) * 24.0;
            gap = Math.atan2(x1 - robotX, y1 - robotY);
            if (gap < 0.0) {
                gap += CIRCLE_FULL;
            }
            BulletSimulator b2 = new BulletSimulator(robotX, robotY, gap %= CIRCLE_FULL, Rules.getBulletSpeed((double)buletEnergy));
            this.buletList.add(b2);
            x1 = x + Math.sin(realAngle -= CIRCLE_QUARTER) * 24.0;
            y1 = y + Math.cos(realAngle) * 24.0;
            gap = Math.atan2(x1 - robotX, y1 - robotY);
            if (gap < 0.0) {
                gap += CIRCLE_FULL;
            }
            BulletSimulator b3 = new BulletSimulator(robotX, robotY, gap %= CIRCLE_FULL, Rules.getBulletSpeed((double)buletEnergy));
            this.buletList.add(b3);
            double bestAngle = 0.0;
            double bestMove = 100.0;
            double destMove = (int)(Math.random() * 24.0) + 40;
            double destH = CIRCLE_QUARTER + 0.3490658503988659;
            double maximalDistance = 0.0;
            this.me.InitRobot(x, y, heading, this.getVelocity());
            double[] rank = new double[40];
            double[] rankAngle = new double[40];
            double[] rankMove = new double[40];
            double[] rankRemote = new double[40];
            int limit = 0;
            while (limit < 36) {
                this.me.AdditionalSettings(destH -= 0.3490658503988659, destMove);
                double minimalLocal = 8000.0;
                int k = 0;
                while (k < this.buletList.size()) {
                    ((BulletSimulator)this.buletList.get(k)).Reset();
                    ++k;
                }
                this.me.Reset();
                double robotsDist = 8000.0;
                int i = 0;
                while (i < 90) {
                    int k2 = 0;
                    while (k2 < this.buletList.size()) {
                        ((BulletSimulator)this.buletList.get(k2)).SimulateTime();
                        ++k2;
                    }
                    k2 = 0;
                    while (k2 < this.buletList.size()) {
                        BulletSimulator obj = (BulletSimulator)this.buletList.get(k2);
                        double avoider = Math.sqrt(Math.pow(this.me.predictedX - obj.predictedX, 2) + Math.pow(this.me.predictedY - obj.predictedY, 2));
                        if (avoider < minimalLocal) {
                            minimalLocal = avoider;
                        }
                        if (this.me.predictedX - 34.0 <= 0.0 || this.me.predictedX + 34.0 >= (double)fieldWidth || this.me.predictedY - 34.0 <= 0.0 || this.me.predictedY + 34.0 >= (double)fieldHeight) {
                            minimalLocal = 0.0;
                        }
                        double close = Math.pow(this.me.predictedX - robotX, 2) + Math.pow(this.me.predictedY - robotY, 2);
                        robotsDist = Math.sqrt(close);
                        if (close < 40000.0 && (close /= 1600.0) < minimalLocal) {
                            minimalLocal = close;
                        }
                        ++k2;
                    }
                    this.me.SimulateTime();
                    ++i;
                }
                rank[limit] = minimalLocal;
                rankAngle[limit] = destH;
                rankMove[limit] = destMove;
                rankRemote[limit] = robotsDist;
                if (maximalDistance < minimalLocal) {
                    maximalDistance = minimalLocal;
                    bestAngle = destH;
                    bestMove = destMove;
                }
                if (limit == 8 || limit == 26) {
                    destMove = -destMove;
                    destH = CIRCLE_QUARTER + 0.3490658503988659;
                }
                if (limit == 17) {
                    destMove = (int)(Math.random() * 67.0) + 200;
                    destH = CIRCLE_QUARTER + 0.3490658503988659;
                }
                ++limit;
            }
            int losuj = (int)(Math.random() * 35.0);
            int i = 0;
            while (i < 36) {
                if (rank[losuj] >= 32.0) {
                    bestAngle = rankAngle[losuj];
                    bestMove = rankMove[losuj];
                    break;
                }
                if (++losuj >= 40) {
                    losuj = 0;
                }
                ++i;
            }
            this.setAhead(bestMove);
            this.setTurnRightRadians(bestAngle);
            this.me.AdditionalSettings(bestAngle, bestMove);
            this.me.Reset();
            b1.NextTime();
            b2.NextTime();
            b3.NextTime();
            b4.NextTime();
        }
        this.previousEnergy = currentEnergy;
        double currentHeading = e.getHeadingRadians();
        double currentVelocity = e.getVelocity();
        double currentTurn = currentHeading - this.previousHeading;
        if (currentTurn > Math.PI) {
            currentTurn -= Math.PI * 2;
        }
        if (currentTurn < -Math.PI) {
            currentTurn += Math.PI * 2;
        }
        Ala.historyTurn[Ala.historyPointer] = currentTurn;
        Ala.historyTurnAvg[Ala.historyPointer] = this.averageTurn();
        Ala.historyVelocity[Ala.historyPointer] = currentVelocity;
        this.previousHeading = currentHeading;
        this.previousVelocity = currentVelocity;
        if (++historyPointer >= HISTORY_SIZE) {
            historyPointer = 0;
        }
        --this.skipFire;
        double myEnergy = this.getEnergy();
        if (myEnergy > (double)5) {
            double fireSpeed;
            double kat;
            double firePower;
            double d = firePower = myEnergy < 16.0 ? 0.4 : 600.0 / distance;
            if (firePower > (double)3) {
                firePower = 3;
            }
            if (firePower < 0.4) {
                firePower = 0.4;
            }
            if ((kat = this.SetGun(x, y, fireSpeed = Rules.getBulletSpeed((double)firePower), robotX, robotY, currentHeading) - this.getGunHeadingRadians()) > Math.PI) {
                kat -= Math.PI * 2;
            }
            if (kat < -Math.PI) {
                kat += Math.PI * 2;
            }
            this.setTurnGunRightRadians(kat);
            if (this.getGunHeat() == 0.0) {
                this.skipFire = (int)(distance / fireSpeed);
                this.setFireBullet(firePower);
            }
        }
    }

    private final double SetGun(double x, double y, double fireSpeed, double robotX, double robotY, double heading) {
        int position = this.findBestSimilarity();
        double buletDistance = fireSpeed;
        while (Math.pow(x - robotX, 2) + Math.pow(y - robotY, 2) >= buletDistance * buletDistance) {
            robotY += historyVelocity[position] * Math.cos(heading) * this.bestSpin;
            if ((robotX += historyVelocity[position] * Math.sin(heading += historyTurn[position] * this.bestSpin) * this.bestSpin) < 16.0 || robotX > (double)(fieldWidth - 16) || robotY < 16.0 || robotY > (double)(fieldHeight - 16)) {
                this.bestSpin = -this.bestSpin;
            }
            buletDistance += fireSpeed;
            if (++position < HISTORY_SIZE) continue;
            position = 0;
        }
        double kat = Math.atan2(robotX - x, robotY - y);
        return kat;
    }

    private final int findBestSimilarity() {
        int bestPosition = 0;
        double bestResult = 1.0E100;
        double spin = 1.0;
        int intSpin = 0;
        while (intSpin <= 1) {
            int position = historyPointer - 70;
            if (position < 0) {
                position = HISTORY_SIZE + position;
            }
            int i = 0;
            while (i < HISTORY_SIZE - 200) {
                double value = this.Similarity(position, spin);
                if (value < bestResult) {
                    if (value == 0.0) {
                        return position;
                    }
                    bestResult = value;
                    bestPosition = position;
                    this.bestSpin = spin;
                }
                if (--position < 0) {
                    position = HISTORY_SIZE - 1;
                }
                ++i;
            }
            spin = -1.0;
            ++intSpin;
        }
        return bestPosition;
    }

    private final double Similarity(int position, double spin) {
        double sumTurn = 0.0;
        double sumAvgTurn = 0.0;
        double sumVelocity = 0.0;
        int i = 0;
        int a = historyPointer;
        int b = position;
        while (i < 13) {
            if (--a < 0) {
                a = HISTORY_SIZE - 1;
            }
            if (--b < 0) {
                b = HISTORY_SIZE - 1;
            }
            sumAvgTurn += Math.abs(historyTurnAvg[b] * spin - historyTurnAvg[a]);
            sumVelocity += Math.pow(Math.abs(historyVelocity[b] * spin - historyVelocity[a]), 2);
            ++i;
        }
        return sumAvgTurn + sumVelocity;
    }

    private final double averageTurn() {
        double sum = 0.0;
        int pos = historyPointer;
        int i = 0;
        while (i < HISTORY_AVERAGE) {
            sum += historyTurn[pos];
            if (--pos < 0) {
                pos = HISTORY_SIZE - 1;
            }
            ++i;
        }
        return sum;
    }

    private final void MakeMovement() {
        double actualTurn = -0.6000000000000001;
        int j = 0;
        while (j < 24) {
            int i = 0;
            while (i < 90) {
                Ala.historyTurn[++Ala.historyPointer] = actualTurn;
                Ala.historyTurnAvg[Ala.historyPointer] = this.averageTurn();
                Ala.historyVelocity[Ala.historyPointer] = 8.0;
                ++i;
            }
            actualTurn += 0.05;
            ++j;
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
    }

    public void onBulletMissed(BulletMissedEvent event) {
    }

    public void onBulletHit(BulletHitEvent event) {
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        this.out.println("Za duzo do analizy");
    }

    private final /* synthetic */ void this() {
        this.radarTurn = CIRCLE_8;
        this.buletList = new ArrayList();
        this.previousEnergy = 100.0;
        this.bestSpin = 0.0;
    }

    public Ala() {
        this.this();
    }

    static {
        CIRCLE_FULL = Math.PI * 2;
        CIRCLE_QUARTER = 1.5707963267948966;
        CIRCLE_8 = 0.7853981633974483;
        HISTORY_SIZE = 5000;
        HISTORY_AVERAGE = 7;
        historyPointer = 0;
        historyTurn = new double[HISTORY_SIZE];
        historyTurnAvg = new double[HISTORY_SIZE];
        historyVelocity = new double[HISTORY_SIZE];
    }
}

