/*
 * Decompiled with CFR 0.152.
 */
package bjl;

import bjl.AvoidPoint;
import bjl.BattleField;
import bjl.Blip;
import bjl.EnemyBullet;
import bjl.EnemyList;
import bjl.ExtendedBlip;
import bjl.FireDemand;
import bjl.FireStrategyManager;
import bjl.Pattern;
import bjl.PatternBlip;
import bjl.PatternList;
import bjl.Point;
import bjl.Situation;
import bjl.SuperBlip;
import bjl.TSituation;
import bjl.Utils;
import bjl.fire.Avg2Linear;
import bjl.fire.AvgLinear;
import bjl.fire.AvgMove;
import bjl.fire.BulletDodge;
import bjl.fire.Close;
import bjl.fire.Dead;
import bjl.fire.Linear;
import bjl.fire.PatternMatch;
import bjl.fire.Random;
import bjl.fire.SituationMatch;
import bjl.fire.Straight;
import java.util.Enumeration;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Enemy {
    private String name;
    private Vector blips;
    private Vector patBlips;
    private Vector[] oldPBlips;
    private Vector fireTimes;
    private Vector tempFiredAt;
    private Vector[] firedAt;
    private boolean dead;
    private FireStrategyManager stratman;
    private FireStrategyManager stratMel;
    private FireStrategyManager stratOne;
    private boolean teamMate;
    private boolean bMe;
    private int type;
    private boolean validTarget;
    private long vTargTime;
    private Blip lastBlip;
    private Blip last2Blip;
    private PatternBlip lastPBlip;
    private PatternBlip last2PBlip;
    private Point lastPosition;
    private long lastTime;
    private double lastEnergy;
    private double recentDamage;
    private int curRound;
    private Blip noBlip;
    private PatternBlip noPBlip;
    private PatternList patList;
    private Pattern curPattern;
    private int patternTime;
    private boolean isMatching;
    protected Vector patternBuffer;

    public int getType() {
        return this.type;
    }

    public boolean isTeammate() {
        return this.teamMate;
    }

    public boolean isMe() {
        return this.bMe;
    }

    public boolean isValidTarget() {
        if (this.vTargTime <= BattleField.getTime() - (long)5) {
            this.getFireDemand();
        }
        return this.validTarget;
    }

    public void reInit() {
        this.dead = false;
        this.curRound = BattleField.getRound();
        if (this.curRound != 0) {
            this.oldPBlips[this.curRound - 1] = this.patBlips;
        }
        this.blips = new Vector();
        this.patBlips = new Vector();
        this.fireTimes = new Vector();
        this.tempFiredAt = new Vector();
        int i = 0;
        while ((long)i <= BattleField.getTime() + 1L) {
            this.blips.add(i, this.noBlip);
            this.patBlips.add(0, this.noPBlip);
            ++i;
        }
        this.validTarget = true;
        this.vTargTime = 4;
        this.lastBlip = new Blip();
        this.last2Blip = new Blip();
        this.lastPosition = new Point(0.0, 0.0);
        this.lastTime = -1;
        this.lastEnergy = -1.0;
        this.stratOne.reInit();
        this.stratMel.reInit();
    }

    public void info(String strategy, boolean hit) {
        this.stratman.info(strategy, hit);
    }

    public FireDemand getFireDemand() {
        FireDemand ans = this.stratman.getFireDemand(this);
        if (ans.power == 0.0) {
            this.validTarget = false;
            this.vTargTime = BattleField.getTime();
        } else {
            this.validTarget = true;
            this.vTargTime = BattleField.getTime();
        }
        return ans;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public Vector getPBlipVector(int round) {
        return this.oldPBlips[round];
    }

    public Point getLastPosition() {
        return this.lastPosition;
    }

    public Blip getLastBlip() {
        return this.lastBlip;
    }

    public Blip getLast2Blip() {
        return this.last2Blip;
    }

    public Blip getBlipBefore(long time) {
        Blip ans = null;
        int i = (int)time - 1;
        while (i >= 0) {
            ans = (Blip)this.blips.elementAt(i);
            if (ans != this.noBlip) break;
            ++i;
        }
        return ans;
    }

    public Blip getBlip(long time) {
        Blip ans = (Blip)this.blips.elementAt((int)time);
        if (ans != this.noBlip) {
            return ans;
        }
        return null;
    }

    public PatternBlip getPBlip(long time) {
        PatternBlip ans = (PatternBlip)this.patBlips.elementAt((int)time);
        if (ans != this.noPBlip) {
            return ans;
        }
        return null;
    }

    public PatternBlip getLastPBlip() {
        return this.lastPBlip;
    }

    public PatternBlip getLast2PBlip() {
        return this.last2PBlip;
    }

    public PatternBlip getPBlipBefore(long time) {
        PatternBlip ans = null;
        int i = (int)time - 1;
        while (i >= 0) {
            ans = (PatternBlip)this.patBlips.elementAt(i);
            if (ans != this.noPBlip) break;
            ++i;
        }
        return ans;
    }

    public PatternBlip getPBlip(long time, int round) {
        if (round == this.curRound) {
            PatternBlip ans = (PatternBlip)this.patBlips.elementAt((int)time);
            if (ans != this.noPBlip) {
                return ans;
            }
            return null;
        }
        PatternBlip ans = (PatternBlip)this.oldPBlips[round].elementAt((int)time);
        if (ans != this.noPBlip) {
            return ans;
        }
        return null;
    }

    public PatternBlip getPBlipBefore(long time, int round) {
        PatternBlip ans = null;
        if (round == this.curRound) {
            int i = (int)time - 1;
            while (i >= 0) {
                ans = (PatternBlip)this.patBlips.elementAt(i);
                if (ans != this.noPBlip) break;
                ++i;
            }
            return ans;
        }
        int i = (int)time - 1;
        while (i >= 0) {
            ans = (PatternBlip)this.oldPBlips[round].elementAt(i);
            if (ans != this.noPBlip) break;
            ++i;
        }
        return ans;
    }

    public long getRoundLength(int round) {
        if (round > this.curRound) {
            return -1;
        }
        if (round == this.curRound) {
            return this.getLastPBlip().time;
        }
        return this.oldPBlips[round].size();
    }

    public double getAvgVel(long timeFrom, long timeTo) {
        int count = 0;
        double avg = 0.0;
        if (timeFrom < 0L) {
            timeFrom = 0L;
        }
        if (timeTo > BattleField.getTime()) {
            timeTo = BattleField.getTime();
        }
        int i = (int)timeFrom;
        while (i <= (int)timeTo) {
            PatternBlip temp = (PatternBlip)this.patBlips.elementAt(i);
            if (temp != this.noPBlip) {
                avg += temp.vel;
                ++count;
            }
            ++i;
        }
        if (count != 0) {
            avg /= (double)count;
        }
        return avg;
    }

    public double getAvgDistVel(long timeFrom, long timeTo) {
        int count = 0;
        double avg = 0.0;
        if (timeFrom < 0L) {
            timeFrom = 0L;
        }
        if (timeTo > BattleField.getTime()) {
            timeTo = BattleField.getTime();
        }
        int i = (int)timeFrom;
        while (i <= (int)timeTo) {
            PatternBlip temp = (PatternBlip)this.patBlips.elementAt(i);
            if (temp != this.noPBlip) {
                avg += temp.distVel;
                ++count;
            }
            ++i;
        }
        if (count != 0) {
            avg /= (double)count;
        }
        return avg;
    }

    public double getAvgHeadChange(long timeFrom, long timeTo) {
        int count = 0;
        double avg = 0.0;
        if (timeFrom < 0L) {
            timeFrom = 0L;
        }
        if (timeTo > BattleField.getTime()) {
            timeTo = BattleField.getTime();
        }
        int i = (int)timeFrom;
        while (i <= (int)timeTo) {
            PatternBlip temp = (PatternBlip)this.patBlips.elementAt(i);
            if (temp != this.noPBlip) {
                avg += temp.turnRate;
                ++count;
            }
            ++i;
        }
        if (count != 0) {
            avg /= (double)count;
        }
        return avg;
    }

    public boolean haveBlip(long time) {
        if (time < 0L || time > BattleField.getTime()) {
            return false;
        }
        Object b = this.blips.elementAt((int)time);
        if (b == null) {
            this.blips.set((int)time, this.noBlip);
            this.patBlips.set((int)time, this.noPBlip);
            return false;
        }
        boolean bl = false;
        if (b != this.noBlip) {
            bl = true;
        }
        return bl;
    }

    public void addBlip(Blip b) {
        if (this.teamMate && !(b instanceof ExtendedBlip)) {
            BattleField.println("Tried to add a non-extended blip to a team mate");
            return;
        }
        if (!this.haveBlip(b.time)) {
            PatternBlip temp = this.noPBlip;
            this.blips.set((int)b.time, b);
            if (b.time > this.lastTime) {
                SuperBlip me = BattleField.getMe();
                double power = this.lastEnergy - b.energy;
                if (power >= 0.099999 && power <= 3.00001 && !this.teamMate) {
                    if (this.lastBlip.time != (long)-1) {
                        temp = new PatternBlip(Utils.normalRelativeAngle((b.head - this.lastBlip.head) / (double)(b.time - this.lastBlip.time)), b.vel, b.pos.dist(this.lastPosition) / (double)(b.time - this.lastBlip.time), power, b.time, b.roundnum, me.pos.dist(me.pos), me.head - me.pos.angleTo(b.pos));
                        this.patBlips.set((int)this.lastBlip.time, temp);
                    }
                    this.tempFiredAt.add(new TSituation(b.time, this.getLastPosition(), 20.0 - (double)3 * power));
                    Blip him = this.getBlip(b.time - 1L);
                    if (him == this.noBlip || him == null) {
                        him = b;
                    }
                    int numMatches = 0;
                    double angle = Utils.normalHeading(me.head - me.pos.angleTo(him.pos));
                    int i = (int)(angle / 10.0);
                    double dist = me.pos.dist(him.pos);
                    angle = Utils.normalRelativeAngle(angle);
                    double vel = me.vel;
                    double sqrt = 1.0 / Math.sqrt(this.curRound + 1);
                    int j = this.firedAt[i].size() - 1;
                    while (j >= 0) {
                        Situation s = (Situation)this.firedAt[i].elementAt(j);
                        if (Math.abs(s.dist - dist) <= Math.min(30.0, 30.0 * sqrt) && Math.abs(s.vel - vel) <= Math.min(0.7, 7.0 * sqrt) && Math.abs(s.angle - angle) <= Math.min(10.0, 25.0 * sqrt) && Math.abs(s.power - power) <= Math.min(0.5, 6.0 * sqrt)) {
                            boolean added = false;
                            Point pos = Point.makePoint(me.pos, Utils.normalHeading(s.moveHead + me.head), s.moveDist);
                            EnemyList.avoidPoints.add(new AvoidPoint(pos, (long)(dist / (20.0 - (double)3 * power) + (double)b.time), this, him.pos.angleTo(pos), 3));
                            if (numMatches == 0) {
                                EnemyList.enemyBullets.add(new EnemyBullet(him.pos.angleTo(pos), him.pos, this, b.time, 20.0 - (double)3 * power, 3));
                            }
                            if (++numMatches >= 3) break;
                        }
                        --j;
                    }
                    if (numMatches == 0) {
                        double speed = 20.0 - (double)3 * (this.lastEnergy - b.energy);
                        Point pos = new Point(me.pos);
                        long time = (long)(him.pos.dist(pos) / speed);
                        pos.x += me.vel * Math.sin(Math.toRadians(me.head)) * (double)time;
                        pos.y += me.vel * Math.cos(Math.toRadians(me.head)) * (double)time;
                        time = b.time + (long)(him.pos.dist(pos) / speed);
                        EnemyList.avoidPoints.add(new AvoidPoint(pos, time, this, him.pos.angleTo(pos), 1));
                    }
                    if (numMatches == 0) {
                        double speed = 20.0 - (double)3 * (this.lastEnergy - b.energy);
                        Point pos = new Point(me.pos);
                        long time = (long)(him.pos.dist(pos) / speed);
                        pos.x += me.vel * 0.5 * Math.sin(Math.toRadians(me.head)) * (double)time;
                        pos.y += me.vel * 0.5 * Math.cos(Math.toRadians(me.head)) * (double)time;
                        time = b.time + (long)(him.pos.dist(pos) / speed);
                        EnemyList.enemyBullets.add(new EnemyBullet(him.pos.angleTo(pos), him.pos, this, b.time, 20.0 - (double)3 * power, 1));
                    }
                    if (numMatches == 0) {
                        double speed = 20.0 - (double)3 * (this.lastEnergy - b.energy);
                        long time = b.time + (long)(him.pos.dist(me.pos) / speed);
                        EnemyList.avoidPoints.add(new AvoidPoint(me.pos, time, this, him.pos.angleTo(me.pos), 2));
                    }
                } else if (this.lastBlip.time != (long)-1) {
                    temp = new PatternBlip(Utils.normalRelativeAngle((b.head - this.lastBlip.head) / (double)(b.time - this.lastBlip.time)), b.vel, b.pos.dist(this.lastPosition) / (double)(b.time - this.lastBlip.time), 0.0, b.time, b.roundnum, me.pos.dist(me.pos), me.head - me.pos.angleTo(b.pos));
                    this.patBlips.set((int)this.lastBlip.time, temp);
                }
                this.lastTime = b.time;
                this.last2Blip = this.lastBlip;
                this.lastBlip = b;
                this.lastPosition = b.pos;
                this.last2PBlip = this.lastPBlip;
                this.lastPBlip = temp;
                this.lastEnergy = b.energy;
            }
        }
    }

    public void setDead() {
        this.dead = true;
    }

    public boolean isDead() {
        return this.dead;
    }

    public void doFire(double power) {
        this.fireTimes.add(new Long(BattleField.getTime()));
        this.stratman.doFire(power);
    }

    public void addDamage(double damage) {
        this.lastEnergy -= damage;
    }

    public void addDamageDone(double damage) {
        this.recentDamage += damage;
    }

    public double getRecentDamage() {
        return this.recentDamage;
    }

    public long getLastFireTime() {
        if (this.fireTimes.isEmpty()) {
            return -1;
        }
        return (Long)this.fireTimes.lastElement();
    }

    public long getFireTimeBefore(long time) {
        long t = -1;
        int i = this.fireTimes.size() - 1;
        while (i >= 0) {
            t = (Long)this.fireTimes.elementAt(i);
            if (t < time) break;
            --i;
        }
        if (i == -1) {
            return -1;
        }
        return t;
    }

    public long getRandomFireTimeBefore(long time) {
        long t = -1;
        int i = this.fireTimes.size() - 1;
        while (i >= 0) {
            t = (Long)this.fireTimes.elementAt(i);
            if (t < time) break;
            --i;
        }
        if (i == -1) {
            return -1;
        }
        i = (int)(Math.random() * (double)(i + 1));
        t = (Long)this.fireTimes.elementAt(i);
        return t;
    }

    public void doTick() {
        long time = BattleField.getTime();
        int i = this.blips.size() - 1;
        while (i <= (int)time + 1) {
            this.blips.add(i, this.noBlip);
            this.patBlips.add(i, this.noPBlip);
            ++i;
        }
        SuperBlip me = BattleField.getMe();
        if (this.isMatching && this.curPattern != null) {
            ++this.patternTime;
            if (this.patternTime > this.curPattern.getLength() - 10) {
                this.curPattern = null;
            }
        }
        this.stratman = EnemyList.getNumOpponents() <= 1 ? this.stratOne : this.stratMel;
        if (me.isByBullet) {
            Enemy eMe = EnemyList.getMe();
            Enumeration e = this.tempFiredAt.elements();
            while (e.hasMoreElements()) {
                TSituation ts = (TSituation)e.nextElement();
                double dist = me.pos.dist(ts.from);
                if (Math.abs((double)(time - ts.time) - dist / ts.speed) <= (double)3) {
                    Blip oldHim;
                    time = ts.time;
                    SuperBlip oldMe = (SuperBlip)eMe.getBlip(time - 1L);
                    if (oldMe == null) {
                        oldMe = (SuperBlip)eMe.getLastBlip();
                    }
                    if ((oldHim = this.getBlip(time - 1L)) == null) {
                        oldHim = this.getLastBlip();
                    }
                    double d = ts.from.dist(oldMe.pos);
                    double vel = oldMe.vel;
                    double angle = Utils.normalHeading(oldMe.head - oldMe.pos.angleTo(oldHim.pos));
                    double power = (20.0 - ts.speed) / (double)3;
                    double moveHead = oldMe.pos.angleTo(me.pos) - oldMe.head;
                    double moveDist = oldMe.pos.dist(me.pos);
                    int i2 = (int)(angle / 10.0);
                    angle = Utils.normalRelativeAngle(angle);
                    Situation s = new Situation(d, vel, angle, power, moveHead, moveDist);
                    this.firedAt[i2].add(s);
                    if (i2 == 0) {
                        this.firedAt[35].add(s);
                    } else {
                        this.firedAt[i2 - 1].add(s);
                    }
                    this.firedAt[(i2 + 1) % 36].add(s);
                    this.tempFiredAt.remove(ts);
                    continue;
                }
                if (!((double)(time - ts.time) - dist / ts.speed > (double)3)) continue;
                this.tempFiredAt.remove(ts);
            }
        }
        this.recentDamage *= 0.99;
        this.stratman.doTick();
    }

    public void skipped(long tick) {
        int i = this.blips.size() - 1;
        while (i <= (int)tick + 1) {
            this.blips.add(i, this.noBlip);
            this.patBlips.add(i, this.noPBlip);
            ++i;
        }
        if (this.isMatching && this.curPattern != null) {
            ++this.patternTime;
            if (this.patternTime > this.curPattern.getLength() - 10) {
                this.curPattern = null;
            }
        }
    }

    public void dumpStats() {
        this.stratman.dumpStats();
    }

    public boolean isTarget() {
        boolean bl = false;
        if (EnemyList.getTarget() == this) {
            bl = true;
        }
        return bl;
    }

    public PatternList getPatternList() {
        return this.patList;
    }

    public void setPattern(Pattern p, int time) {
        this.curPattern = p;
        this.patternTime = time;
        this.isMatching = false;
    }

    public Pattern getPattern() {
        return this.curPattern;
    }

    public int getPatternTime() {
        return this.patternTime;
    }

    public void startMatching() {
        this.isMatching = true;
    }

    public void resetStrategies() {
        this.stratMel = new FireStrategyManager(this);
        this.stratMel.addStrategy(new AvgLinear(this));
        this.stratMel.addStrategy(new Avg2Linear(this));
        this.stratMel.addStrategy(new AvgMove(this));
        this.stratMel.addStrategy(new Linear(this));
        this.stratMel.addStrategy(new Straight(this));
        this.stratMel.addStrategy(new PatternMatch(this));
        this.stratMel.addStrategy(new BulletDodge(this));
        this.stratMel.addStrategy(new Dead(this));
        this.stratMel.addStrategy(new Close(this));
        this.stratMel.addStrategy(new Random(this));
        this.stratMel.addStrategy(new SituationMatch(this));
        this.stratOne = new FireStrategyManager(this);
        this.stratOne.addStrategy(new AvgLinear(this));
        this.stratOne.addStrategy(new Avg2Linear(this));
        this.stratOne.addStrategy(new AvgMove(this));
        this.stratOne.addStrategy(new Linear(this));
        this.stratOne.addStrategy(new PatternMatch(this));
        this.stratOne.addStrategy(new BulletDodge(this));
        this.stratOne.addStrategy(new Close(this));
        this.stratOne.addStrategy(new Random(this));
        this.stratOne.addStrategy(new SituationMatch(this));
        this.stratOne.addStrategy(new Straight(this));
        this.stratOne.addStrategy(new Dead(this));
    }

    private final /* synthetic */ void this() {
        this.lastPBlip = null;
        this.last2PBlip = null;
        this.noBlip = new Blip();
        this.noPBlip = new PatternBlip();
    }

    public Enemy(String n, boolean mate, double energy, boolean Me) {
        this.this();
        this.name = n;
        this.teamMate = mate;
        this.bMe = Me;
        this.lastBlip = new Blip();
        this.lastPosition = new Point(0.0, 0.0);
        this.type = 1;
        if (energy > 180.0) {
            this.type = 2;
        } else if (energy > 110.0) {
            this.type = 0;
        }
        this.resetStrategies();
        this.firedAt = new Vector[36];
        int i = 0;
        while (i < 36) {
            this.firedAt[i] = new Vector();
            ++i;
        }
        this.oldPBlips = new Vector[BattleField.getNumRounds()];
        this.patList = new PatternList(this);
        this.patternBuffer = new Vector();
        this.reInit();
    }
}

