/*
 * Decompiled with CFR 0.152.
 */
package bjl;

import bjl.Enemy;
import bjl.Point;

public class EnemyBullet {
    private double angle;
    private Point from;
    private Enemy en;
    private long time;
    private double speed;
    private int type;

    public double getAngle() {
        return this.angle;
    }

    public Point getFrom() {
        return this.from;
    }

    public Enemy getEnemy() {
        return this.en;
    }

    public long getFireTime() {
        return this.time;
    }

    public double getSpeed() {
        return this.speed;
    }

    public int getType() {
        return this.type;
    }

    public Point getNearPoint(Point p, long curTime) {
        double hyp = this.from.dist(p);
        double theta = Math.toRadians(this.angle - this.from.angleTo(p));
        double adj = hyp * Math.cos(theta);
        double curMinDist = (double)(curTime - this.time) * this.speed;
        double curMaxDist = (double)(curTime + 15L - this.time) * this.speed;
        if (adj < curMinDist) {
            adj = curMinDist;
        } else if (adj > curMaxDist) {
            adj = curMaxDist;
        }
        return Point.makePoint(this.from, this.angle, adj);
    }

    public Point getPosition(long curTime) {
        return Point.makePoint(this.from, this.angle, this.speed * (double)(curTime - this.time));
    }

    public EnemyBullet(double a, Point f, Enemy e, long t, double s, int ty) {
        this.angle = a;
        this.from = f;
        this.en = e;
        this.time = t;
        this.speed = s;
        this.type = ty;
    }

    public EnemyBullet(EnemyBullet e) {
        this.angle = e.getAngle();
        this.from = e.getFrom();
        this.en = e.getEnemy();
        this.time = e.getFireTime();
        this.speed = e.getSpeed();
        this.type = e.getType();
    }
}

