/*
 * Decompiled with CFR 0.152.
 */
package bjl;

import bjl.AvoidPoint;
import bjl.BattleField;
import bjl.BulletTracker;
import bjl.Command;
import bjl.Enemy;
import bjl.EnemyBullet;
import bjl.FireDemand;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import robocode.Bullet;

public class EnemyList {
    private static Hashtable list;
    private static int numTeammates;
    private static int numOldTeammates;
    private static int numOpponents;
    private static int numOldOpponents;
    private static int numMatesRadar;
    private static int numOldMatesRadar;
    private static Hashtable bullets;
    public static Vector avoidPoints;
    public static Vector enemyBullets;
    private static Enemy target;
    private static Enemy lastTarget;

    public static void init() {
        list = new Hashtable();
        EnemyList.reInit();
    }

    public static void addEnemy(Enemy e) {
        list.put(e.getName(), e);
    }

    public static void rmEnemy(String name) {
        list.remove(name);
    }

    public static Enemy getEnemy(String name) {
        return (Enemy)list.get(name);
    }

    public static Enemy getMe() {
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            Enemy en = (Enemy)e.nextElement();
            if (!en.isMe()) continue;
            return en;
        }
        return null;
    }

    public static Enumeration getHashElements() {
        return list.elements();
    }

    public static int getNumOpponents() {
        return numOpponents;
    }

    public static int getNumTeammates() {
        return numTeammates;
    }

    public static int getNumAlive() {
        return numOpponents + numTeammates;
    }

    public static int getNumTeammatesWithRadar() {
        return numMatesRadar;
    }

    public static boolean numMatesChanged() {
        return numOldTeammates != numTeammates;
    }

    public static boolean numOppsChanged() {
        return numOldOpponents != numOpponents;
    }

    public static void reInit() {
        avoidPoints = new Vector();
        enemyBullets = new Vector();
        bullets = new Hashtable();
        target = null;
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            ((Enemy)e.nextElement()).reInit();
        }
    }

    public static void calculateInfo() {
        numOldMatesRadar = numMatesRadar;
        numOldOpponents = numOpponents;
        numOldTeammates = numTeammates;
        numMatesRadar = 0;
        numOpponents = 0;
        numTeammates = 0;
        Enumeration<Object> e = list.elements();
        while (e.hasMoreElements()) {
            Enemy en = (Enemy)e.nextElement();
            if (en.isTeammate() && !en.isDead()) {
                ++numTeammates;
            }
            if (en.isTeammate() && en.getType() != 0 && !en.isDead()) {
                ++numMatesRadar;
            }
            if (en.isTeammate() || en.isDead() || en.getLastBlip().time <= BattleField.getTime() - 12L || en.getLastBlip().roundnum != BattleField.getRound()) continue;
            ++numOpponents;
        }
        e = list.elements();
        while (e.hasMoreElements()) {
            ((Enemy)e.nextElement()).doTick();
        }
        e = avoidPoints.elements();
        long time = BattleField.getTime();
        while (e.hasMoreElements()) {
            AvoidPoint ap = (AvoidPoint)e.nextElement();
            if (ap.time >= time - (long)5) continue;
            avoidPoints.remove(ap);
        }
        e = enemyBullets.elements();
        while (e.hasMoreElements()) {
            EnemyBullet eb = (EnemyBullet)e.nextElement();
            if (!eb.getPosition(time).isOutsideArena()) continue;
            enemyBullets.remove(eb);
        }
    }

    public static void dumpStats() {
        if (BattleField.getOthers() == 1) {
            Enumeration e = list.elements();
            while (e.hasMoreElements()) {
                Enemy en = (Enemy)e.nextElement();
                if (en.isTeammate()) continue;
                en.dumpStats();
            }
        }
    }

    public static void skipped(long tick) {
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            ((Enemy)e.nextElement()).skipped(tick);
        }
    }

    public static void doFire(Bullet b, FireDemand dem) {
        if (dem.strat.getEnemy() != null) {
            bullets.put(b.toString(), new BulletTracker(b, dem.strat));
            dem.strat.getEnemy().doFire(dem.power);
        }
    }

    public static String doHit(Bullet b, String name) {
        BulletTracker t = (BulletTracker)bullets.remove(b.toString());
        if (t == null) {
            return null;
        }
        double damage = (double)4 * b.getPower();
        if (damage > (double)4) {
            damage += damage / (double)2 - (double)2;
        }
        EnemyList.getEnemy(name).addDamage(damage);
        if (t.hit(name)) {
            return t.getStratName();
        }
        return null;
    }

    public static Command doMiss(Bullet b) {
        BulletTracker t = (BulletTracker)bullets.remove(b.toString());
        if (t == null) {
            return null;
        }
        t.miss();
        return new Command(6, (Serializable)((Object)t.getName()), (Serializable)((Object)t.getStratName()));
    }

    public static void doHitBullet(Bullet b) {
        BulletTracker t = (BulletTracker)bullets.remove(b.toString());
    }

    public static void setTarget(Enemy t) {
        if (t == null) {
            target = null;
            return;
        }
        if (list.get(t.getName()) != null) {
            lastTarget = target = t;
        }
    }

    public static Enemy getTarget() {
        return target;
    }

    public static Enemy getLastTarget() {
        if (lastTarget == null) {
            return null;
        }
        if (lastTarget.isDead()) {
            return null;
        }
        return lastTarget;
    }

    public static void resetStrategies() {
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            ((Enemy)e.nextElement()).resetStrategies();
        }
    }

    static {
        numTeammates = 0;
        numOldTeammates = 0;
        numOpponents = 0;
        numOldOpponents = 0;
        numMatesRadar = 0;
        numOldMatesRadar = 0;
    }
}

