/*
 * Decompiled with CFR 0.152.
 */
package bjl.fire;

import bjl.BattleField;
import bjl.Blip;
import bjl.Enemy;
import bjl.FireDemand;
import bjl.Point;
import bjl.fire.VirtualBullet;
import java.util.Enumeration;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class FireStrategy {
    protected Enemy enemy;
    protected int bulletsFired;
    protected int bulletsHit;
    protected int bulletsMissed;
    protected int vBulletsHit;
    protected int vBulletsMissed;
    protected Vector vBullets;
    protected long lastvFire;
    protected long lastDoTick;
    protected boolean avb;
    protected double reqPower;

    public void setPower(double power) {
        this.reqPower = power;
    }

    protected double getPower(double dist) {
        if (this.reqPower == 0.0) {
            return (20.0 - dist / (50.0 * Math.sqrt(this.getProb()))) / (double)3;
        }
        double p = this.reqPower;
        this.reqPower = 0.0;
        return p;
    }

    public double getProb() {
        if (this.bulletsHit + this.bulletsMissed < 10) {
            if (this.vBulletsHit + this.vBulletsMissed < 10) {
                return 0.3;
            }
            if (this.allowVBullets()) {
                return ((double)this.bulletsHit * 18.0 + (double)this.vBulletsHit) / (double)(this.bulletsHit * 18 + this.bulletsMissed * 18 + this.vBulletsHit + this.vBulletsMissed);
            }
            return ((double)this.bulletsHit * (double)2 + (double)this.vBulletsHit) / (double)(this.bulletsHit * 2 + this.bulletsMissed * 2 + this.vBulletsHit + this.vBulletsMissed);
        }
        if (this.avb && Math.abs((double)this.bulletsHit / (double)(this.bulletsHit + this.bulletsMissed) - (double)this.vBulletsHit / (double)(this.vBulletsHit + this.vBulletsMissed)) > 0.35) {
            this.avb = false;
            this.vBulletsHit = 0;
            this.vBulletsMissed = 0;
        }
        if (this.allowVBullets()) {
            return ((double)this.bulletsHit * 18.0 + (double)this.vBulletsHit) / (double)(this.bulletsHit * 18 + this.bulletsMissed * 18 + this.vBulletsHit + this.vBulletsMissed);
        }
        return ((double)this.bulletsHit * (double)2 + (double)this.vBulletsHit) / (double)(this.bulletsHit * 2 + this.bulletsMissed * 2 + this.vBulletsHit + this.vBulletsMissed);
    }

    public void reInit() {
        this.vBullets = new Vector();
        this.lastvFire = this.lastDoTick = (long)-1;
    }

    public FireDemand doVirtual() {
        FireDemand dem = this.getFireDemand();
        if (this.allowVBullets() && dem.power != 0.0 && BattleField.getTime() != this.lastvFire && (BattleField.getTime() & 1L) == 0L) {
            this.vBullets.add(new VirtualBullet(BattleField.getPos(), 20.0 - dem.power * (double)3, dem.bearing));
            this.lastvFire = BattleField.getTime();
        }
        return dem;
    }

    public void doTick() {
        long time = BattleField.getTime();
        if (this.lastDoTick == time) {
            return;
        }
        if (this.lastDoTick != time - 1L) {
            this.vBullets.clear();
            this.lastDoTick = time;
            return;
        }
        this.lastDoTick = time;
        Enumeration e = this.vBullets.elements();
        Blip eBlip = this.enemy.getLastBlip();
        if (eBlip.time < time) {
            this.vBullets.clear();
        }
        while (e.hasMoreElements()) {
            VirtualBullet b = (VirtualBullet)e.nextElement();
            int hit = b.doTick(eBlip.pos);
            if (hit == 2) {
                this.vBullets.remove(b);
                ++this.vBulletsMissed;
                continue;
            }
            if (hit != 1) continue;
            this.vBullets.remove(b);
            ++this.vBulletsHit;
        }
    }

    public void doFire(double power) {
        if (!this.allowVBullets()) {
            FireDemand dem = this.getFireDemand();
            if (dem.power != 0.0 && BattleField.getTime() != this.lastvFire) {
                this.vBullets.add(new VirtualBullet(BattleField.getPos(), 20.0 - dem.power * (double)3, dem.bearing));
                this.lastvFire = BattleField.getTime();
            }
        }
    }

    public abstract Point getPosition(long var1);

    protected abstract FireDemand getFireDemand();

    public void fired() {
        ++this.bulletsFired;
    }

    public boolean hit(String name) {
        if (name.equals(this.enemy.getName())) {
            ++this.bulletsHit;
            return true;
        }
        return false;
    }

    public void miss() {
        if (this.enemy.isDead()) {
            return;
        }
        ++this.bulletsMissed;
    }

    public Enemy getEnemy() {
        return this.enemy;
    }

    protected boolean allowVBullets() {
        return this.avb;
    }

    public String stats() {
        int success = this.bulletsHit != 0 || this.bulletsMissed != 0 ? (int)((double)this.bulletsHit / (double)(this.bulletsHit + this.bulletsMissed) * 100.0) : 0;
        int vSuccess = this.vBulletsHit != 0 || this.vBulletsMissed != 0 ? (int)((double)this.vBulletsHit / (double)(this.vBulletsHit + this.vBulletsMissed) * 100.0) : 0;
        return this + ": Hit " + this.bulletsHit + ", Missed " + this.bulletsMissed + ", Success " + success + "%, vHit " + this.vBulletsHit + ", vMissed " + this.vBulletsMissed + ", vSuccess " + vSuccess + '%';
    }

    private final /* synthetic */ void this() {
        this.bulletsFired = 0;
        this.bulletsHit = 0;
        this.bulletsMissed = 0;
        this.vBulletsHit = 0;
        this.vBulletsMissed = 0;
        this.reqPower = 0.0;
    }

    public FireStrategy(Enemy e) {
        this.this();
        this.enemy = e;
        this.avb = true;
        this.reInit();
    }
}

