/*
 * Decompiled with CFR 0.152.
 */
package jaw;

import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.ScannedRobotEvent;

public class KarenCain
extends AdvancedRobot {
    private static final int[] dodgePattern;
    private static final double R90 = 1.5707963267948966;
    private static final double R45 = 0.7853981633974483;
    private static int dodgePosition;
    public double targetAbsoluteBearing;
    public double targetHeadingRadians;
    public double targetVelocity;
    public double targetDistance;
    public double targetEnergy;
    public double targetX;
    public double targetY;
    public long targetStartTime;

    static {
        int[] nArray = new int[6];
        nArray[0] = -1;
        nArray[1] = -1;
        nArray[3] = 1;
        nArray[4] = 1;
        dodgePattern = nArray;
    }

    public double guessTargetX(long len) {
        return this.targetX + Math.sin(this.targetHeadingRadians) * this.targetVelocity * (double)len;
    }

    public double guessTargetY(long len) {
        return this.targetY + Math.cos(this.targetHeadingRadians) * this.targetVelocity * (double)len;
    }

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.turnRadarLeftRadians(Double.NEGATIVE_INFINITY);
        }
    }

    void gun() {
        long time = this.getTime() - this.targetStartTime + (long)this.targetDistance / 11L;
        if (this.getGunHeat() == 0.0 && this.getTime() - this.targetStartTime < 10L && Math.max(0.01, (200.0 - this.targetDistance) / 1000.0) > Math.abs(Math.asin(Math.sin(this.getGunHeadingRadians() - this.absbearing(this.getX(), this.getY(), this.guessTargetX(time), this.guessTargetY(time)))))) {
            this.setFire(3.0);
        } else {
            this.setTurnGunLeftRadians(Math.asin(Math.sin(this.getGunHeadingRadians() - this.absbearing(this.getX() + Math.sin(this.getHeadingRadians()) * this.getVelocity(), this.getY() + Math.cos(this.getHeadingRadians()) * this.getVelocity(), this.guessTargetX(++time), this.guessTargetY(time)))));
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.setTurnRadarRightRadians(Math.tan(e.getBearingRadians() + this.getHeadingRadians() - this.getRadarHeadingRadians()) * 3.0);
        this.targetStartTime = this.getTime();
        this.targetAbsoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        this.targetHeadingRadians = e.getHeadingRadians();
        this.targetDistance = e.getDistance();
        this.targetVelocity = e.getVelocity();
        this.targetX = this.getX() + Math.sin(this.targetAbsoluteBearing) * this.targetDistance;
        this.targetY = this.getY() + Math.cos(this.targetAbsoluteBearing) * this.targetDistance;
        double offset = (double)dodgePattern[++dodgePosition % 6] * Math.max(Math.min(0.7853981633974483 * (100.0 - this.targetDistance) / 100.0, 0.7853981633974483), -0.7853981633974483);
        this.setTurnRightRadians(offset + this.targetAbsoluteBearing - this.getHeadingRadians() + 1.5707963267948966);
        if (this.getTime() - this.targetStartTime < 3L && this.targetEnergy != e.getEnergy()) {
            this.setAhead((double)dodgePattern[dodgePosition % 6] * (90.0 / Math.cos(offset)));
        }
        this.targetEnergy = e.getEnergy();
        this.gun();
    }

    public double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        if (xo > 0.0) {
            if (yo > 0.0) {
                return Math.asin(xo / h);
            }
            if (yo < 0.0) {
                return Math.PI - Math.asin(xo / h);
            }
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        return Math.PI * 2 - Math.asin(-xo / h);
    }

    public void onBulletHit(BulletHitEvent e) {
        this.targetEnergy = e.getEnergy();
    }
}

