/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp;

import dmonner.xlbp.WeightInitializer;
import java.util.Random;

public class UniformWeightInitializer
implements WeightInitializer {
    public static final long serialVersionUID = 1L;
    public final Random rand;
    public final float p;
    public final float min;
    public final float max;

    public UniformWeightInitializer() {
        this(new Random(), 1.0f);
    }

    public UniformWeightInitializer(float p) {
        this(new Random(), p, -0.1f, 0.1f);
    }

    public UniformWeightInitializer(float p, float min, float max) {
        this(new Random(), p, min, max);
    }

    public UniformWeightInitializer(Random rand) {
        this(rand, 1.0f);
    }

    public UniformWeightInitializer(Random rand, float p) {
        this(rand, p, -0.1f, 0.1f);
    }

    public UniformWeightInitializer(Random rand, float p, float min, float max) {
        if (p < 0.0f || p > 1.0f) {
            throw new IllegalArgumentException("p must be in [0, 1].");
        }
        this.rand = rand;
        this.p = p;
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean fullConnectivity() {
        return this.p == 1.0f;
    }

    @Override
    public boolean newWeight(int j, int i) {
        return this.rand.nextFloat() < this.p;
    }

    @Override
    public float randomWeight(int j, int i) {
        return this.rand.nextFloat() * (this.max - this.min) + this.min;
    }
}

