/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.compound;

import dmonner.xlbp.Component;
import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.NetworkStringBuilder;
import dmonner.xlbp.UpstreamComponent;
import dmonner.xlbp.WeightInitializer;
import dmonner.xlbp.WeightUpdaterType;
import dmonner.xlbp.compound.AbstractInternalCompound;
import dmonner.xlbp.compound.InternalCompound;
import dmonner.xlbp.layer.AbstractLayer;
import dmonner.xlbp.layer.DownstreamLayer;
import dmonner.xlbp.layer.FanOutLayer;
import dmonner.xlbp.layer.OffsetLayer;
import dmonner.xlbp.layer.PiLayer;
import dmonner.xlbp.layer.ScaleLayer;
import dmonner.xlbp.layer.SigmaLayer;
import dmonner.xlbp.util.MatrixTools;
import java.util.ArrayList;

public class ConvolutionCompound
extends AbstractInternalCompound
implements InternalCompound {
    private static final long serialVersionUID = 1L;
    private final int size;
    private final ScaleLayer scale;
    private final FanOutLayer af;
    private final FanOutLayer bf;
    private final OffsetLayer[] ao;
    private final OffsetLayer[] bo;
    private final PiLayer[] pi;
    private final SigmaLayer sigma;
    private FanOutLayer fanout;

    public ConvolutionCompound(ConvolutionCompound that, NetworkCopier copier) {
        super(that, copier);
        int i;
        this.size = that.size;
        this.fanout = copier.getCopyOf(that.fanout);
        this.scale = copier.getCopyOf(that.scale);
        this.sigma = copier.getCopyOf(that.sigma);
        this.pi = new PiLayer[this.size];
        for (i = 0; i < this.size; ++i) {
            this.pi[i] = copier.getCopyOf(that.pi[i]);
        }
        this.af = copier.getCopyOf(that.af);
        this.ao = new OffsetLayer[this.size];
        for (i = 0; i < this.size; ++i) {
            this.ao[i] = copier.getCopyOf(that.ao[i]);
        }
        this.bf = copier.getCopyOf(that.bf);
        this.bo = new OffsetLayer[this.size];
        for (i = 0; i < this.size; ++i) {
            this.bo[i] = copier.getCopyOf(that.bo[i]);
        }
        this.in = copier.getCopyOf(that.in);
        this.out = copier.getCopyOf(that.out);
    }

    public ConvolutionCompound(String name, int size) {
        super(name);
        int offset;
        int i;
        this.size = size;
        this.fanout = new FanOutLayer(name + "FanOut", size);
        this.scale = new ScaleLayer(name + "Scale", size, 1.0f / (float)size);
        this.sigma = new SigmaLayer(name + "Sigma", size);
        this.fanout.addUpstream(this.scale);
        this.scale.addUpstream(this.sigma);
        this.pi = new PiLayer[size];
        for (i = 0; i < size; ++i) {
            this.pi[i] = new PiLayer(name + "Pi" + i, size);
            this.sigma.addUpstream(this.pi[i]);
        }
        this.af = new FanOutLayer(name + "FanOutA", size);
        this.ao = new OffsetLayer[size];
        for (i = 0; i < size; ++i) {
            offset = i;
            this.ao[i] = new OffsetLayer(name + "OffsetA" + offset, size, offset);
            this.ao[i].addUpstream(this.af);
            this.pi[i].addUpstream(this.ao[i]);
        }
        this.bf = new FanOutLayer(name + "FanOutB", size);
        this.bo = new OffsetLayer[size];
        for (i = 0; i < size; ++i) {
            offset = size - i;
            this.bo[i] = new OffsetLayer(name + "OffsetB" + offset, size, offset);
            this.bo[i].addUpstream(this.bf);
            this.pi[i].addUpstream(this.bo[i]);
        }
        this.in = this.af;
        this.out = this.fanout;
    }

    @Override
    public void activateTest() {
        for (int i = 0; i < this.size; ++i) {
            this.ao[i].activateTest();
            this.bo[i].activateTest();
            this.pi[i].activateTest();
        }
        this.sigma.activateTest();
        this.scale.activateTest();
    }

    @Override
    public void activateTrain() {
        for (int i = 0; i < this.size; ++i) {
            this.ao[i].activateTrain();
            this.bo[i].activateTrain();
            this.pi[i].activateTrain();
        }
        this.sigma.activateTrain();
        this.scale.activateTrain();
    }

    @Override
    public void addUpstream(UpstreamComponent upstream) {
        if (this.af.nUpstream() == 0) {
            this.af.addUpstream(upstream);
        } else if (this.bf.nUpstream() == 0) {
            this.bf.addUpstream(upstream);
        } else {
            throw new IllegalStateException("ConvolutionCompound already has two inputs.");
        }
    }

    @Override
    public void build() {
        if (!this.built) {
            this.af.build();
            this.bf.build();
            for (int i = 0; i < this.size; ++i) {
                this.ao[i].build();
                this.bo[i].build();
                this.pi[i].build();
            }
            this.sigma.build();
            this.scale.build();
            if (this.fanout != null) {
                this.fanout.build();
            }
            this.built = true;
        }
    }

    @Override
    public void clearActivations() {
        this.af.clearActivations();
        this.bf.clearActivations();
        for (int i = 0; i < this.size; ++i) {
            this.ao[i].clearActivations();
            this.bo[i].clearActivations();
            this.pi[i].clearActivations();
        }
        this.sigma.clearActivations();
        this.scale.clearActivations();
    }

    @Override
    public void clearEligibilities() {
    }

    @Override
    public void clearResponsibilities() {
        this.af.clearResponsibilities();
        this.bf.clearResponsibilities();
        for (int i = 0; i < this.size; ++i) {
            this.ao[i].clearResponsibilities();
            this.bo[i].clearResponsibilities();
            this.pi[i].clearResponsibilities();
        }
        this.sigma.clearResponsibilities();
        this.scale.clearResponsibilities();
    }

    @Override
    public ConvolutionCompound copy(NetworkCopier copier) {
        return new ConvolutionCompound(this, copier);
    }

    @Override
    public ConvolutionCompound copy(String nameSuffix) {
        NetworkCopier copier = new NetworkCopier(nameSuffix);
        ConvolutionCompound copy = this.copy(copier);
        copier.build();
        return copy;
    }

    @Override
    public Component[] getComponents() {
        ArrayList<AbstractLayer> list = new ArrayList<AbstractLayer>();
        list.add(this.af);
        list.add(this.bf);
        for (int i = 0; i < this.size; ++i) {
            list.add(this.ao[i]);
            list.add(this.bo[i]);
            list.add(this.pi[i]);
        }
        list.add(this.sigma);
        list.add(this.scale);
        if (this.fanout != null) {
            list.add(this.fanout);
        }
        return list.toArray(new Component[list.size()]);
    }

    @Override
    public DownstreamLayer getInput() {
        return this.af;
    }

    @Override
    public DownstreamLayer getInput(int index) {
        if (index == 0) {
            return this.af;
        }
        if (index == 1) {
            return this.bf;
        }
        throw new IllegalArgumentException("Index too large.");
    }

    @Override
    public int nInputs() {
        return 2;
    }

    @Override
    public int nWeights() {
        return 0;
    }

    @Override
    public boolean optimize() {
        if (!super.optimize()) {
            return false;
        }
        if (this.af.nUpstream() == 0 || this.bf.nUpstream() == 0) {
            throw new IllegalArgumentException("Do not have the two required inputs.");
        }
        this.af.optimize();
        this.bf.optimize();
        for (int i = 0; i < this.size; ++i) {
            this.ao[i].optimize();
            this.bo[i].optimize();
            this.pi[i].optimize();
        }
        this.sigma.optimize();
        this.scale.optimize();
        if (this.fanout != null && !this.fanout.optimize()) {
            this.fanout = null;
            this.out = this.sigma;
        }
        return true;
    }

    @Override
    public void processBatch() {
    }

    @Override
    public void setWeightInitializer(WeightInitializer win) {
    }

    @Override
    public void setWeightUpdaterType(WeightUpdaterType wut) {
    }

    @Override
    public void toString(NetworkStringBuilder sb) {
        if (sb.showIntermediate()) {
            int i;
            super.toString(sb);
            sb.pushIndent();
            if (this.fanout != null) {
                this.fanout.toString(sb);
            }
            this.scale.toString(sb);
            this.sigma.toString(sb);
            for (i = 0; i < this.size; ++i) {
                this.pi[i].toString(sb);
            }
            for (i = 0; i < this.size; ++i) {
                this.bo[i].toString(sb);
            }
            for (i = 0; i < this.size; ++i) {
                this.ao[i].toString(sb);
            }
            this.bf.toString(sb);
            this.af.toString(sb);
            sb.popIndent();
        } else {
            super.toString(sb);
            sb.pushIndent();
            if (sb.showActivations()) {
                sb.appendln("Activations:");
                sb.pushIndent();
                sb.appendln(MatrixTools.toString(this.sigma.getActivations()));
                sb.popIndent();
            }
            if (sb.showResponsibilities()) {
                sb.appendln("Responsibilities B:");
                sb.pushIndent();
                sb.appendln(this.bf.getResponsibilities().toString());
                sb.popIndent();
                sb.appendln("Responsibilities A:");
                sb.pushIndent();
                sb.appendln(this.af.getResponsibilities().toString());
                sb.popIndent();
            }
        }
    }

    @Override
    public void updateEligibilities() {
        if (this.fanout != null) {
            this.fanout.updateEligibilities();
        }
        this.scale.updateEligibilities();
        this.sigma.updateEligibilities();
        for (int i = 0; i < this.size; ++i) {
            this.pi[i].updateEligibilities();
            this.bo[i].updateEligibilities();
            this.ao[i].updateEligibilities();
        }
        this.af.updateEligibilities();
        this.bf.updateEligibilities();
    }

    @Override
    public void updateResponsibilities() {
        if (this.fanout != null) {
            this.fanout.updateResponsibilities();
        }
        this.scale.updateResponsibilities();
        this.sigma.updateResponsibilities();
        for (int i = 0; i < this.size; ++i) {
            this.pi[i].updateResponsibilities();
            this.bo[i].updateResponsibilities();
            this.ao[i].updateResponsibilities();
        }
        this.af.updateResponsibilities();
        this.bf.updateResponsibilities();
    }

    @Override
    public void updateWeights() {
    }
}

