/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.connection;

import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.NetworkStringBuilder;
import dmonner.xlbp.Responsibilities;
import dmonner.xlbp.WeightInitializer;
import dmonner.xlbp.WeightUpdater;
import dmonner.xlbp.WeightUpdaterType;
import dmonner.xlbp.connection.LayerConnection;
import dmonner.xlbp.layer.WeightReceiverLayer;
import dmonner.xlbp.layer.WeightSenderLayer;

public class IndirectConnection
extends LayerConnection {
    private static final long serialVersionUID = 1L;

    public IndirectConnection(IndirectConnection that, NetworkCopier copier) {
        super(that, copier);
    }

    public IndirectConnection(String name, WeightReceiverLayer to, WeightSenderLayer from) {
        super(name, to, from);
        if (to.size() != from.size()) {
            throw new IllegalArgumentException("To and From layers must be equal sizes.");
        }
    }

    public IndirectConnection(WeightReceiverLayer to, WeightSenderLayer from) {
        this(from.getName() + "IndirectTo" + to.getName(), to, from);
    }

    @Override
    public void activateTest() {
        System.arraycopy(this.from.getActivations(), 0, this.to.getActivations(), 0, this.to.size());
    }

    @Override
    public void activateTrain() {
        System.arraycopy(this.from.getActivations(), 0, this.to.getActivations(), 0, this.to.size());
    }

    @Override
    public void clear() {
    }

    @Override
    public IndirectConnection copy(NetworkCopier copier) {
        return new IndirectConnection(this, copier);
    }

    @Override
    public float[] getCachedInput() {
        return this.from.getActivations();
    }

    @Override
    public float getWeight(int j, int i) {
        return 0.0f;
    }

    @Override
    public void initializeAlphas(WeightUpdater lrs) {
    }

    @Override
    public void initializeWeights(WeightInitializer win) {
    }

    @Override
    public int nWeights() {
        return 0;
    }

    @Override
    public void processBatch() {
    }

    @Override
    public void setWeightInitializer(WeightInitializer win) {
    }

    @Override
    public void setWeightUpdater(WeightUpdaterType wut) {
    }

    @Override
    public float[][] toEligibilitiesMatrix() {
        return new float[0][0];
    }

    @Override
    public float[][] toMatrix() {
        return new float[0][0];
    }

    @Override
    public void toString(NetworkStringBuilder sb) {
        if (sb.showName()) {
            sb.indent();
            sb.append(this.name);
            sb.append(" : ");
            sb.append(this.getClass().getSimpleName());
            sb.appendln();
        }
    }

    @Override
    public void updateEligibilities(Responsibilities resp, Responsibilities prev) {
    }

    @Override
    public void updateResponsibilities() {
        float[] td = this.getToLayerResponsibilities();
        float[] fd = this.getFromLayerResponsibilities();
        System.arraycopy(td, 0, fd, 0, fd.length);
    }

    @Override
    public void updateWeights(float[][] dw) {
    }

    @Override
    public void updateWeightsFromEligibilities(Responsibilities copyresp) {
    }

    @Override
    public void updateWeightsFromInputs(Responsibilities resp) {
    }
}

