/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.stat;

import dmonner.xlbp.stat.AbstractStat;
import dmonner.xlbp.stat.FractionStat;
import dmonner.xlbp.stat.Stat;
import dmonner.xlbp.stat.TargetSetStat;
import dmonner.xlbp.stat.TrialStat;
import dmonner.xlbp.util.CSVWriter;
import java.io.IOException;
import java.util.Map;

public class SetStat
extends AbstractStat {
    private final String name;
    private final TargetSetStat targets;
    private final FractionStat stepsCorrect;
    private final FractionStat trialsCorrect;

    public SetStat() {
        this("");
    }

    public SetStat(String name) {
        this.name = name;
        this.targets = new TargetSetStat();
        this.stepsCorrect = new FractionStat("Steps");
        this.trialsCorrect = new FractionStat("Trials");
    }

    public SetStat(String name, Iterable<TrialStat> evaluations) {
        this(name);
        for (TrialStat eval : evaluations) {
            this.add(eval);
        }
        this.analyze();
    }

    public SetStat(String name, TrialStat[] evaluations) {
        this(name);
        for (TrialStat eval : evaluations) {
            this.add(eval);
        }
        this.analyze();
    }

    public void add(SetStat that) {
        this.targets.add(that.targets);
        this.stepsCorrect.add(that.stepsCorrect);
        this.trialsCorrect.add(that.trialsCorrect);
    }

    @Override
    public void add(Stat that) {
        if (that instanceof SetStat) {
            this.add((SetStat)that);
        } else if (that instanceof TrialStat) {
            this.add((TrialStat)that);
        } else {
            throw new IllegalArgumentException("Can only add in SetStats or TrialStats.");
        }
    }

    public void add(TrialStat that) {
        this.targets.add(that.getTargets());
        this.stepsCorrect.add(that.getStepsCorrect());
        this.trialsCorrect.add(that.getTrialCorrect());
    }

    @Override
    public void addTo(String prefix, Map<String, Object> map) {
        map.put(prefix + "SetName", this.name);
        this.trialsCorrect.addTo(prefix, map);
        this.stepsCorrect.addTo(prefix, map);
        this.targets.addTo(prefix, map);
    }

    @Override
    public void analyze() {
        this.targets.analyze();
        this.stepsCorrect.analyze();
        this.trialsCorrect.analyze();
    }

    @Override
    public void clear() {
        this.targets.clear();
        this.stepsCorrect.clear();
        this.trialsCorrect.clear();
    }

    public FractionStat getStepStats() {
        return this.stepsCorrect;
    }

    public TargetSetStat getTargetStats() {
        return this.targets;
    }

    public FractionStat getTrialStats() {
        return this.trialsCorrect;
    }

    @Override
    public void saveData(CSVWriter out) throws IOException {
        out.beginRecord();
        out.appendField(this.name);
        this.trialsCorrect.saveData(out);
        this.stepsCorrect.saveData(out);
        this.targets.saveData(out);
    }

    @Override
    public void saveHeader(String prefix, CSVWriter out) throws IOException {
        out.beginRecord();
        out.appendHeader(prefix + "name");
        this.trialsCorrect.saveHeader(prefix, out);
        this.stepsCorrect.saveHeader(prefix, out);
        this.targets.saveHeader(prefix, out);
    }

    @Override
    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append("SetName = ");
        sb.append(prefix);
        sb.append(this.name);
        sb.append("\n");
        sb.append(this.trialsCorrect.toString(prefix));
        sb.append(this.stepsCorrect.toString(prefix));
        sb.append(this.targets.toString(prefix));
        return sb.toString();
    }
}

