/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.stat;

import dmonner.xlbp.layer.Layer;
import dmonner.xlbp.stat.AbstractStat;
import dmonner.xlbp.stat.BitStat;
import dmonner.xlbp.stat.ErrorStat;
import dmonner.xlbp.stat.FractionStat;
import dmonner.xlbp.stat.Stat;
import dmonner.xlbp.stat.TargetStat;
import dmonner.xlbp.util.CSVWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class TargetSetStat
extends AbstractStat {
    private final Map<Layer, TargetStat> targets = new TreeMap<Layer, TargetStat>();
    private final BitStat bits = new BitStat("TotalBits");
    private final ErrorStat error = new ErrorStat("TotalError");
    private final FractionStat correct = new FractionStat("TotalCorrect");
    private int size;

    @Override
    public void add(Stat that) {
        if (that instanceof TargetStat) {
            this.add((TargetStat)that);
        } else if (that instanceof TargetSetStat) {
            this.add((TargetSetStat)that);
        } else {
            throw new IllegalArgumentException("Can only add in other StepStats.");
        }
    }

    public void add(TargetSetStat that) {
        this.size += that.size;
        for (TargetStat stat : that.targets.values()) {
            this.add(stat);
        }
    }

    public void add(TargetStat that) {
        TargetStat existing = this.targets.get(that.getLayer());
        if (existing == null) {
            this.targets.put(that.getLayer(), new TargetStat(that));
        } else {
            existing.add(that);
        }
        ++this.size;
    }

    @Override
    public void addTo(String prefix, Map<String, Object> map) {
        for (TargetStat stat : this.targets.values()) {
            stat.addTo(prefix, map);
        }
    }

    @Override
    public void analyze() {
        this.bits.clear();
        this.error.clear();
        this.correct.clear();
        for (TargetStat stat : this.targets.values()) {
            stat.analyze();
            this.bits.add(stat.getBits());
            this.error.add(stat.getError());
            this.correct.add(stat.getCorrect());
        }
        this.bits.analyze();
        this.error.analyze();
        this.correct.analyze();
    }

    @Override
    public void clear() {
        this.targets.clear();
        this.bits.clear();
        this.error.clear();
        this.correct.clear();
    }

    public BitStat getBits() {
        return this.bits;
    }

    public FractionStat getCorrect() {
        return this.correct;
    }

    public ErrorStat getError() {
        return this.error;
    }

    public TargetStat getTargetStat(Layer layer) {
        return this.targets.get(layer);
    }

    public Collection<TargetStat> getTargetStats() {
        return this.targets.values();
    }

    @Override
    public void saveData(CSVWriter out) throws IOException {
        this.correct.saveData(out);
        this.error.saveData(out);
        this.bits.saveData(out);
        for (TargetStat stat : this.targets.values()) {
            stat.saveData(out);
        }
    }

    @Override
    public void saveHeader(String prefix, CSVWriter out) throws IOException {
        this.correct.saveHeader(prefix, out);
        this.error.saveHeader(prefix, out);
        this.bits.saveHeader(prefix, out);
        for (TargetStat stat : this.targets.values()) {
            stat.saveHeader(prefix, out);
        }
    }

    public int size() {
        return this.size;
    }

    @Override
    public String toString(String prefix) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.correct.toString(prefix));
        sb.append(this.error.toString(prefix));
        sb.append(this.bits.toString(prefix));
        for (TargetStat stat : this.targets.values()) {
            sb.append(stat.toString(prefix));
        }
        return sb.toString();
    }
}

