/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.trial;

import dmonner.xlbp.Network;
import dmonner.xlbp.trial.TrialStream;

public abstract class AbstractTrialStream
implements TrialStream {
    private final String name;
    private final Network meta;
    private final int ntrain;
    private final int ntest;
    private final int nvalid;
    private final int nfolds;

    protected static String makeSplitString(int train, int test, int valid) {
        return train + "/" + test + "/" + valid;
    }

    public AbstractTrialStream(String name, Network net) {
        this(name, net, 1, 0, 0);
    }

    public AbstractTrialStream(String name, Network net, int train, int test, int valid) {
        this(name, net, AbstractTrialStream.makeSplitString(train, test, valid));
    }

    public AbstractTrialStream(String name, Network net, String split) {
        String[] fields = split.split("/");
        if (fields.length < 1 || fields.length > 3) {
            throw new IllegalArgumentException("Need 1-3 fields in split string; found " + fields.length + " in: " + split);
        }
        this.name = name;
        this.meta = net;
        try {
            this.ntrain = Integer.parseInt(fields[0]);
            this.nvalid = fields.length > 1 ? Integer.parseInt(fields[1]) : 0;
            this.ntest = fields.length > 2 ? Integer.parseInt(fields[2]) : 0;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Malformed split string; all entries must be numbers: " + split, ex);
        }
        this.nfolds = this.ntrain + this.ntest + this.nvalid;
        if (this.ntrain < 0 || this.ntest < 0 || this.nvalid < 0) {
            throw new IllegalArgumentException("Negative folds not allowed.");
        }
        if (this.ntrain == 0 && this.ntest == 0) {
            throw new IllegalArgumentException("Need at least 1 training or testing fold.");
        }
        if (this.ntest == 0 && this.nvalid > 0) {
            throw new IllegalArgumentException("Cannot use validation set without testing.");
        }
        if (this.ntrain == 0 && this.nvalid > 0) {
            throw new IllegalArgumentException("Cannot use validation set without training.");
        }
        if (this.ntrain == 0 && this.ntest != 1) {
            throw new IllegalArgumentException("Testing alone must be done with a single fold.");
        }
        if (this.ntest == 0 && this.ntrain != 1) {
            throw new IllegalArgumentException("Training alone must be done with a single fold.");
        }
    }

    @Override
    public Network getMetaNetwork() {
        return this.meta;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int nFolds() {
        return this.nfolds;
    }

    @Override
    public int nTestFolds() {
        return this.ntest;
    }

    @Override
    public int nTrainFolds() {
        return this.ntrain;
    }

    @Override
    public int nValidationFolds() {
        return this.nvalid;
    }
}

